/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.util.ObjectToMapUtil;
import com.bcxin.platform.util.ResultJson;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjectToMapUtil.class);
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    private static final String APPLICATION_JSON = "application/json";

    public static ResultJson sendHttp(String url, Object obj) {
        return HttpUtils.sendHttp(url, obj, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postJsonString(String url, String json) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("Content-Type", APPLICATION_JSON);
            if (StringUtils.isNotEmpty((String)json)) {
                StringEntity se = new StringEntity(json, StandardCharsets.UTF_8);
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
                httppost.setEntity((HttpEntity)se);
            }
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity == null) return "";
                String string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static ResultJson sendHttp(String url, Object obj, Class clazz) {
        Map<String, Object> paramMap = obj == null ? null : ObjectToMapUtil.ObjectToMap(obj);
        ResultJson resultJson = new ResultJson();
        try {
            logger.info("\u53c2\u6570: " + paramMap.toString());
            String result = HttpUtils.doPost(url, paramMap);
            if (!JSONUtil.isJson((String)result)) {
                resultJson.setSuccessful(false);
                resultJson.setData(result);
                resultJson.setMsg(result);
                return resultJson;
            }
            JSONObject jsonback = JSONUtil.parseObj((String)result);
            logger.info("\u7ed3\u679c: " + jsonback.toString());
            if (Boolean.valueOf(String.valueOf(jsonback.get((Object)"successful"))).booleanValue()) {
                resultJson.setSuccessful(true);
            } else {
                resultJson.setSuccessful(false);
            }
            resultJson.setData(jsonback.get((Object)"data"));
            if (jsonback.get((Object)"msg") != null && !"null".equals(jsonback.get((Object)"msg").toString())) {
                resultJson.setMsg(jsonback.get((Object)"msg").toString());
            } else {
                resultJson.setMsg("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return resultJson;
    }

    public static ResultJson pairSendHttp(String url, Map<String, String> data) {
        ResultJson resultJson = new ResultJson();
        try {
            String result;
            logger.info("\u5f00\u59cb\u8bf7\u6c42\u63a5\u53e3\u5730\u5740:" + url);
            logger.info("\u53c2\u6570: " + data.toString());
            ArrayList pairList = Lists.newArrayList();
            if (MapUtil.isNotEmpty(data)) {
                for (Map.Entry<String, String> elem : data.entrySet()) {
                    pairList.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
                }
            }
            if (StringUtils.isEmpty((String)(result = HttpUtils.doPost(url, pairList)))) {
                resultJson.setSuccessful(false);
                resultJson.setMsg("\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\uff01");
                return resultJson;
            }
            JSONObject jsonback = JSONUtil.parseObj((String)result);
            logger.info("\u53c2\u6570: " + jsonback.toString());
            if (Boolean.valueOf(String.valueOf(jsonback.get((Object)"successful"))).booleanValue()) {
                resultJson.setSuccessful(true);
            } else {
                resultJson.setSuccessful(false);
            }
            resultJson.setData(jsonback.get((Object)"data"));
            if (jsonback.get((Object)"msg") != null && !"null".equals(jsonback.get((Object)"msg").toString())) {
                resultJson.setMsg(jsonback.get((Object)"msg").toString());
            } else {
                resultJson.setMsg("");
            }
            logger.info("\u7ed3\u675f\u8bf7\u6c42\u63a5\u53e3\u5730\u5740:" + url);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return resultJson;
    }

    public static Result sendHttpRt(String url, Map map) {
        Result ret = Result.fail((String)"\u63a5\u53e3\u8fd4\u56de\u7a7a");
        try {
            logger.info("\u5f00\u59cb\u8bf7\u6c42\u63a5\u53e3\u5730\u5740:" + url);
            logger.info("\u8bf7\u6c42\u62a5\u6587: " + map.toString());
            String result = HttpUtils.doPost(url, map);
            if (StringUtils.isNotEmpty((String)result)) {
                logger.info("\u8fd4\u56de\u62a5\u6587: " + result);
                ret = (Result)JSONUtil.toBean((String)result, Result.class);
            }
            logger.info("\u7ed3\u675f\u8bf7\u6c42\u63a5\u53e3\u5730\u5740:" + url);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            ret = Result.fail((String)e.getMessage());
        }
        return ret;
    }

    public static ResultJson sendHttpMap(String url, Map<String, Object> paramMap) {
        ResultJson resultJson = new ResultJson();
        try {
            String result = HttpUtils.doPost(url, paramMap);
            if (StringUtils.isEmpty((String)result)) {
                resultJson.setSuccessful(false);
                resultJson.setMsg("\u672a\u83b7\u53d6\u5230\u6570\u636e");
                return resultJson;
            }
            JSONObject jsonback = JSONUtil.parseObj((String)result);
            logger.info("\u53c2\u6570: " + jsonback.toString());
            if (Boolean.valueOf(String.valueOf(jsonback.get((Object)"successful"))).booleanValue()) {
                resultJson.setSuccessful(true);
            } else {
                resultJson.setSuccessful(false);
            }
            resultJson.setData(jsonback.get((Object)"data"));
            if (jsonback.get((Object)"msg") != null && !"null".equals(jsonback.get((Object)"msg").toString())) {
                resultJson.setMsg(jsonback.get((Object)"msg").toString());
            } else {
                resultJson.setMsg("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return resultJson;
    }

    public static ResultJson sendHttpMapForTrain(String url, Map<String, Object> paramMap) {
        ResultJson resultJson = new ResultJson();
        try {
            String result = HttpUtils.doPost(url, paramMap);
            JSONObject jsonback = JSONUtil.parseObj((String)result);
            if (jsonback.get((Object)"retType") != null && !ObjectUtil.equal((Object)jsonback.get((Object)"retType"), (Object)"-1")) {
                resultJson.setSuccessful(true);
            } else {
                resultJson.setSuccessful(false);
            }
            resultJson.setData(jsonback.get((Object)"data"));
            if (jsonback.get((Object)"msg") != null && !"null".equals(jsonback.get((Object)"msg").toString())) {
                resultJson.setMsg(jsonback.get((Object)"msg").toString());
            } else {
                resultJson.setMsg("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return resultJson;
    }

    public static ResultJson sendHttpPairForTrain(String url, List<NameValuePair> params) {
        ResultJson resultJson = new ResultJson();
        try {
            Long s = System.currentTimeMillis();
            String result = HttpUtils.doPost(url, params);
            Long e = System.currentTimeMillis();
            if (StringUtils.isEmpty((String)result)) {
                resultJson.setSuccessful(false);
                Long i = (e - s) / 1000L;
                resultJson.setMsg(i >= 30L ? "\u63a5\u53e3\u8bf7\u6c42\u8d85\u65f6\uff08" + i + "s\uff09" : "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a\u65e0\u8fd4\u56de\u4fe1\u606f");
                return resultJson;
            }
            JSONObject jsonback = JSONUtil.parseObj((String)result);
            if (jsonback.get((Object)"retType") != null && !ObjectUtil.equal((Object)jsonback.get((Object)"retType"), (Object)"-1")) {
                resultJson.setSuccessful(true);
            } else {
                resultJson.setSuccessful(false);
            }
            resultJson.setData(jsonback.get((Object)"data"));
            if (jsonback.get((Object)"msg") != null && !"null".equals(jsonback.get((Object)"msg").toString())) {
                resultJson.setMsg(jsonback.get((Object)"msg").toString());
            } else {
                resultJson.setMsg("");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return resultJson;
    }

    public static String doPost(String url, List<NameValuePair> params, int timeout) {
        String result = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = resp.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            logger.debug("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
            logger.debug("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String doPost(String url, List<NameValuePair> params) {
        String result = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(1000).setConnectTimeout(1000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = resp.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            logger.debug("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
            logger.debug("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String doPost(String url, Map<String, Object> map) {
        String result = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpEntity resEntity;
            CloseableHttpResponse response;
            HttpPost httpPost = new HttpPost(url);
            String charset = "utf-8";
            int timeout = 30000;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString()));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            logger.error("====== URL:" + url);
            logger.error("====== PARAM:" + map.toString());
            logger.error("====== ERROR:" + ex.getMessage());
            ex.printStackTrace();
        }
        return result;
    }

    public static String doGet(String strUrl, List<NameValuePair> params) {
        String result = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            URL url = new URL(strUrl);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
            HttpGet HttpGet2 = new HttpGet(uri);
            try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)HttpGet2);){
                HttpEntity entity = resp.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

