/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.timer;

import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.domain.BusinessTravel;
import com.bcxin.oaflow.domain.LeaveApplication;
import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.domain.OaBusinessBaseEntity;
import com.bcxin.oaflow.domain.PublicRelease;
import com.bcxin.oaflow.domain.WorkOvertime;
import com.bcxin.oaflow.dto.OaBusinessDto;
import com.bcxin.oaflow.mapper.BusinessTravelMapper;
import com.bcxin.oaflow.mapper.LeaveApplicationMapper;
import com.bcxin.oaflow.mapper.MakeUpCardMapper;
import com.bcxin.oaflow.mapper.PublicReleaseMapper;
import com.bcxin.oaflow.mapper.WorkOvertimeMapper;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.domain.attend.AttendReport;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendReportMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendLeaveService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="attendReportTask")
public class AttendReportTask {
    @Resource
    private AttendReportMapper attendReportMapper;
    @Resource
    private AttendClockMapper attendClockMapper;
    @Resource
    private LeaveApplicationMapper leaveApplicationMapper;
    @Resource
    private BusinessTravelMapper businessTravelMapper;
    @Resource
    private PublicReleaseMapper publicReleaseMapper;
    @Resource
    private WorkOvertimeMapper workOvertimeMapper;
    @Resource
    private MakeUpCardMapper makeUpCardMapper;
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private AttendLeaveService attendLeaveService;
    @Resource
    private IdWorker idWorker;

    public void createDayReport() {
        this.createDayReport(DateUtil.getYesterday(), true, null);
    }

    public void manualCreateDayReport(String schedulDate) {
        this.createDayReport(schedulDate, false, null);
    }

    public void manualCreateDayReports(String startDate, String endDate) {
        this.attendClockMapper.createAbsence();
        this.attendClockMapper.updateClockStatus();
        List dates = DateUtil.getBetweenDates((String)startDate, (String)endDate);
        for (Date date : dates) {
            this.createDayReport(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date), false, null);
        }
    }

    public void createDayReport(String schedulDate, Boolean clockStatus, Long perId) {
        List<PerOrgRelation> perList;
        List<AttendLeave> subList;
        if (clockStatus.booleanValue()) {
            this.attendClockMapper.createAbsence();
            this.attendClockMapper.updateClockStatus();
        }
        ArrayList<AttendLeave> attendLeaveList = new ArrayList<AttendLeave>();
        AttendClockDto searchDto = new AttendClockDto();
        searchDto.setSchedulDate(schedulDate);
        searchDto.setPerId(perId);
        List<AttendClockDto> list = this.attendClockMapper.selectListForReport(searchDto);
        if (list.size() == 0) {
            return;
        }
        List<String> tlkPerIds = list.stream().map(AttendClockDto::getTlkPerId).distinct().collect(Collectors.toList());
        List<LeaveApplication> leaveList = this.leaveApplicationMapper.selectList(tlkPerIds, schedulDate);
        List<BusinessTravel> businessTravelList = this.businessTravelMapper.selectList(tlkPerIds, schedulDate);
        List<PublicRelease> publicReleaseList = this.publicReleaseMapper.selectList(tlkPerIds, schedulDate);
        List<WorkOvertime> overtimeList = this.workOvertimeMapper.selectList(tlkPerIds, schedulDate);
        Map<String, List<AttendClockDto>> clockMap = list.stream().collect(Collectors.groupingBy(AttendClockDto::getTlkPerId));
        Map<String, List<LeaveApplication>> leaveMap = leaveList.stream().collect(Collectors.groupingBy(OaBusinessBaseEntity::getUserId));
        Map<String, List<BusinessTravel>> businessTraveMap = businessTravelList.stream().collect(Collectors.groupingBy(OaBusinessBaseEntity::getUserId));
        Map<String, List<PublicRelease>> publicReleaseMap = publicReleaseList.stream().collect(Collectors.groupingBy(OaBusinessBaseEntity::getUserId));
        Map overtimeMap = overtimeList.stream().collect(Collectors.toMap(OaBusinessBaseEntity::getUserId, Function.identity()));
        Double absenteeism = 0.0;
        Integer leaveEarly = 0;
        Integer lateMin = 0;
        Integer missCard = 0;
        Double leaveHour = 0.0;
        Double businessOut = 0.0;
        Double overtime = 0.0;
        Double businessTrip = 0.0;
        Double workHour = 0.0;
        boolean updateFlag = false;
        String attendClockStatus = null;
        ArrayList<AttendClockDto> clockList = new ArrayList<AttendClockDto>();
        for (String tlkPerId : clockMap.keySet()) {
            subList = clockMap.get(tlkPerId);
            List<LeaveApplication> subLeaveList = leaveMap.get(tlkPerId);
            List<BusinessTravel> subTravelList = businessTraveMap.get(tlkPerId);
            List<PublicRelease> subReleaseList = publicReleaseMap.get(tlkPerId);
            WorkOvertime workOvertime = (WorkOvertime)((Object)overtimeMap.get(tlkPerId));
            if (workOvertime != null) {
                overtime = workOvertime.getDiffTime();
            }
            for (AttendClockDto attendClockDto : subList) {
                if (attendClockDto.getShiftHour() == null) {
                    attendClockDto.setShiftHour(0.0);
                }
                attendClockStatus = attendClockDto.getClockStatus();
                updateFlag = false;
                absenteeism = 0.0;
                leaveEarly = 0;
                lateMin = 0;
                missCard = 0;
                leaveHour = 0.0;
                businessOut = 0.0;
                businessTrip = 0.0;
                workHour = 0.0;
                if ("3".equals(attendClockDto.getClockStatus()) || "23".equals(attendClockDto.getClockStatus()) || "34".equals(attendClockDto.getClockStatus())) {
                    lateMin = attendClockDto.getLateMin();
                }
                if ("4".equals(attendClockDto.getClockStatus()) || "24".equals(attendClockDto.getClockStatus()) || "34".equals(attendClockDto.getClockStatus())) {
                    leaveEarly = attendClockDto.getLeaveEarly();
                }
                if ("5".equals(attendClockDto.getClockStatus())) {
                    if ("1".equals(attendClockDto.getShiftType())) {
                        missCard = 2;
                        absenteeism = attendClockDto.getShiftHour();
                    } else {
                        missCard = 1;
                    }
                }
                if ("21".equals(attendClockDto.getClockStatus()) || "22".equals(attendClockDto.getClockStatus()) || "23".equals(attendClockDto.getClockStatus()) || "24".equals(attendClockDto.getClockStatus())) {
                    missCard = 1;
                }
                if ("1".equals(attendClockDto.getShiftType())) {
                    Double hour;
                    Double minute;
                    if (subLeaveList != null) {
                        for (LeaveApplication leaveApplication : subLeaveList) {
                            minute = this.calculateMinute(leaveApplication, attendClockDto);
                            if (!(minute > 0.0)) continue;
                            hour = BigDecimal.valueOf(minute / 60.0).setScale(2, 4).doubleValue();
                            leaveHour = leaveHour + hour;
                            AttendLeave attendLeave = new AttendLeave();
                            attendLeave.setOaLeaveId(leaveApplication.getId());
                            attendLeave.setLeaveDate(attendClockDto.getSchedulDate());
                            attendLeave.setSchedulDetailId(attendClockDto.getSchedulDetailId());
                            attendLeave.setLeaveHour(hour);
                            attendLeave.setLeaveType(leaveApplication.getLeaveType());
                            attendLeave.setPerId(attendClockDto.getPerId());
                            attendLeave.setComId(attendClockDto.getComId());
                            attendLeave.setDeptId(attendClockDto.getDeptId());
                            attendLeave.setCreateTime(new Date());
                            attendLeave.setUpdateTime(new Date());
                            attendLeave.setIsDelete("0");
                            attendLeaveList.add(attendLeave);
                            if (lateMin > 0) {
                                lateMin = this.calculateLateMinute(leaveApplication, attendClockDto, lateMin, minute);
                            }
                            if (leaveEarly > 0) {
                                leaveEarly = this.calculateLeaveMinute(leaveApplication, attendClockDto, leaveEarly, minute);
                            }
                            if (absenteeism > 0.0) {
                                absenteeism = (absenteeism = Double.valueOf(absenteeism - hour)) > 0.0 ? absenteeism : 0.0;
                            }
                            if (missCard <= 0) continue;
                            if (StrUtil.isEmpty((CharSequence)attendClockDto.getClockEnd()) && leaveApplication.getStopTime().getTime() >= DateUtils.parseDate((Object)attendClockDto.getEndTime()).getTime()) {
                                missCard = missCard - 1;
                            }
                            if (!StrUtil.isEmpty((CharSequence)attendClockDto.getClockStart()) || leaveApplication.getStartTime().getTime() > DateUtils.parseDate((Object)attendClockDto.getStartTime()).getTime()) continue;
                            missCard = missCard - 1;
                        }
                    }
                    if (leaveHour > attendClockDto.getShiftHour()) {
                        leaveHour = attendClockDto.getShiftHour();
                    }
                    if (subReleaseList != null) {
                        for (PublicRelease publicRelease : subReleaseList) {
                            minute = this.calculateMinute(publicRelease, attendClockDto);
                            if (!(minute > 0.0)) continue;
                            hour = BigDecimal.valueOf(minute / 60.0).setScale(2, 4).doubleValue();
                            businessOut = businessOut + hour;
                            if (lateMin > 0) {
                                lateMin = this.calculateLateMinute(publicRelease, attendClockDto, lateMin, minute);
                            }
                            if (leaveEarly > 0) {
                                leaveEarly = this.calculateLeaveMinute(publicRelease, attendClockDto, leaveEarly, minute);
                            }
                            if (absenteeism > 0.0) {
                                absenteeism = (absenteeism = Double.valueOf(absenteeism - hour)) > 0.0 ? absenteeism : 0.0;
                            }
                            if (missCard <= 0) continue;
                            if (StrUtil.isEmpty((CharSequence)attendClockDto.getClockEnd()) && publicRelease.getStopTime().getTime() >= DateUtils.parseDate((Object)attendClockDto.getEndTime()).getTime()) {
                                missCard = missCard - 1;
                            }
                            if (!StrUtil.isEmpty((CharSequence)attendClockDto.getClockStart()) || publicRelease.getStartTime().getTime() > DateUtils.parseDate((Object)attendClockDto.getStartTime()).getTime()) continue;
                            missCard = missCard - 1;
                        }
                    }
                    if (businessOut > attendClockDto.getShiftHour()) {
                        businessOut = attendClockDto.getShiftHour();
                    }
                    if (subTravelList != null) {
                        for (BusinessTravel businessTravel : subTravelList) {
                            minute = this.calculateMinute(businessTravel, attendClockDto);
                            if (!(minute > 0.0)) continue;
                            hour = BigDecimal.valueOf(minute / 60.0).setScale(2, 4).doubleValue();
                            businessTrip = businessTrip + hour;
                            if (lateMin > 0) {
                                lateMin = this.calculateLateMinute(businessTravel, attendClockDto, lateMin, minute);
                            }
                            if (leaveEarly > 0) {
                                leaveEarly = this.calculateLeaveMinute(businessTravel, attendClockDto, leaveEarly, minute);
                            }
                            if (absenteeism > 0.0) {
                                absenteeism = (absenteeism = Double.valueOf(absenteeism - hour)) > 0.0 ? absenteeism : 0.0;
                            }
                            if (missCard <= 0) continue;
                            if (StrUtil.isEmpty((CharSequence)attendClockDto.getClockEnd()) && businessTravel.getStopTime().getTime() >= DateUtils.parseDate((Object)attendClockDto.getEndTime()).getTime()) {
                                missCard = missCard - 1;
                            }
                            if (!StrUtil.isEmpty((CharSequence)attendClockDto.getClockStart()) || businessTravel.getStartTime().getTime() > DateUtils.parseDate((Object)attendClockDto.getStartTime()).getTime()) continue;
                            missCard = missCard - 1;
                        }
                    }
                    if (businessTrip > attendClockDto.getShiftHour()) {
                        businessTrip = attendClockDto.getShiftHour();
                    }
                }
                if (!lateMin.equals(attendClockDto.getLateMin())) {
                    updateFlag = true;
                }
                attendClockDto.setLateMin(lateMin);
                if (lateMin > 0) {
                    attendClockStatus = "3";
                    if (StrUtil.isEmpty((CharSequence)attendClockDto.getClockEnd()) && "1".equals(attendClockDto.getShiftType())) {
                        attendClockStatus = "23";
                    }
                }
                if (!leaveEarly.equals(attendClockDto.getLeaveEarly())) {
                    updateFlag = true;
                }
                attendClockDto.setLeaveEarly(leaveEarly);
                if (leaveEarly > 0) {
                    attendClockStatus = "4";
                    if (StrUtil.isEmpty((CharSequence)attendClockDto.getClockStart())) {
                        attendClockStatus = "24";
                    }
                }
                if (lateMin > 0 && leaveEarly > 0) {
                    attendClockStatus = "34";
                }
                if (!absenteeism.equals(attendClockDto.getAbsenteeism())) {
                    updateFlag = true;
                }
                attendClockDto.setAbsenteeism(absenteeism);
                if (absenteeism > 0.0 && !"5".equals(attendClockDto.getClockStatus())) {
                    updateFlag = true;
                    attendClockStatus = "5";
                }
                if (!missCard.equals(attendClockDto.getMissCard())) {
                    updateFlag = true;
                    attendClockDto.setMissCard(missCard);
                }
                if (missCard <= 0) {
                    workHour = attendClockDto.getShiftHour();
                }
                workHour = workHour + (businessOut + businessTrip - (double)leaveEarly.intValue() / 60.0 - (double)lateMin.intValue() / 60.0 - absenteeism - leaveHour);
                workHour = BigDecimal.valueOf(workHour).setScale(2, 4).doubleValue();
                if (workHour < 0.0) {
                    workHour = 0.0;
                }
                if (workHour > attendClockDto.getShiftHour()) {
                    workHour = attendClockDto.getShiftHour();
                }
                if (leaveHour > attendClockDto.getShiftHour()) {
                    leaveHour = attendClockDto.getShiftHour();
                }
                if (businessOut > attendClockDto.getShiftHour()) {
                    businessOut = attendClockDto.getShiftHour();
                }
                if (businessTrip > attendClockDto.getShiftHour()) {
                    businessTrip = attendClockDto.getShiftHour();
                }
                if (!workHour.equals(attendClockDto.getWorkHour())) {
                    updateFlag = true;
                }
                attendClockDto.setWorkHour(workHour);
                if (!leaveHour.equals(attendClockDto.getLeaveHour())) {
                    attendClockDto.setLeaveHour(leaveHour);
                    updateFlag = true;
                }
                if (!businessOut.equals(attendClockDto.getBusinessOut())) {
                    updateFlag = true;
                    attendClockDto.setBusinessOut(businessOut);
                }
                if (!businessTrip.equals(attendClockDto.getBusinessTrip())) {
                    updateFlag = true;
                    attendClockDto.setBusinessTrip(businessTrip);
                }
                attendClockDto.setUpdateTime(DateUtils.getNowDate());
                if (!attendClockStatus.equals(attendClockDto.getClockStatus())) {
                    updateFlag = true;
                    attendClockDto.setClockStatus(attendClockStatus);
                    if (lateMin <= 0 && leaveEarly <= 0 && absenteeism <= 0.0 && missCard <= 0) {
                        attendClockDto.setClockStatus("1");
                    }
                }
                if ("2".equals(attendClockDto.getShiftType())) {
                    attendClockDto.setWorkHour(null);
                }
                if (!updateFlag) continue;
                clockList.add(attendClockDto);
            }
        }
        int limit = 200;
        if (attendLeaveList.size() > 0) {
            int count = new Double(Math.ceil((double)attendLeaveList.size() * 1.0 / (double)limit)).intValue();
            subList = null;
            for (int i = 0; i < count; ++i) {
                subList = attendLeaveList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                this.attendLeaveService.saveBatch(subList);
            }
        }
        if (clockList.size() > 0) {
            int count = new Double(Math.ceil((double)clockList.size() * 1.0 / (double)limit)).intValue();
            subList = null;
            for (int i = 0; i < count; ++i) {
                subList = clockList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                this.attendClockMapper.updateBatchStatus(subList);
            }
        }
        List<AttendReport> reportList = this.attendReportMapper.selectListForReport(tlkPerIds, schedulDate);
        for (AttendReport attendReport : reportList) {
            if (attendReport.getId() == null) {
                attendReport.setCreateTime(new Date());
            }
            attendReport.setIsDelete("0");
            attendReport.setUpdateTime(new Date());
            if (attendReport.getLeaveEarly() > 0 || attendReport.getLateMin() > 0 || attendReport.getAbsenteeism() != null && attendReport.getAbsenteeism() > 0.0 || attendReport.getMissCard() > 0) {
                attendReport.setAttendResultStatus("0");
            } else {
                attendReport.setAttendResultStatus("1");
            }
            WorkOvertime workOvertime = (WorkOvertime)((Object)overtimeMap.get(attendReport.getTlkPerId()));
            if (workOvertime != null) {
                attendReport.setOvertime(workOvertime.getDiffTime());
            } else {
                attendReport.setOvertime(0.0);
            }
            if (attendReport.getWorkHour() != null) {
                attendReport.setWorkHour(BigDecimal.valueOf(attendReport.getWorkHour() + attendReport.getOvertime()).setScale(2, 4).doubleValue());
                if (attendReport.getWorkHour() > 0.0) {
                    attendReport.setWorkCount(1);
                }
            }
            if (attendReport.getWorkNum() == null) continue;
            attendReport.setWorkCount(1);
        }
        Map perReportMap = reportList.stream().collect(Collectors.toMap(AttendReport::getTlkPerId, Function.identity()));
        overtimeList = this.workOvertimeMapper.selectListForRest(tlkPerIds, schedulDate);
        if (overtimeList.size() > 0 && (perList = this.perOrgRelationMapper.selectByTlkIds(tlkPerIds = overtimeList.stream().map(OaBusinessBaseEntity::getUserId).collect(Collectors.toList()))).size() > 0) {
            PerOrgRelation perOrgRelation = null;
            AttendReport attendReport = null;
            Map perMap = perList.stream().collect(Collectors.toMap(PerOrgRelation::getTlkPerId, Function.identity()));
            for (WorkOvertime workOvertime : overtimeList) {
                perOrgRelation = (PerOrgRelation)perMap.get(workOvertime.getUserId());
                if (perOrgRelation == null || (attendReport = (AttendReport)((Object)perReportMap.get(workOvertime.getUserId()))) != null) continue;
                attendReport = this.attendReportMapper.findByPerId(perOrgRelation.getPerId(), schedulDate);
                if (attendReport == null) {
                    attendReport = new AttendReport();
                    attendReport.setPerId(perOrgRelation.getPerId());
                    attendReport.setDeptId(perOrgRelation.getOrgId());
                    attendReport.setReportDate(schedulDate);
                    attendReport.setAttendReportType("1");
                    attendReport.setAttendResultStatus("1");
                    attendReport.setShiftHour(0.0);
                    attendReport.setWorkCount(1);
                    attendReport.setWorkHour(workOvertime.getDiffTime());
                    attendReport.setAbsenteeism(0.0);
                    attendReport.setLeaveEarly(0);
                    attendReport.setLeaveEarlyCount(0);
                    attendReport.setLateMin(0);
                    attendReport.setLateCount(0);
                    attendReport.setMissCard(0);
                    attendReport.setLeaveHour(0.0);
                    attendReport.setBusinessOut(0.0);
                    attendReport.setBusinessTrip(0.0);
                    attendReport.setCreateTime(new Date());
                    attendReport.setIsDelete("0");
                }
                attendReport.setUpdateTime(new Date());
                attendReport.setOvertime(workOvertime.getDiffTime());
                reportList.add(attendReport);
            }
        }
        if (reportList.size() > 0) {
            int count = new Double(Math.ceil((double)reportList.size() * 1.0 / (double)limit)).intValue();
            List<AttendReport> subList2 = null;
            for (int i = 0; i < count; ++i) {
                subList2 = reportList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                this.attendReportMapper.saveBatch(subList2);
            }
        }
    }

    public void createMonthReport() {
        this.createMonthReport(DateUtil.getLastMonth(), null);
    }

    public void createMonthReport(String month, Long perId) {
        try {
            int days = DateUtil.getDaysOfMonth((Date)DateUtils.parseDate((String)month, (String[])new String[]{"yyyy-MM"}));
            this.attendReportMapper.removeMonthReport(month, perId);
            this.attendReportMapper.createMonthReport(month, perId, days);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws ParseException {
        AttendReport attendReport = new AttendReport();
        String month = "2021-08";
        System.out.println(DateUtil.getDaysOfMonth((Date)DateUtils.parseDate((String)month, (String[])new String[]{"yyyy-MM"})));
    }

    public Double calculateMinute(OaBusinessBaseEntity businessBaseEntity, AttendClockDto attendClockDto) {
        Double result = 0.0;
        Date startTime = null;
        Date endTime = null;
        startTime = businessBaseEntity.getStartTime().getTime() <= DateUtils.parseDate((Object)attendClockDto.getStartTime()).getTime() ? DateUtils.parseDate((Object)attendClockDto.getStartTime()) : businessBaseEntity.getStartTime();
        if (businessBaseEntity.getStopTime().getTime() >= DateUtils.parseDate((Object)attendClockDto.getEndTime()).getTime()) {
            endTime = DateUtils.parseDate((Object)attendClockDto.getEndTime());
        } else if (businessBaseEntity.getStopTime().getTime() < DateUtils.parseDate((Object)attendClockDto.getEndTime()).getTime()) {
            endTime = businessBaseEntity.getStopTime();
        }
        if (startTime.getTime() > endTime.getTime()) {
            return result;
        }
        boolean needRest = false;
        Date restStart = null;
        Date restEnd = null;
        if ("1".equals(attendClockDto.getNeedRest())) {
            needRest = true;
            restStart = businessBaseEntity.getStartTime().getTime() <= DateUtils.parseDate((Object)attendClockDto.getRestStart()).getTime() ? DateUtils.parseDate((Object)attendClockDto.getRestStart()) : businessBaseEntity.getStartTime();
            if (businessBaseEntity.getStopTime().getTime() >= DateUtils.parseDate((Object)attendClockDto.getRestEnd()).getTime()) {
                restEnd = DateUtils.parseDate((Object)attendClockDto.getRestEnd());
            } else if (businessBaseEntity.getStopTime().getTime() < DateUtils.parseDate((Object)attendClockDto.getRestEnd()).getTime()) {
                restEnd = businessBaseEntity.getStopTime();
            }
        }
        if (startTime != null && endTime != null) {
            Double restHour = 0.0;
            if (needRest && restStart != null && restEnd != null) {
                restHour = DateUtils.minDiff((Date)restStart, restEnd);
            }
            result = DateUtils.minDiff((Date)startTime, (Date)endTime) - restHour;
        }
        return result;
    }

    public Integer calculateLateMinute(OaBusinessBaseEntity businessBaseEntity, AttendClockDto attendClockDto, Integer lateMin, Double minute) {
        Date clockStart = DateUtils.parseDate((Object)attendClockDto.getClockStart());
        Date startTime = DateUtils.parseDate((Object)attendClockDto.getStartTime());
        if (clockStart.getTime() > businessBaseEntity.getStartTime().getTime()) {
            if (clockStart.getTime() >= businessBaseEntity.getStopTime().getTime()) {
                lateMin = lateMin - minute.intValue();
            } else if (clockStart.getTime() >= businessBaseEntity.getStartTime().getTime() && clockStart.getTime() < businessBaseEntity.getStopTime().getTime()) {
                if (businessBaseEntity.getStartTime().getTime() > startTime.getTime()) {
                    startTime = businessBaseEntity.getStartTime();
                }
                Date endTime = clockStart;
                if (startTime.getTime() < endTime.getTime()) {
                    Integer restMinu = 0;
                    if ("1".equals(attendClockDto.getNeedRest())) {
                        Date restStart = DateUtils.parseDate((Object)attendClockDto.getRestStart());
                        Date restEnd = DateUtils.parseDate((Object)attendClockDto.getRestEnd());
                        if (startTime.getTime() >= restStart.getTime() && startTime.getTime() <= restEnd.getTime()) {
                            startTime = restEnd;
                        } else if (endTime.getTime() >= restStart.getTime() && endTime.getTime() <= restEnd.getTime()) {
                            endTime = restStart;
                        } else if (startTime.getTime() < restStart.getTime() && endTime.getTime() > restEnd.getTime()) {
                            restMinu = DateUtils.minDiff((String)attendClockDto.getRestStart(), (String)attendClockDto.getRestEnd()).intValue();
                        }
                    }
                    if (startTime.getTime() < endTime.getTime()) {
                        lateMin = lateMin - (DateUtils.minDiff((Date)startTime, (Date)endTime).intValue() - restMinu);
                    }
                }
            }
        }
        return lateMin > 0 ? lateMin : 0;
    }

    public Integer calculateLeaveMinute(OaBusinessBaseEntity businessBaseEntity, AttendClockDto attendClockDto, Integer leaveEarly, Double minute) {
        Date clockEnd = DateUtils.parseDate((Object)attendClockDto.getClockEnd());
        Date endTime = DateUtils.parseDate((Object)attendClockDto.getEndTime());
        if (clockEnd.getTime() >= businessBaseEntity.getStopTime().getTime()) {
            leaveEarly = leaveEarly - minute.intValue();
        } else if (clockEnd.getTime() < businessBaseEntity.getStopTime().getTime() && clockEnd.getTime() >= businessBaseEntity.getStartTime().getTime() && clockEnd.getTime() < businessBaseEntity.getStopTime().getTime()) {
            Date startTime = clockEnd;
            if (businessBaseEntity.getStopTime().getTime() < endTime.getTime()) {
                endTime = businessBaseEntity.getStopTime();
            }
            if (startTime.getTime() < endTime.getTime()) {
                Integer restMinu = 0;
                if ("1".equals(attendClockDto.getNeedRest())) {
                    Date restStart = DateUtils.parseDate((Object)attendClockDto.getRestStart());
                    Date restEnd = DateUtils.parseDate((Object)attendClockDto.getRestEnd());
                    if (startTime.getTime() >= restStart.getTime() && startTime.getTime() <= restEnd.getTime()) {
                        startTime = restEnd;
                    } else if (endTime.getTime() >= restStart.getTime() && endTime.getTime() <= restEnd.getTime()) {
                        endTime = restStart;
                    } else if (startTime.getTime() < restStart.getTime() && endTime.getTime() > restEnd.getTime()) {
                        restMinu = DateUtils.minDiff((String)attendClockDto.getRestStart(), (String)attendClockDto.getRestEnd()).intValue();
                    }
                }
                if (startTime.getTime() < endTime.getTime()) {
                    leaveEarly = leaveEarly - (DateUtils.minDiff((Date)startTime, (Date)endTime).intValue() - restMinu);
                }
            }
        }
        return leaveEarly > 0 ? leaveEarly : 0;
    }

    public void updateReportForOA(OaBusinessDto searchDto) {
        OaBusinessBaseEntity oaBusiness = null;
        Double overtime = 0.0;
        switch (searchDto.getDictType()) {
            case "0": {
                oaBusiness = this.leaveApplicationMapper.findById(searchDto.getId());
                break;
            }
            case "1": {
                oaBusiness = this.workOvertimeMapper.findById(searchDto.getId());
                overtime = oaBusiness.getDiffTime();
                break;
            }
            case "2": {
                oaBusiness = this.publicReleaseMapper.findById(searchDto.getId());
                break;
            }
            case "3": {
                oaBusiness = this.businessTravelMapper.findById(searchDto.getId());
                break;
            }
            case "4": {
                oaBusiness = this.makeUpCardMapper.findById(searchDto.getId());
                break;
            }
        }
        if (oaBusiness == null) {
            return;
        }
        if (overtime > 0.0) {
            PerOrgRelation perOrgRelation = this.perOrgRelationMapper.selectPerOrgRelationByTlkId(oaBusiness.getUserId());
            if (perOrgRelation == null) {
                return;
            }
            AttendReport attendReport = this.attendReportMapper.findByPerId(perOrgRelation.getPerId(), DateUtils.formatDate((Date)oaBusiness.getStartTime(), (Object[])new Object[]{DateUtils.YYYY_MM_DD}));
            if (attendReport == null) {
                attendReport = new AttendReport();
                attendReport.setPerId(perOrgRelation.getPerId());
                attendReport.setDeptId(perOrgRelation.getOrgId());
                attendReport.setReportDate(DateUtils.formatDate((Date)oaBusiness.getStartTime(), (Object[])new Object[]{DateUtils.YYYY_MM_DD}));
                attendReport.setAttendReportType("1");
                attendReport.setAttendResultStatus("1");
                attendReport.setShiftHour(0.0);
                attendReport.setWorkCount(1);
                attendReport.setWorkHour(oaBusiness.getDiffTime());
                attendReport.setAbsenteeism(0.0);
                attendReport.setLeaveEarly(0);
                attendReport.setLeaveEarlyCount(0);
                attendReport.setLateMin(0);
                attendReport.setLateCount(0);
                attendReport.setMissCard(0);
                attendReport.setLeaveHour(0.0);
                attendReport.setBusinessOut(0.0);
                attendReport.setOvertime(oaBusiness.getDiffTime());
                attendReport.setBusinessTrip(0.0);
                attendReport.setCreateTime(new Date());
                attendReport.setUpdateTime(new Date());
                attendReport.setIsDelete("0");
                this.attendReportMapper.save(attendReport);
            } else {
                attendReport.setWorkHour(attendReport.getWorkHour() + oaBusiness.getDiffTime());
                attendReport.setOvertime(attendReport.getOvertime() + oaBusiness.getDiffTime());
                attendReport.setUpdateTime(new Date());
                this.attendReportMapper.updateSelective(attendReport);
            }
            attendReport = this.attendReportMapper.findByPerId(perOrgRelation.getPerId(), DateUtils.formatDate((Date)oaBusiness.getStartTime(), (Object[])new Object[]{DateUtils.YYYY_MM}));
            if (attendReport != null) {
                attendReport.setWorkHour(attendReport.getWorkHour() + oaBusiness.getDiffTime());
                attendReport.setOvertime(attendReport.getOvertime() + oaBusiness.getDiffTime());
                attendReport.setUpdateTime(new Date());
                this.attendReportMapper.updateSelective(attendReport);
            }
            return;
        }
        if ("4".equals(searchDto.getDictType())) {
            AttendClockDto attendClockDto = this.attendClockMapper.findByOABusiness((MakeUpCard)oaBusiness);
            if (attendClockDto == null) {
                return;
            }
            if ("1".equals(((MakeUpCard)oaBusiness).getCardType())) {
                attendClockDto.setClockStart(DateUtils.formatDate((Date)oaBusiness.getStartTime(), (Object[])new Object[]{DateUtils.YYYY_MM_DD_HH_MM}));
            } else {
                attendClockDto.setClockEnd(DateUtils.formatDate((Date)oaBusiness.getStartTime(), (Object[])new Object[]{DateUtils.YYYY_MM_DD_HH_MM}));
            }
            attendClockDto.setUpdateBy(searchDto.getUpdateBy());
            attendClockDto.setUpdateTime(DateUtils.getNowDate());
            ArrayList<AttendClock> clockList = new ArrayList<AttendClock>();
            clockList.add(attendClockDto);
            this.attendClockMapper.updateBatchStatus(clockList);
            this.attendClockMapper.updateClockStatusForPer(attendClockDto.getPerId(), attendClockDto.getSchedulDate());
            this.createDayReport(attendClockDto.getSchedulDate(), false, attendClockDto.getPerId());
        } else {
            PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoByTlkId(oaBusiness.getUserId());
            if (perBaseInfo == null) {
                return;
            }
            List dates = DateUtil.getBetweenDates((Date)oaBusiness.getStartTime(), (Date)oaBusiness.getStopTime());
            for (Date date : dates) {
                this.createDayReport(DateUtils.formatDate((Date)date, (Object[])new Object[]{DateUtils.YYYY_MM_DD}), false, perBaseInfo.getPerId());
            }
        }
        this.attendReportMapper.updateMonthReportForOA(oaBusiness);
    }
}

