/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.system.impl;

import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.system.SysUserOnline;
import com.bcxin.platform.mapper.system.SysUserOnlineMapper;
import com.bcxin.platform.service.system.ISysUserOnlineService;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class SysUserOnlineServiceImpl
implements ISysUserOnlineService {
    @Autowired
    private SysUserOnlineMapper userOnlineDao;
    @Autowired
    private EhCacheManager ehCacheManager;

    @Override
    public SysUserOnline selectOnlineById(String sessionId) {
        return this.userOnlineDao.selectOnlineById(sessionId);
    }

    @Override
    public void deleteOnlineById(String sessionId) {
        SysUserOnline userOnline = this.selectOnlineById(sessionId);
        if (StringUtils.isNotNull((Object)((Object)userOnline))) {
            this.userOnlineDao.deleteOnlineById(sessionId);
        }
    }

    @Override
    public void batchDeleteOnline(List<String> sessions) {
        for (String sessionId : sessions) {
            SysUserOnline userOnline = this.selectOnlineById(sessionId);
            if (!StringUtils.isNotNull((Object)((Object)userOnline))) continue;
            this.userOnlineDao.deleteOnlineById(sessionId);
        }
    }

    @Override
    public void saveOnline(SysUserOnline online) {
        this.userOnlineDao.saveOnline(online);
    }

    @Override
    public List<SysUserOnline> selectUserOnlineList(SysUserOnline userOnline) {
        return this.userOnlineDao.selectUserOnlineList(userOnline);
    }

    @Override
    public void forceLogout(String sessionId) {
        this.userOnlineDao.deleteOnlineById(sessionId);
    }

    @Override
    public void removeUserCache(String loginName, String sessionId) {
        Cache cache = this.ehCacheManager.getCache("sys-userCache");
        Deque deque = (Deque)cache.get((Object)loginName);
        if (StringUtils.isEmpty((Collection)deque) || deque.size() == 0) {
            return;
        }
        deque.remove(sessionId);
    }

    @Override
    public List<SysUserOnline> selectOnlineByExpired(Date expiredDate) {
        String lastAccessTime = DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (Date)expiredDate);
        return this.userOnlineDao.selectOnlineByExpired(lastAccessTime);
    }
}

