/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendPer;
import com.bcxin.platform.domain.attend.AttendSchedul;
import com.bcxin.platform.domain.attend.AttendSchedulConflict;
import com.bcxin.platform.domain.attend.AttendSchedulConflictDetail;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.app.AppAttendSchedulDto;
import com.bcxin.platform.dto.app.AppAttendShiftDto;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerPageDto;
import com.bcxin.platform.dto.attend.AttendShiftDto;
import com.bcxin.platform.mapper.attend.AttendCalendarRestDetailMapper;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendMapper;
import com.bcxin.platform.mapper.attend.AttendPerMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulConflictDetailMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulConflictMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulMapper;
import com.bcxin.platform.mapper.attend.AttendShiftMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendSchedulService;
import com.bcxin.platform.service.attend.AttendShiftService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendSchedulServiceImpl
implements AttendSchedulService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AttendSchedulMapper attendSchedulMapper;
    @Autowired
    private AttendSchedulDetailMapper attendSchedulDetailMapper;
    @Autowired
    private AttendSchedulConflictMapper attendSchedulConflictMapper;
    @Autowired
    private AttendSchedulConflictDetailMapper attendSchedulConflictDetailMapper;
    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;
    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;
    @Autowired
    private AttendShiftMapper attendShiftMapper;
    @Autowired
    private AttendShiftService attendShiftService;
    @Autowired
    private AttendPerMapper attendPerMapper;
    @Autowired
    private AttendClockMapper attendClockMapper;
    @Autowired
    private AttendMapper attendMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendSchedulDetail findById(Long id) {
        return this.attendSchedulDetailMapper.findById(id);
    }

    @Override
    public List<AttendSchedulPerPageDto> selectList(AttendSchedulPerPageDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<AttendSchedulPerPageDto>();
        }
        return this.attendSchedulDetailMapper.selectList(searchDto);
    }

    @Override
    public int update(AttendSchedulDetail attendSchedul) {
        if (attendSchedul.getId() == null) {
            attendSchedul.setCreateTime(DateUtils.getNowDate());
            attendSchedul.setId(this.idWorker.nextId());
        } else {
            AttendSchedulDetail dbAttendSchedul = this.attendSchedulDetailMapper.findById(attendSchedul.getId());
            BeanUtils.copyPropertiesIgnore((Object)attendSchedul, (Object)dbAttendSchedul, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbAttendSchedul, (Object)attendSchedul, (Boolean)false);
        }
        attendSchedul.setUpdateTime(DateUtils.getNowDate());
        return this.attendSchedulDetailMapper.save(attendSchedul);
    }

    @Override
    public int save(AttendSchedulDto attendSchedulDto) {
        Object conflictCount;
        Date startDate = DateUtils.parseDate((Object)attendSchedulDto.getStartDate());
        Date endDate = DateUtils.parseDate((Object)attendSchedulDto.getEndDate());
        if (startDate.getTime() < DateUtils.getNowDate().getTime()) {
            startDate = DateUtils.parseDate((Object)DateUtils.dateTimeNow((String)DateUtils.YYYY_MM_DD));
        }
        if (startDate.getTime() > endDate.getTime()) {
            throw new BusinessException("\u65e5\u671f\u533a\u95f4\u4e0d\u5728\u6709\u6548\u8303\u56f4\u5185");
        }
        if (attendSchedulDto.isRemoveOld()) {
            this.attendClockMapper.remove(attendSchedulDto);
            this.attendSchedulDetailMapper.remove(attendSchedulDto);
        }
        ArrayList<AttendSchedulDetail> schedulList = new ArrayList<AttendSchedulDetail>();
        List<AttendPer> attendPerList = this.attendPerMapper.findByPerIds(attendSchedulDto);
        if (attendPerList.size() < attendSchedulDto.getPerIds().length) {
            throw new BusinessException("\u5b58\u5728\u975e\u672c\u8003\u52e4\u5957\u4eba\u5458!");
        }
        Attend attend = this.attendMapper.findById(attendSchedulDto.getAttendId());
        List<AttendShift> shiftList = this.attendShiftMapper.findByArrIds(attendSchedulDto.getShiftIds());
        if ("2".equals(attend.getShiftType())) {
            conflictCount = this.attendSchedulDetailMapper.getConflictCount(attendSchedulDto, DateUtils.formatDate((Date)startDate, (Object[])new Object[]{DateUtils.YYYY_MM_DD}), DateUtils.formatDate((Date)endDate, (Object[])new Object[]{DateUtils.YYYY_MM_DD}));
            if ((Long)conflictCount > 0L) {
                throw new BusinessException("\u6392\u73ed\u51b2\u7a81");
            }
        } else {
            for (AttendShift attendShift : shiftList) {
                Date startTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + attendShift.getStartTime()));
                Date endTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + attendShift.getEndTime()));
                if (endTime.getTime() < startTime.getTime()) {
                    endTime = DateUtils.addDays((Date)endTime, (int)1);
                }
                for (AttendShift shift : shiftList) {
                    Date startShiftTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + shift.getStartTime()));
                    Date endShiftTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + shift.getEndTime()));
                    if (endShiftTime.getTime() < startShiftTime.getTime()) {
                        endShiftTime = DateUtils.addDays((Date)endShiftTime, (int)1);
                    }
                    if (shift.getId().longValue() == attendShift.getId().longValue()) continue;
                    if (startTime.getTime() >= startShiftTime.getTime() && startTime.getTime() < endShiftTime.getTime()) {
                        throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                    }
                    if (endTime.getTime() > startShiftTime.getTime() && endTime.getTime() <= endShiftTime.getTime()) {
                        throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                    }
                    if (startShiftTime.getTime() >= startTime.getTime() && startShiftTime.getTime() < endTime.getTime()) {
                        throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                    }
                    if (endShiftTime.getTime() <= startTime.getTime() || endShiftTime.getTime() > endTime.getTime()) continue;
                    throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                }
            }
            conflictCount = this.attendSchedulDetailMapper.getConflictSchedulCount(attendSchedulDto, DateUtils.formatDate((Date)startDate, (Object[])new Object[]{DateUtils.YYYY_MM_DD}), DateUtils.formatDate((Date)endDate, (Object[])new Object[]{DateUtils.YYYY_MM_DD}));
            if ((Long)conflictCount > 0L) {
                throw new BusinessException("\u6392\u73ed\u51b2\u7a81");
            }
        }
        Map shiftMap = shiftList.stream().collect(Collectors.toMap(AttendShift::getId, Function.identity()));
        List dateList = DateUtil.getBetweenDates((String)DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)startDate), (String)attendSchedulDto.getEndDate());
        Map<Object, Object> restMap = new HashMap();
        AttendSchedul attendSchedul = new AttendSchedul();
        attendSchedul.setId(this.idWorker.nextId());
        attendSchedul.setAttendId(attendSchedulDto.getAttendId());
        attendSchedul.setCalendarId(attendSchedulDto.getCalendarId());
        attendSchedul.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        attendSchedul.setPerIds(String.join((CharSequence)",", attendSchedulDto.getPerIds()));
        attendSchedul.setShiftIds(String.join((CharSequence)",", attendSchedulDto.getShiftIds()));
        attendSchedul.setStartDate(attendSchedulDto.getStartDate());
        attendSchedul.setEndDate(attendSchedulDto.getEndDate());
        attendSchedul.setComId(attendSchedulDto.getComId());
        attendSchedul.setCreateBy(attendSchedulDto.getCreateBy());
        attendSchedul.setCreateTime(new Date());
        attendSchedul.setUpdateBy(attendSchedulDto.getUpdateBy());
        attendSchedul.setUpdateTime(new Date());
        attendSchedul.setIsDelete("0");
        AttendSchedulDetail tempSchedulDetail = new AttendSchedulDetail();
        tempSchedulDetail.setSchedulId(attendSchedul.getId());
        tempSchedulDetail.setAttendId(attendSchedulDto.getAttendId());
        tempSchedulDetail.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        if ("1".equals(attendSchedulDto.getNeedCalendar())) {
            if (attendSchedulDto.getCalendarId() == null) {
                throw new BusinessException("\u65e5\u5386\u5957\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tempSchedulDetail.setCalendarId(attendSchedulDto.getCalendarId());
            AttendCalendarRestDetailDto searchDto = new AttendCalendarRestDetailDto();
            searchDto.setCalendarId(attendSchedulDto.getCalendarId());
            List<AttendCalendarRestDetailDto> restList = this.attendCalendarRestDetailMapper.selectList(searchDto);
            restMap = restList.stream().collect(Collectors.toMap(AttendCalendarRestDetailDto::getRestDate, Function.identity()));
        }
        tempSchedulDetail.setCreateTime(DateUtils.getNowDate());
        tempSchedulDetail.setUpdateTime(DateUtils.getNowDate());
        tempSchedulDetail.setCreateBy(attendSchedulDto.getCreateBy());
        tempSchedulDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
        tempSchedulDetail.setIsDelete("0");
        AttendSchedulDetail attendSchedulDetail = null;
        AttendShift attendShift = null;
        for (Date date : dateList) {
            for (String perId : attendSchedulDto.getPerIds()) {
                if (restMap.get(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date)) != null) {
                    try {
                        attendSchedulDetail = tempSchedulDetail.clone();
                        attendSchedulDetail.setId(this.idWorker.nextId());
                        attendSchedulDetail.setPerId(Long.parseLong(perId));
                        PerOrgRelation relation = this.perOrgRelationMapper.findByPerId(Long.parseLong(perId));
                        attendSchedulDetail.setDeptId(relation.getOrgId());
                        attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date));
                        attendSchedulDetail.setSchedulType("0");
                        schedulList.add(attendSchedulDetail);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                for (String shiftId : attendSchedulDto.getShiftIds()) {
                    attendShift = (AttendShift)((Object)shiftMap.get(Long.parseLong(shiftId)));
                    try {
                        attendSchedulDetail = tempSchedulDetail.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    attendSchedulDetail.setId(this.idWorker.nextId());
                    attendSchedulDetail.setPerId(Long.parseLong(perId));
                    attendSchedulDetail.setSchedulType("1");
                    attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date));
                    attendSchedulDetail.setNeedRest(attendShift.getNeedRest());
                    if ("1".equals(attendShift.getNeedRest())) {
                        Date restStart = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestStart()));
                        Date restEnd = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestEnd()));
                        if (restStart.getTime() > restEnd.getTime()) {
                            restEnd = DateUtils.addDays((Date)restEnd, (int)1);
                        }
                        attendSchedulDetail.setRestStart(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)restStart));
                        attendSchedulDetail.setRestEnd(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)restEnd));
                    }
                    Date startTime = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getStartTime()));
                    attendSchedulDetail.setStartTime(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)startTime));
                    if ("1".equals(attend.getShiftType())) {
                        Date endTime = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getEndTime()));
                        if (startTime.getTime() > endTime.getTime()) {
                            endTime = DateUtils.addDays((Date)endTime, (int)1);
                        }
                        attendSchedulDetail.setEndTime(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)endTime));
                    }
                    attendSchedulDetail.setShiftId(attendShift.getId());
                    schedulList.add(attendSchedulDetail);
                }
            }
        }
        if (schedulList.size() > 0) {
            this.attendSchedulDetailMapper.saveBatch(schedulList);
        }
        return this.attendSchedulMapper.save(attendSchedul);
    }

    @Override
    public AjaxResult saveForWeeks(AttendSchedulDto attendSchedulDto) {
        Date startDate = DateUtils.parseDate((Object)attendSchedulDto.getStartDate());
        Date endDate = DateUtils.parseDate((Object)attendSchedulDto.getEndDate());
        if (startDate.getTime() < DateUtils.getNowDate().getTime()) {
            startDate = DateUtils.parseDate((Object)DateUtils.dateTimeNow((String)DateUtils.YYYY_MM_DD));
        }
        if (startDate.getTime() > endDate.getTime()) {
            throw new BusinessException("\u65e5\u671f\u533a\u95f4\u4e0d\u5728\u6709\u6548\u8303\u56f4\u5185");
        }
        List<AttendShift> shiftList = this.attendShiftMapper.findByArrIds(attendSchedulDto.getShiftIds());
        for (AttendShift attendShift : shiftList) {
            if ("1".equals(attendShift.getActive())) continue;
            throw new BusinessException("\u5b58\u5728\u4f7f\u7528\u672a\u542f\u52a8\u7684\u73ed\u6b21\uff01");
        }
        if (attendSchedulDto.isRemoveOld()) {
            this.attendClockMapper.remove(attendSchedulDto);
            this.attendSchedulDetailMapper.remove(attendSchedulDto);
        }
        ArrayList<AttendSchedulDetail> schedulList = new ArrayList<AttendSchedulDetail>();
        ArrayList<AttendSchedulConflict> schedulConflictList = new ArrayList<AttendSchedulConflict>();
        ArrayList<AttendSchedulConflictDetail> schedulConflictDetailList = new ArrayList<AttendSchedulConflictDetail>();
        List<AttendPer> attendPerList = this.attendPerMapper.findByPerIds(attendSchedulDto);
        if (attendPerList.size() < attendSchedulDto.getPerIds().length) {
            throw new BusinessException("\u5b58\u5728\u975e\u672c\u8003\u52e4\u5957\u4eba\u5458!");
        }
        Attend attend = this.attendMapper.findById(attendSchedulDto.getAttendId());
        if ("1".equals(attend.getShiftType())) {
            for (AttendShift attendShift : shiftList) {
                Date startTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + attendShift.getStartTime()));
                Date endTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + attendShift.getEndTime()));
                if (endTime.getTime() < startTime.getTime()) {
                    endTime = DateUtils.addDays((Date)endTime, (int)1);
                }
                for (AttendShift shift : shiftList) {
                    Date startShiftTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + shift.getStartTime()));
                    Date endShiftTime = DateUtils.parseDate((Object)(DateUtils.getDate() + " " + shift.getEndTime()));
                    if (endShiftTime.getTime() < startShiftTime.getTime()) {
                        endShiftTime = DateUtils.addDays((Date)endShiftTime, (int)1);
                    }
                    if (shift.getId().longValue() == attendShift.getId().longValue()) continue;
                    if (startTime.getTime() >= startShiftTime.getTime() && startTime.getTime() < endShiftTime.getTime()) {
                        throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                    }
                    if (endTime.getTime() > startShiftTime.getTime() && endTime.getTime() <= endShiftTime.getTime()) {
                        throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                    }
                    if (startShiftTime.getTime() >= startTime.getTime() && startShiftTime.getTime() < endTime.getTime()) {
                        throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                    }
                    if (endShiftTime.getTime() <= startTime.getTime() || endShiftTime.getTime() > endTime.getTime()) continue;
                    throw new BusinessException("\u73ed\u6b21\u3010" + shift.getShiftName() + "\u3011\u4e0e\u3010" + attendShift.getShiftName() + "\u3011\u65f6\u95f4\u5b58\u5728\u51b2\u7a81!");
                }
            }
        }
        Map shiftMap = shiftList.stream().collect(Collectors.toMap(AttendShift::getId, Function.identity()));
        List dateList = DateUtil.getBetweenDatesByWeeks((String)DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)startDate), (String)attendSchedulDto.getEndDate(), attendSchedulDto.getWeeks());
        Map<Object, Object> restMap = new HashMap();
        AttendSchedul attendSchedul = new AttendSchedul();
        attendSchedul.setId(this.idWorker.nextId());
        attendSchedul.setAttendId(attendSchedulDto.getAttendId());
        attendSchedul.setCalendarId(attendSchedulDto.getCalendarId());
        attendSchedul.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        attendSchedul.setPerIds(String.join((CharSequence)",", attendSchedulDto.getPerIds()));
        attendSchedul.setShiftIds(String.join((CharSequence)",", attendSchedulDto.getShiftIds()));
        attendSchedul.setStartDate(attendSchedulDto.getStartDate());
        attendSchedul.setEndDate(attendSchedulDto.getEndDate());
        attendSchedul.setComId(attendSchedulDto.getComId());
        attendSchedul.setCreateBy(attendSchedulDto.getCreateBy());
        attendSchedul.setCreateTime(new Date());
        attendSchedul.setUpdateBy(attendSchedulDto.getUpdateBy());
        attendSchedul.setUpdateTime(new Date());
        attendSchedul.setIsDelete("0");
        attendSchedul.setWeeks(StringUtils.join(attendSchedulDto.getWeeks(), (String)","));
        AttendSchedulDetail tempSchedulDetail = new AttendSchedulDetail();
        tempSchedulDetail.setSchedulId(attendSchedul.getId());
        tempSchedulDetail.setAttendId(attendSchedulDto.getAttendId());
        tempSchedulDetail.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        if ("1".equals(attendSchedulDto.getNeedCalendar())) {
            if (attendSchedulDto.getCalendarId() == null) {
                throw new BusinessException("\u65e5\u5386\u5957\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tempSchedulDetail.setCalendarId(attendSchedulDto.getCalendarId());
            AttendCalendarRestDetailDto searchDto = new AttendCalendarRestDetailDto();
            searchDto.setCalendarId(attendSchedulDto.getCalendarId());
            List<AttendCalendarRestDetailDto> restList = this.attendCalendarRestDetailMapper.selectList(searchDto);
            restMap = restList.stream().collect(Collectors.toMap(AttendCalendarRestDetailDto::getRestDate, Function.identity()));
        }
        tempSchedulDetail.setCreateTime(DateUtils.getNowDate());
        tempSchedulDetail.setUpdateTime(DateUtils.getNowDate());
        tempSchedulDetail.setCreateBy(attendSchedulDto.getCreateBy());
        tempSchedulDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
        tempSchedulDetail.setIsDelete("0");
        AttendSchedulDetail attendSchedulDetail = null;
        AttendShift attendShift = null;
        List<AttendSchedulDetail> conflictSchedulList = this.attendSchedulDetailMapper.getConflictSchedulList(attendSchedulDto, DateUtils.formatDate((Date)startDate, (Object[])new Object[]{DateUtils.YYYY_MM_DD}), DateUtils.formatDate((Date)endDate, (Object[])new Object[]{DateUtils.YYYY_MM_DD}));
        conflictSchedulList.stream();
        Map<String, List<AttendSchedulDetail>> schedulClockMap = conflictSchedulList.stream().collect(Collectors.groupingBy(AttendSchedulDetail::getSchedulDate));
        for (Date date : dateList) {
            List<AttendSchedulDetail> attendSchedulDetails = schedulClockMap.get(DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd"));
            Map<Object, Object> perSchedulMap = new HashMap();
            if (attendSchedulDetails != null) {
                perSchedulMap = attendSchedulDetails.stream().collect(Collectors.groupingBy(AttendSchedulDetail::getPerId));
            }
            for (String perId : attendSchedulDto.getPerIds()) {
                if (restMap.get(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date)) != null) {
                    try {
                        attendSchedulDetail = tempSchedulDetail.clone();
                        attendSchedulDetail.setId(this.idWorker.nextId());
                        attendSchedulDetail.setPerId(Long.parseLong(perId));
                        PerOrgRelation relation = this.perOrgRelationMapper.findByPerId(Long.parseLong(perId));
                        attendSchedulDetail.setDeptId(relation.getOrgId());
                        attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date));
                        attendSchedulDetail.setSchedulType("0");
                        schedulList.add(attendSchedulDetail);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                for (String shiftId : attendSchedulDto.getShiftIds()) {
                    attendShift = (AttendShift)((Object)shiftMap.get(Long.parseLong(shiftId)));
                    try {
                        attendSchedulDetail = tempSchedulDetail.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    attendSchedulDetail.setId(this.idWorker.nextId());
                    attendSchedulDetail.setPerId(Long.parseLong(perId));
                    PerOrgRelation relation = this.perOrgRelationMapper.findByPerId(Long.parseLong(perId));
                    attendSchedulDetail.setDeptId(relation.getOrgId());
                    attendSchedulDetail.setSchedulType("1");
                    attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date));
                    attendSchedulDetail.setNeedRest(attendShift.getNeedRest());
                    if ("1".equals(attendShift.getNeedRest())) {
                        Date restStart = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestStart()));
                        Date restEnd = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestEnd()));
                        if (restStart.getTime() > restEnd.getTime()) {
                            restEnd = DateUtils.addDays((Date)restEnd, (int)1);
                        }
                        attendSchedulDetail.setRestStart(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)restStart));
                        attendSchedulDetail.setRestEnd(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)restEnd));
                    }
                    Date startTime = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getStartTime()));
                    attendSchedulDetail.setStartTime(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)startTime));
                    if ("1".equals(attend.getShiftType())) {
                        Date endTime = DateUtils.parseDate((Object)(attendSchedulDetail.getSchedulDate() + " " + attendShift.getEndTime()));
                        if (startTime.getTime() > endTime.getTime()) {
                            endTime = DateUtils.addDays((Date)endTime, (int)1);
                        }
                        attendSchedulDetail.setEndTime(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)endTime));
                    }
                    attendSchedulDetail.setShiftId(attendShift.getId());
                    boolean conflict = false;
                    if (perSchedulMap.get(Long.parseLong(perId)) != null) {
                        List schedulDetails = (List)perSchedulMap.get(Long.parseLong(perId));
                        for (AttendSchedulDetail schedulDetail : schedulDetails) {
                            AttendSchedulConflictDetail conflictDetail;
                            if ("2".equals(attend.getShiftType())) {
                                if (!schedulDetail.getShiftId().equals(attendSchedulDetail.getShiftId())) continue;
                                conflict = true;
                                conflictDetail = new AttendSchedulConflictDetail();
                                conflictDetail.setId(this.idWorker.nextId());
                                conflictDetail.setConflictId(attendSchedulDetail.getId());
                                conflictDetail.setSchedulDetailId(schedulDetail.getId());
                                conflictDetail.setCreateTime(DateUtils.getNowDate());
                                conflictDetail.setUpdateTime(DateUtils.getNowDate());
                                conflictDetail.setCreateBy(attendSchedulDto.getCreateBy());
                                conflictDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
                                conflictDetail.setIsDelete("0");
                                schedulConflictDetailList.add(conflictDetail);
                                continue;
                            }
                            if ((DateUtil.convertStringToDate((String)schedulDetail.getStartTime()).getTime() < DateUtil.convertStringToDate((String)attendSchedulDetail.getStartTime()).getTime() || DateUtil.convertStringToDate((String)schedulDetail.getEndTime()).getTime() > DateUtil.convertStringToDate((String)attendSchedulDetail.getEndTime()).getTime()) && (!schedulDetail.getShiftId().equals(attendSchedulDetail.getShiftId()) || DateUtil.convertStringToDate((String)schedulDetail.getStartTime()).getTime() <= DateUtil.convertStringToDate((String)attendSchedulDetail.getStartTime()).getTime() || DateUtil.convertStringToDate((String)schedulDetail.getEndTime()).getTime() >= DateUtil.convertStringToDate((String)attendSchedulDetail.getEndTime()).getTime())) continue;
                            conflict = true;
                            conflictDetail = new AttendSchedulConflictDetail();
                            conflictDetail.setId(this.idWorker.nextId());
                            conflictDetail.setConflictId(attendSchedulDetail.getId());
                            conflictDetail.setSchedulDetailId(schedulDetail.getId());
                            conflictDetail.setCreateTime(DateUtils.getNowDate());
                            conflictDetail.setUpdateTime(DateUtils.getNowDate());
                            conflictDetail.setCreateBy(attendSchedulDto.getCreateBy());
                            conflictDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
                            conflictDetail.setIsDelete("0");
                            schedulConflictDetailList.add(conflictDetail);
                        }
                    }
                    if (conflict) {
                        AttendSchedulConflict attendSchedulConflict = new AttendSchedulConflict();
                        BeanUtils.copyPropertiesIgnore((Object)attendSchedulDetail, (Object)attendSchedulConflict, (Boolean)true);
                        attendSchedulConflict.setConflictState("0");
                        schedulConflictList.add(attendSchedulConflict);
                        continue;
                    }
                    schedulList.add(attendSchedulDetail);
                }
            }
        }
        if (schedulList.size() > 0) {
            this.attendSchedulDetailMapper.saveBatch(schedulList);
        }
        if (schedulConflictList.size() > 0) {
            this.attendSchedulConflictMapper.saveBatch(schedulConflictList);
        }
        if (schedulConflictDetailList.size() > 0) {
            this.attendSchedulConflictDetailMapper.saveBatch(schedulConflictDetailList);
        }
        this.attendSchedulMapper.save(attendSchedul);
        if (schedulConflictList.size() > 0) {
            return AjaxResult.warn((String)"\u51fa\u73b0\u6392\u73ed\u51b2\u7a81");
        }
        return AjaxResult.success();
    }

    @Override
    public List<PerBaseInfo> getDepartPersonList(AttendSchedulPerDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<PerBaseInfo>();
        }
        return this.attendSchedulDetailMapper.getDepartPerSonList(searchDto);
    }

    @Override
    public List<AppAttendSchedulDto> monthDetail(AppAttendSchedulDto searchDto) {
        AttendShiftDto attendShiftDto = new AttendShiftDto();
        attendShiftDto.setAttendId(searchDto.getAttendId());
        attendShiftDto.setActive("1");
        List<AppAttendShiftDto> shiftList = this.attendShiftService.findByAttendId(attendShiftDto);
        if (shiftList.size() == 0) {
            throw new BusinessException("\u8be5\u8003\u52e4\u5957\u4e0d\u5b58\u5728\u542f\u7528\u7684\u73ed\u6b21\uff01");
        }
        Map<Long, String> shiftMap = shiftList.stream().collect(Collectors.toMap(AttendShift::getId, AppAttendShiftDto::getLetterTag));
        List<AppAttendSchedulDto> list = this.attendSchedulDetailMapper.monthDetail(searchDto);
        for (AppAttendSchedulDto appAttendSchedulDto : list) {
            ArrayList<String> letterTagList = new ArrayList<String>();
            for (String shiftId : appAttendSchedulDto.getShiftIds().split(",")) {
                if (shiftMap.get(Long.parseLong(shiftId)) == null) continue;
                letterTagList.add(shiftMap.get(Long.parseLong(shiftId)));
            }
            Collections.sort(letterTagList);
            appAttendSchedulDto.setShiftNames(StringUtils.join(letterTagList, (String)","));
        }
        return list;
    }

    @Override
    public int deleteByIds(String ids) {
        return this.attendSchedulDetailMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteById(Long id) {
        return this.attendSchedulDetailMapper.deleteById(id);
    }
}

