var datums = {
  wgs84: {
    towgs84: '0,0,0',
    ellipse: 'WGS84',
    datumName: 'WGS84'
  },
  ch1903: {
    towgs84: '674.374,15.056,405.346',
    ellipse: 'bessel',
    datumName: 'swiss'
  },
  ggrs87: {
    towgs84: '-199.87,74.79,246.62',
    ellipse: 'GRS80',
    datumName: 'Greek_Geodetic_Reference_System_1987'
  },
  nad83: {
    towgs84: '0,0,0',
    ellipse: 'GRS80',
    datumName: 'North_American_Datum_1983'
  },
  nad27: {
    nadgrids: '@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat',
    ellipse: 'clrk66',
    datumName: 'North_American_Datum_1927'
  },
  potsdam: {
    towgs84: '598.1,73.7,418.2,0.202,0.045,-2.455,6.7',
    ellipse: 'bessel',
    datumName: 'Potsdam Rauenberg 1950 DHDN'
  },
  carthage: {
    towgs84: '-263.0,6.0,431.0',
    ellipse: 'clark80',
    datumName: 'Carthage 1934 Tunisia'
  },
  hermannskogel: {
    towgs84: '577.326,90.129,463.919,5.137,1.474,5.297,2.4232',
    ellipse: 'bessel',
    datumName: 'Hermannskogel'
  },
  mgi: {
    towgs84: '577.326,90.129,463.919,5.137,1.474,5.297,2.4232',
    ellipse: 'bessel',
    datumName: 'Militar-Geographische Institut'
  },
  osni52: {
    towgs84: '482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15',
    ellipse: 'airy',
    datumName: 'Irish National'
  },
  ire65: {
    towgs84: '482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15',
    ellipse: 'mod_airy',
    datumName: 'Ireland 1965'
  },
  rassadiran: {
    towgs84: '-133.63,-157.5,-158.62',
    ellipse: 'intl',
    datumName: 'Rassadiran'
  },
  nzgd49: {
    towgs84: '59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993',
    ellipse: 'intl',
    datumName: 'New Zealand Geodetic Datum 1949'
  },
  osgb36: {
    towgs84: '446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894',
    ellipse: 'airy',
    datumName: 'Ordnance Survey of Great Britain 1936'
  },
  s_jtsk: {
    towgs84: '589,76,480',
    ellipse: 'bessel',
    datumName: 'S-JTSK (Ferro)'
  },
  beduaram: {
    towgs84: '-106,-87,188',
    ellipse: 'clrk80',
    datumName: 'Beduaram'
  },
  gunung_segara: {
    towgs84: '-403,684,41',
    ellipse: 'bessel',
    datumName: 'Gunung Segara Jakarta'
  },
  rnb72: {
    towgs84: '106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1',
    ellipse: 'intl',
    datumName: 'Reseau National Belge 1972'
  },
  EPSG_5451: {
    towgs84: '6.41,-49.05,-11.28,1.5657,0.5242,6.9718,-5.7649'
  },
  IGNF_LURESG: {
    towgs84: '-192.986,13.673,-39.309,-0.4099,-2.9332,2.6881,0.43'
  },
  EPSG_4614: {
    towgs84: '-119.4248,-303.65872,-11.00061,1.164298,0.174458,1.096259,3.657065'
  },
  EPSG_4615: {
    towgs84: '-494.088,-312.129,279.877,-1.423,-1.013,1.59,-0.748'
  },
  ESRI_37241: {
    towgs84: '-76.822,257.457,-12.817,2.136,-0.033,-2.392,-0.031'
  },
  ESRI_37249: {
    towgs84: '-440.296,58.548,296.265,1.128,10.202,4.559,-0.438'
  },
  ESRI_37245: {
    towgs84: '-511.151,-181.269,139.609,1.05,2.703,1.798,3.071'
  },
  EPSG_4178: {
    towgs84: '24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01'
  },
  EPSG_4622: {
    towgs84: '-472.29,-5.63,-304.12,0.4362,-0.8374,0.2563,1.8984'
  },
  EPSG_4625: {
    towgs84: '126.93,547.94,130.41,-2.7867,5.1612,-0.8584,13.8227'
  },
  EPSG_5252: {
    towgs84: '0.023,0.036,-0.068,0.00176,0.00912,-0.01136,0.00439'
  },
  EPSG_4314: {
    towgs84: '597.1,71.4,412.1,0.894,0.068,-1.563,7.58'
  },
  EPSG_4282: {
    towgs84: '-178.3,-316.7,-131.5,5.278,6.077,10.979,19.166'
  },
  EPSG_4231: {
    towgs84: '-83.11,-97.38,-117.22,0.0276,-0.2167,0.2147,0.1218'
  },
  EPSG_4274: {
    towgs84: '-230.994,102.591,25.199,0.633,-0.239,0.9,1.95'
  },
  EPSG_4134: {
    towgs84: '-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.71006'
  },
  EPSG_4254: {
    towgs84: '18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0013'
  },
  EPSG_4159: {
    towgs84: '-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175'
  },
  EPSG_4687: {
    towgs84: '0.072,-0.507,-0.245,0.0183,-0.0003,0.007,-0.0093'
  },
  EPSG_4227: {
    towgs84: '-83.58,-397.54,458.78,-17.595,-2.847,4.256,3.225'
  },
  EPSG_4746: {
    towgs84: '599.4,72.4,419.2,-0.062,-0.022,-2.723,6.46'
  },
  EPSG_4745: {
    towgs84: '612.4,77,440.2,-0.054,0.057,-2.797,2.55'
  },
  EPSG_6311: {
    towgs84: '8.846,-4.394,-1.122,-0.00237,-0.146528,0.130428,0.783926'
  },
  EPSG_4289: {
    towgs84: '565.7381,50.4018,465.2904,-1.91514,1.60363,-9.09546,4.07244'
  },
  EPSG_4230: {
    towgs84: '-68.863,-134.888,-111.49,-0.53,-0.14,0.57,-3.4'
  },
  EPSG_4154: {
    towgs84: '-123.02,-158.95,-168.47'
  },
  EPSG_4156: {
    towgs84: '570.8,85.7,462.8,4.998,1.587,5.261,3.56'
  },
  EPSG_4299: {
    towgs84: '482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15'
  },
  EPSG_4179: {
    towgs84: '33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84'
  },
  EPSG_4313: {
    towgs84: '-106.8686,52.2978,-103.7239,0.3366,-0.457,1.8422,-1.2747'
  },
  EPSG_4194: {
    towgs84: '163.511,127.533,-159.789'
  },
  EPSG_4195: {
    towgs84: '105,326,-102.5'
  },
  EPSG_4196: {
    towgs84: '-45,417,-3.5'
  },
  EPSG_4611: {
    towgs84: '-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246'
  },
  EPSG_4633: {
    towgs84: '137.092,131.66,91.475,-1.9436,-11.5993,-4.3321,-7.4824'
  },
  EPSG_4641: {
    towgs84: '-408.809,366.856,-412.987,1.8842,-0.5308,2.1655,-121.0993'
  },
  EPSG_4643: {
    towgs84: '-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7002'
  },
  EPSG_4300: {
    towgs84: '482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15'
  },
  EPSG_4188: {
    towgs84: '482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15'
  },
  EPSG_4660: {
    towgs84: '982.6087,552.753,-540.873,32.39344,-153.25684,-96.2266,16.805'
  },
  EPSG_4662: {
    towgs84: '97.295,-263.247,310.882,-1.5999,0.8386,3.1409,13.3259'
  },
  EPSG_3906: {
    towgs84: '577.88891,165.22205,391.18289,4.9145,-0.94729,-13.05098,7.78664'
  },
  EPSG_4307: {
    towgs84: '-209.3622,-87.8162,404.6198,0.0046,3.4784,0.5805,-1.4547'
  },
  EPSG_6892: {
    towgs84: '-76.269,-16.683,68.562,-6.275,10.536,-4.286,-13.686'
  },
  EPSG_4690: {
    towgs84: '221.597,152.441,176.523,2.403,1.3893,0.884,11.4648'
  },
  EPSG_4691: {
    towgs84: '218.769,150.75,176.75,3.5231,2.0037,1.288,10.9817'
  },
  EPSG_4629: {
    towgs84: '72.51,345.411,79.241,-1.5862,-0.8826,-0.5495,1.3653'
  },
  EPSG_4630: {
    towgs84: '165.804,216.213,180.26,-0.6251,-0.4515,-0.0721,7.4111'
  },
  EPSG_4692: {
    towgs84: '217.109,86.452,23.711,0.0183,-0.0003,0.007,-0.0093'
  },
  EPSG_9333: {
    towgs84: '0,0,0,-8.393,0.749,-10.276,0'
  },
  EPSG_9059: {
    towgs84: '0,0,0'
  },
  EPSG_4312: {
    towgs84: '601.705,84.263,485.227,4.7354,1.3145,5.393,-2.3887'
  },
  EPSG_4123: {
    towgs84: '-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496'
  },
  EPSG_4309: {
    towgs84: '-124.45,183.74,44.64,-0.4384,0.5446,-0.9706,-2.1365'
  },
  ESRI_104106: {
    towgs84: '-283.088,-70.693,117.445,-1.157,0.059,-0.652,-4.058'
  },
  EPSG_4281: {
    towgs84: '-219.247,-73.802,269.529'
  },
  EPSG_4322: {
    towgs84: '0,0,4.5'
  },
  EPSG_4324: {
    towgs84: '0,0,1.9'
  },
  EPSG_4284: {
    towgs84: '43.822,-108.842,-119.585,1.455,-0.761,0.737,0.549'
  },
  EPSG_4277: {
    towgs84: '446.448,-125.157,542.06,0.15,0.247,0.842,-20.489'
  },
  EPSG_4207: {
    towgs84: '-282.1,-72.2,120,-1.529,0.145,-0.89,-4.46'
  },
  EPSG_4688: {
    towgs84: '347.175,1077.618,2623.677,33.9058,-70.6776,9.4013,186.0647'
  },
  EPSG_4689: {
    towgs84: '410.793,54.542,80.501,-2.5596,-2.3517,-0.6594,17.3218'
  },
  EPSG_4720: {
    towgs84: '0,0,4.5'
  },
  EPSG_4273: {
    towgs84: '278.3,93,474.5,7.889,0.05,-6.61,6.21'
  },
  EPSG_4240: {
    towgs84: '204.64,834.74,293.8'
  },
  EPSG_4817: {
    towgs84: '278.3,93,474.5,7.889,0.05,-6.61,6.21'
  },
  ESRI_104131: {
    towgs84: '426.62,142.62,460.09,4.98,4.49,-12.42,-17.1'
  },
  EPSG_4265: {
    towgs84: '-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68'
  },
  EPSG_4263: {
    towgs84: '-111.92,-87.85,114.5,1.875,0.202,0.219,0.032'
  },
  EPSG_4298: {
    towgs84: '-689.5937,623.84046,-65.93566,-0.02331,1.17094,-0.80054,5.88536'
  },
  EPSG_4270: {
    towgs84: '-253.4392,-148.452,386.5267,0.15605,0.43,-0.1013,-0.0424'
  },
  EPSG_4229: {
    towgs84: '-121.8,98.1,-10.7'
  },
  EPSG_4220: {
    towgs84: '-55.5,-348,-229.2'
  },
  EPSG_4214: {
    towgs84: '12.646,-155.176,-80.863'
  },
  EPSG_4232: {
    towgs84: '-345,3,223'
  },
  EPSG_4238: {
    towgs84: '-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037'
  },
  EPSG_4168: {
    towgs84: '-170,33,326'
  },
  EPSG_4131: {
    towgs84: '199,931,318.9'
  },
  EPSG_4152: {
    towgs84: '-0.9102,2.0141,0.5602,0.029039,0.010065,0.010101,0'
  },
  EPSG_5228: {
    towgs84: '572.213,85.334,461.94,4.9732,1.529,5.2484,3.5378'
  },
  EPSG_8351: {
    towgs84: '485.021,169.465,483.839,7.786342,4.397554,4.102655,0'
  },
  EPSG_4683: {
    towgs84: '-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06'
  },
  EPSG_4133: {
    towgs84: '0,0,0'
  },
  EPSG_7373: {
    towgs84: '0.819,-0.5762,-1.6446,-0.00378,-0.03317,0.00318,0.0693'
  },
  EPSG_9075: {
    towgs84: '-0.9102,2.0141,0.5602,0.029039,0.010065,0.010101,0'
  },
  EPSG_9072: {
    towgs84: '-0.9102,2.0141,0.5602,0.029039,0.010065,0.010101,0'
  },
  EPSG_9294: {
    towgs84: '1.16835,-1.42001,-2.24431,-0.00822,-0.05508,0.01818,0.23388'
  },
  EPSG_4212: {
    towgs84: '-267.434,173.496,181.814,-13.4704,8.7154,7.3926,14.7492'
  },
  EPSG_4191: {
    towgs84: '-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703'
  },
  EPSG_4237: {
    towgs84: '52.684,-71.194,-13.975,-0.312,-0.1063,-0.3729,1.0191'
  },
  EPSG_4740: {
    towgs84: '-1.08,-0.27,-0.9'
  },
  EPSG_4124: {
    towgs84: '419.3836,99.3335,591.3451,0.850389,1.817277,-7.862238,-0.99496'
  },
  EPSG_5681: {
    towgs84: '584.9636,107.7175,413.8067,1.1155,0.2824,-3.1384,7.9922'
  },
  EPSG_4141: {
    towgs84: '23.772,17.49,17.859,-0.3132,-1.85274,1.67299,-5.4262'
  },
  EPSG_4204: {
    towgs84: '-85.645,-273.077,-79.708,2.289,-1.421,2.532,3.194'
  },
  EPSG_4319: {
    towgs84: '226.702,-193.337,-35.371,-2.229,-4.391,9.238,0.9798'
  },
  EPSG_4200: {
    towgs84: '24.82,-131.21,-82.66'
  },
  EPSG_4130: {
    towgs84: '0,0,0'
  },
  EPSG_4127: {
    towgs84: '-82.875,-57.097,-156.768,-2.158,1.524,-0.982,-0.359'
  },
  EPSG_4149: {
    towgs84: '674.374,15.056,405.346'
  },
  EPSG_4617: {
    towgs84: '-0.991,1.9072,0.5129,1.25033e-7,4.6785e-8,5.6529e-8,0'
  },
  EPSG_4663: {
    towgs84: '-210.502,-66.902,-48.476,2.094,-15.067,-5.817,0.485'
  },
  EPSG_4664: {
    towgs84: '-211.939,137.626,58.3,-0.089,0.251,0.079,0.384'
  },
  EPSG_4665: {
    towgs84: '-105.854,165.589,-38.312,-0.003,-0.026,0.024,-0.048'
  },
  EPSG_4666: {
    towgs84: '631.392,-66.551,481.442,1.09,-4.445,-4.487,-4.43'
  },
  EPSG_4756: {
    towgs84: '-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188'
  },
  EPSG_4723: {
    towgs84: '-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925'
  },
  EPSG_4726: {
    towgs84: '8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081'
  },
  EPSG_4267: {
    towgs84: '-8.0,160.0,176.0'
  },
  EPSG_5365: {
    towgs84: '-0.16959,0.35312,0.51846,0.03385,-0.16325,0.03446,0.03693'
  },
  EPSG_4218: {
    towgs84: '304.5,306.5,-318.1'
  },
  EPSG_4242: {
    towgs84: '-33.722,153.789,94.959,-8.581,-4.478,4.54,8.95'
  },
  EPSG_4216: {
    towgs84: '-292.295,248.758,429.447,4.9971,2.99,6.6906,1.0289'
  },
  ESRI_104105: {
    towgs84: '631.392,-66.551,481.442,1.09,-4.445,-4.487,-4.43'
  },
  ESRI_104129: {
    towgs84: '0,0,0'
  },
  EPSG_4673: {
    towgs84: '174.05,-25.49,112.57'
  },
  EPSG_4202: {
    towgs84: '-124,-60,154'
  },
  EPSG_4203: {
    towgs84: '-117.763,-51.51,139.061,0.292,0.443,0.277,-0.191'
  },
  EPSG_3819: {
    towgs84: '595.48,121.69,515.35,4.115,-2.9383,0.853,-3.408'
  },
  EPSG_8694: {
    towgs84: '-93.799,-132.737,-219.073,-1.844,0.648,-6.37,-0.169'
  },
  EPSG_4145: {
    towgs84: '275.57,676.78,229.6'
  },
  EPSG_4283: {
    towgs84: '61.55,-10.87,-40.19,39.4924,32.7221,32.8979,-9.994'
  },
  EPSG_4317: {
    towgs84: '2.3287,-147.0425,-92.0802,-0.3092483,0.32482185,0.49729934,5.68906266'
  },
  EPSG_4272: {
    towgs84: '59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993'
  },
  EPSG_4248: {
    towgs84: '-307.7,265.3,-363.5'
  },
  EPSG_5561: {
    towgs84: '24,-121,-76'
  },
  EPSG_5233: {
    towgs84: '-0.293,766.95,87.713,0.195704,1.695068,3.473016,-0.039338'
  },
  ESRI_104130: {
    towgs84: '-86,-98,-119'
  },
  ESRI_104102: {
    towgs84: '682,-203,480'
  },
  ESRI_37207: {
    towgs84: '7,-10,-26'
  },
  EPSG_4675: {
    towgs84: '59.935,118.4,-10.871'
  },
  ESRI_104109: {
    towgs84: '-89.121,-348.182,260.871'
  },
  ESRI_104112: {
    towgs84: '-185.583,-230.096,281.361'
  },
  ESRI_104113: {
    towgs84: '25.1,-275.6,222.6'
  },
  IGNF_WGS72G: {
    towgs84: '0,12,6'
  },
  IGNF_NTFG: {
    towgs84: '-168,-60,320'
  },
  IGNF_EFATE57G: {
    towgs84: '-127,-769,472'
  },
  IGNF_PGP50G: {
    towgs84: '324.8,153.6,172.1'
  },
  IGNF_REUN47G: {
    towgs84: '94,-948,-1262'
  },
  IGNF_CSG67G: {
    towgs84: '-186,230,110'
  },
  IGNF_GUAD48G: {
    towgs84: '-467,-16,-300'
  },
  IGNF_TAHI51G: {
    towgs84: '162,117,154'
  },
  IGNF_TAHAAG: {
    towgs84: '65,342,77'
  },
  IGNF_NUKU72G: {
    towgs84: '84,274,65'
  },
  IGNF_PETRELS72G: {
    towgs84: '365,194,166'
  },
  IGNF_WALL78G: {
    towgs84: '253,-133,-127'
  },
  IGNF_MAYO50G: {
    towgs84: '-382,-59,-262'
  },
  IGNF_TANNAG: {
    towgs84: '-139,-967,436'
  },
  IGNF_IGN72G: {
    towgs84: '-13,-348,292'
  },
  IGNF_ATIGG: {
    towgs84: '1118,23,66'
  },
  IGNF_FANGA84G: {
    towgs84: '150.57,158.33,118.32'
  },
  IGNF_RUSAT84G: {
    towgs84: '202.13,174.6,-15.74'
  },
  IGNF_KAUE70G: {
    towgs84: '126.74,300.1,-75.49'
  },
  IGNF_MOP90G: {
    towgs84: '-10.8,-1.8,12.77'
  },
  IGNF_MHPF67G: {
    towgs84: '338.08,212.58,-296.17'
  },
  IGNF_TAHI79G: {
    towgs84: '160.61,116.05,153.69'
  },
  IGNF_ANAA92G: {
    towgs84: '1.5,3.84,4.81'
  },
  IGNF_MARQUI72G: {
    towgs84: '330.91,-13.92,58.56'
  },
  IGNF_APAT86G: {
    towgs84: '143.6,197.82,74.05'
  },
  IGNF_TUBU69G: {
    towgs84: '237.17,171.61,-77.84'
  },
  IGNF_STPM50G: {
    towgs84: '11.363,424.148,373.13'
  },
  EPSG_4150: {
    towgs84: '674.374,15.056,405.346'
  },
  EPSG_4754: {
    towgs84: '-208.4058,-109.8777,-2.5764'
  },
  ESRI_104101: {
    towgs84: '374,150,588'
  },
  EPSG_4693: {
    towgs84: '0,-0.15,0.68'
  },
  EPSG_6207: {
    towgs84: '293.17,726.18,245.36'
  },
  EPSG_4153: {
    towgs84: '-133.63,-157.5,-158.62'
  },
  EPSG_4132: {
    towgs84: '-241.54,-163.64,396.06'
  },
  EPSG_4221: {
    towgs84: '-154.5,150.7,100.4'
  },
  EPSG_4266: {
    towgs84: '-80.7,-132.5,41.1'
  },
  EPSG_4193: {
    towgs84: '-70.9,-151.8,-41.4'
  },
  EPSG_5340: {
    towgs84: '-0.41,0.46,-0.35'
  },
  EPSG_4246: {
    towgs84: '-294.7,-200.1,525.5'
  },
  EPSG_4318: {
    towgs84: '-3.2,-5.7,2.8'
  },
  EPSG_4121: {
    towgs84: '-199.87,74.79,246.62'
  },
  EPSG_4223: {
    towgs84: '-260.1,5.5,432.2'
  },
  EPSG_4158: {
    towgs84: '-0.465,372.095,171.736'
  },
  EPSG_4285: {
    towgs84: '-128.16,-282.42,21.93'
  },
  EPSG_4613: {
    towgs84: '-404.78,685.68,45.47'
  },
  EPSG_4607: {
    towgs84: '195.671,332.517,274.607'
  },
  EPSG_4475: {
    towgs84: '-381.788,-57.501,-256.673'
  },
  EPSG_4208: {
    towgs84: '-157.84,308.54,-146.6'
  },
  EPSG_4743: {
    towgs84: '70.995,-335.916,262.898'
  },
  EPSG_4710: {
    towgs84: '-323.65,551.39,-491.22'
  },
  EPSG_7881: {
    towgs84: '-0.077,0.079,0.086'
  },
  EPSG_4682: {
    towgs84: '283.729,735.942,261.143'
  },
  EPSG_4739: {
    towgs84: '-156,-271,-189'
  },
  EPSG_4679: {
    towgs84: '-80.01,253.26,291.19'
  },
  EPSG_4750: {
    towgs84: '-56.263,16.136,-22.856'
  },
  EPSG_4644: {
    towgs84: '-10.18,-350.43,291.37'
  },
  EPSG_4695: {
    towgs84: '-103.746,-9.614,-255.95'
  },
  EPSG_4292: {
    towgs84: '-355,21,72'
  },
  EPSG_4302: {
    towgs84: '-61.702,284.488,472.052'
  },
  EPSG_4143: {
    towgs84: '-124.76,53,466.79'
  },
  EPSG_4606: {
    towgs84: '-153,153,307'
  },
  EPSG_4699: {
    towgs84: '-770.1,158.4,-498.2'
  },
  EPSG_4247: {
    towgs84: '-273.5,110.6,-357.9'
  },
  EPSG_4160: {
    towgs84: '8.88,184.86,106.69'
  },
  EPSG_4161: {
    towgs84: '-233.43,6.65,173.64'
  },
  EPSG_9251: {
    towgs84: '-9.5,122.9,138.2'
  },
  EPSG_9253: {
    towgs84: '-78.1,101.6,133.3'
  },
  EPSG_4297: {
    towgs84: '-198.383,-240.517,-107.909'
  },
  EPSG_4269: {
    towgs84: '0,0,0'
  },
  EPSG_4301: {
    towgs84: '-147,506,687'
  },
  EPSG_4618: {
    towgs84: '-59,-11,-52'
  },
  EPSG_4612: {
    towgs84: '0,0,0'
  },
  EPSG_4678: {
    towgs84: '44.585,-131.212,-39.544'
  },
  EPSG_4250: {
    towgs84: '-130,29,364'
  },
  EPSG_4144: {
    towgs84: '214,804,268'
  },
  EPSG_4147: {
    towgs84: '-17.51,-108.32,-62.39'
  },
  EPSG_4259: {
    towgs84: '-254.1,-5.36,-100.29'
  },
  EPSG_4164: {
    towgs84: '-76,-138,67'
  },
  EPSG_4211: {
    towgs84: '-378.873,676.002,-46.255'
  },
  EPSG_4182: {
    towgs84: '-422.651,-172.995,84.02'
  },
  EPSG_4224: {
    towgs84: '-143.87,243.37,-33.52'
  },
  EPSG_4225: {
    towgs84: '-205.57,168.77,-4.12'
  },
  EPSG_5527: {
    towgs84: '-67.35,3.88,-38.22'
  },
  EPSG_4752: {
    towgs84: '98,390,-22'
  },
  EPSG_4310: {
    towgs84: '-30,190,89'
  },
  EPSG_9248: {
    towgs84: '-192.26,65.72,132.08'
  },
  EPSG_4680: {
    towgs84: '124.5,-63.5,-281'
  },
  EPSG_4701: {
    towgs84: '-79.9,-158,-168.9'
  },
  EPSG_4706: {
    towgs84: '-146.21,112.63,4.05'
  },
  EPSG_4805: {
    towgs84: '682,-203,480'
  },
  EPSG_4201: {
    towgs84: '-165,-11,206'
  },
  EPSG_4210: {
    towgs84: '-157,-2,-299'
  },
  EPSG_4183: {
    towgs84: '-104,167,-38'
  },
  EPSG_4139: {
    towgs84: '11,72,-101'
  },
  EPSG_4668: {
    towgs84: '-86,-98,-119'
  },
  EPSG_4717: {
    towgs84: '-2,151,181'
  },
  EPSG_4732: {
    towgs84: '102,52,-38'
  },
  EPSG_4280: {
    towgs84: '-377,681,-50'
  },
  EPSG_4209: {
    towgs84: '-138,-105,-289'
  },
  EPSG_4261: {
    towgs84: '31,146,47'
  },
  EPSG_4658: {
    towgs84: '-73,46,-86'
  },
  EPSG_4721: {
    towgs84: '265.025,384.929,-194.046'
  },
  EPSG_4222: {
    towgs84: '-136,-108,-292'
  },
  EPSG_4601: {
    towgs84: '-255,-15,71'
  },
  EPSG_4602: {
    towgs84: '725,685,536'
  },
  EPSG_4603: {
    towgs84: '72,213.7,93'
  },
  EPSG_4605: {
    towgs84: '9,183,236'
  },
  EPSG_4621: {
    towgs84: '137,248,-430'
  },
  EPSG_4657: {
    towgs84: '-28,199,5'
  },
  EPSG_4316: {
    towgs84: '103.25,-100.4,-307.19'
  },
  EPSG_4642: {
    towgs84: '-13,-348,292'
  },
  EPSG_4698: {
    towgs84: '145,-187,103'
  },
  EPSG_4192: {
    towgs84: '-206.1,-174.7,-87.7'
  },
  EPSG_4311: {
    towgs84: '-265,120,-358'
  },
  EPSG_4135: {
    towgs84: '58,-283,-182'
  },
  ESRI_104138: {
    towgs84: '198,-226,-347'
  },
  EPSG_4245: {
    towgs84: '-11,851,5'
  },
  EPSG_4142: {
    towgs84: '-125,53,467'
  },
  EPSG_4213: {
    towgs84: '-106,-87,188'
  },
  EPSG_4253: {
    towgs84: '-133,-77,-51'
  },
  EPSG_4129: {
    towgs84: '-132,-110,-335'
  },
  EPSG_4713: {
    towgs84: '-77,-128,142'
  },
  EPSG_4239: {
    towgs84: '217,823,299'
  },
  EPSG_4146: {
    towgs84: '295,736,257'
  },
  EPSG_4155: {
    towgs84: '-83,37,124'
  },
  EPSG_4165: {
    towgs84: '-173,253,27'
  },
  EPSG_4672: {
    towgs84: '175,-38,113'
  },
  EPSG_4236: {
    towgs84: '-637,-549,-203'
  },
  EPSG_4251: {
    towgs84: '-90,40,88'
  },
  EPSG_4271: {
    towgs84: '-2,374,172'
  },
  EPSG_4175: {
    towgs84: '-88,4,101'
  },
  EPSG_4716: {
    towgs84: '298,-304,-375'
  },
  EPSG_4315: {
    towgs84: '-23,259,-9'
  },
  EPSG_4744: {
    towgs84: '-242.2,-144.9,370.3'
  },
  EPSG_4244: {
    towgs84: '-97,787,86'
  },
  EPSG_4293: {
    towgs84: '616,97,-251'
  },
  EPSG_4714: {
    towgs84: '-127,-769,472'
  },
  EPSG_4736: {
    towgs84: '260,12,-147'
  },
  EPSG_6883: {
    towgs84: '-235,-110,393'
  },
  EPSG_6894: {
    towgs84: '-63,176,185'
  },
  EPSG_4205: {
    towgs84: '-43,-163,45'
  },
  EPSG_4256: {
    towgs84: '41,-220,-134'
  },
  EPSG_4262: {
    towgs84: '639,405,60'
  },
  EPSG_4604: {
    towgs84: '174,359,365'
  },
  EPSG_4169: {
    towgs84: '-115,118,426'
  },
  EPSG_4620: {
    towgs84: '-106,-129,165'
  },
  EPSG_4184: {
    towgs84: '-203,141,53'
  },
  EPSG_4616: {
    towgs84: '-289,-124,60'
  },
  EPSG_9403: {
    towgs84: '-307,-92,127'
  },
  EPSG_4684: {
    towgs84: '-133,-321,50'
  },
  EPSG_4708: {
    towgs84: '-491,-22,435'
  },
  EPSG_4707: {
    towgs84: '114,-116,-333'
  },
  EPSG_4709: {
    towgs84: '145,75,-272'
  },
  EPSG_4712: {
    towgs84: '-205,107,53'
  },
  EPSG_4711: {
    towgs84: '124,-234,-25'
  },
  EPSG_4718: {
    towgs84: '230,-199,-752'
  },
  EPSG_4719: {
    towgs84: '211,147,111'
  },
  EPSG_4724: {
    towgs84: '208,-435,-229'
  },
  EPSG_4725: {
    towgs84: '189,-79,-202'
  },
  EPSG_4735: {
    towgs84: '647,1777,-1124'
  },
  EPSG_4722: {
    towgs84: '-794,119,-298'
  },
  EPSG_4728: {
    towgs84: '-307,-92,127'
  },
  EPSG_4734: {
    towgs84: '-632,438,-609'
  },
  EPSG_4727: {
    towgs84: '912,-58,1227'
  },
  EPSG_4729: {
    towgs84: '185,165,42'
  },
  EPSG_4730: {
    towgs84: '170,42,84'
  },
  EPSG_4733: {
    towgs84: '276,-57,149'
  },
  ESRI_37218: {
    towgs84: '230,-199,-752'
  },
  ESRI_37240: {
    towgs84: '-7,215,225'
  },
  ESRI_37221: {
    towgs84: '252,-209,-751'
  },
  ESRI_4305: {
    towgs84: '-123,-206,219'
  },
  ESRI_104139: {
    towgs84: '-73,-247,227'
  },
  EPSG_4748: {
    towgs84: '51,391,-36'
  },
  EPSG_4219: {
    towgs84: '-384,664,-48'
  },
  EPSG_4255: {
    towgs84: '-333,-222,114'
  },
  EPSG_4257: {
    towgs84: '-587.8,519.75,145.76'
  },
  EPSG_4646: {
    towgs84: '-963,510,-359'
  },
  EPSG_6881: {
    towgs84: '-24,-203,268'
  },
  EPSG_6882: {
    towgs84: '-183,-15,273'
  },
  EPSG_4715: {
    towgs84: '-104,-129,239'
  },
  IGNF_RGF93GDD: {
    towgs84: '0,0,0'
  },
  IGNF_RGM04GDD: {
    towgs84: '0,0,0'
  },
  IGNF_RGSPM06GDD: {
    towgs84: '0,0,0'
  },
  IGNF_RGTAAF07GDD: {
    towgs84: '0,0,0'
  },
  IGNF_RGFG95GDD: {
    towgs84: '0,0,0'
  },
  IGNF_RGNCG: {
    towgs84: '0,0,0'
  },
  IGNF_RGPFGDD: {
    towgs84: '0,0,0'
  },
  IGNF_ETRS89G: {
    towgs84: '0,0,0'
  },
  IGNF_RGR92GDD: {
    towgs84: '0,0,0'
  },
  EPSG_4173: {
    towgs84: '0,0,0'
  },
  EPSG_4180: {
    towgs84: '0,0,0'
  },
  EPSG_4619: {
    towgs84: '0,0,0'
  },
  EPSG_4667: {
    towgs84: '0,0,0'
  },
  EPSG_4075: {
    towgs84: '0,0,0'
  },
  EPSG_6706: {
    towgs84: '0,0,0'
  },
  EPSG_7798: {
    towgs84: '0,0,0'
  },
  EPSG_4661: {
    towgs84: '0,0,0'
  },
  EPSG_4669: {
    towgs84: '0,0,0'
  },
  EPSG_8685: {
    towgs84: '0,0,0'
  },
  EPSG_4151: {
    towgs84: '0,0,0'
  },
  EPSG_9702: {
    towgs84: '0,0,0'
  },
  EPSG_4758: {
    towgs84: '0,0,0'
  },
  EPSG_4761: {
    towgs84: '0,0,0'
  },
  EPSG_4765: {
    towgs84: '0,0,0'
  },
  EPSG_8997: {
    towgs84: '0,0,0'
  },
  EPSG_4023: {
    towgs84: '0,0,0'
  },
  EPSG_4670: {
    towgs84: '0,0,0'
  },
  EPSG_4694: {
    towgs84: '0,0,0'
  },
  EPSG_4148: {
    towgs84: '0,0,0'
  },
  EPSG_4163: {
    towgs84: '0,0,0'
  },
  EPSG_4167: {
    towgs84: '0,0,0'
  },
  EPSG_4189: {
    towgs84: '0,0,0'
  },
  EPSG_4190: {
    towgs84: '0,0,0'
  },
  EPSG_4176: {
    towgs84: '0,0,0'
  },
  EPSG_4659: {
    towgs84: '0,0,0'
  },
  EPSG_3824: {
    towgs84: '0,0,0'
  },
  EPSG_3889: {
    towgs84: '0,0,0'
  },
  EPSG_4046: {
    towgs84: '0,0,0'
  },
  EPSG_4081: {
    towgs84: '0,0,0'
  },
  EPSG_4558: {
    towgs84: '0,0,0'
  },
  EPSG_4483: {
    towgs84: '0,0,0'
  },
  EPSG_5013: {
    towgs84: '0,0,0'
  },
  EPSG_5264: {
    towgs84: '0,0,0'
  },
  EPSG_5324: {
    towgs84: '0,0,0'
  },
  EPSG_5354: {
    towgs84: '0,0,0'
  },
  EPSG_5371: {
    towgs84: '0,0,0'
  },
  EPSG_5373: {
    towgs84: '0,0,0'
  },
  EPSG_5381: {
    towgs84: '0,0,0'
  },
  EPSG_5393: {
    towgs84: '0,0,0'
  },
  EPSG_5489: {
    towgs84: '0,0,0'
  },
  EPSG_5593: {
    towgs84: '0,0,0'
  },
  EPSG_6135: {
    towgs84: '0,0,0'
  },
  EPSG_6365: {
    towgs84: '0,0,0'
  },
  EPSG_5246: {
    towgs84: '0,0,0'
  },
  EPSG_7886: {
    towgs84: '0,0,0'
  },
  EPSG_8431: {
    towgs84: '0,0,0'
  },
  EPSG_8427: {
    towgs84: '0,0,0'
  },
  EPSG_8699: {
    towgs84: '0,0,0'
  },
  EPSG_8818: {
    towgs84: '0,0,0'
  },
  EPSG_4757: {
    towgs84: '0,0,0'
  },
  EPSG_9140: {
    towgs84: '0,0,0'
  },
  EPSG_8086: {
    towgs84: '0,0,0'
  },
  EPSG_4686: {
    towgs84: '0,0,0'
  },
  EPSG_4737: {
    towgs84: '0,0,0'
  },
  EPSG_4702: {
    towgs84: '0,0,0'
  },
  EPSG_4747: {
    towgs84: '0,0,0'
  },
  EPSG_4749: {
    towgs84: '0,0,0'
  },
  EPSG_4674: {
    towgs84: '0,0,0'
  },
  EPSG_4755: {
    towgs84: '0,0,0'
  },
  EPSG_4759: {
    towgs84: '0,0,0'
  },
  EPSG_4762: {
    towgs84: '0,0,0'
  },
  EPSG_4763: {
    towgs84: '0,0,0'
  },
  EPSG_4764: {
    towgs84: '0,0,0'
  },
  EPSG_4166: {
    towgs84: '0,0,0'
  },
  EPSG_4170: {
    towgs84: '0,0,0'
  },
  EPSG_5546: {
    towgs84: '0,0,0'
  },
  EPSG_7844: {
    towgs84: '0,0,0'
  },
  EPSG_4818: {
    towgs84: '589,76,480'
  }
};

for (var key in datums) {
  var datum = datums[key];
  if (!datum.datumName) {
    continue;
  }
  datums[datum.datumName] = datum;
}

export default datums;
