var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));

// index.ts
import { clone } from "@turf/clone";
import { distance } from "@turf/distance";
import { featureEach } from "@turf/meta";
function nearestPoint(targetPoint, points, options = {}) {
  if (!targetPoint) throw new Error("targetPoint is required");
  if (!points) throw new Error("points is required");
  let minDist = Infinity;
  let bestFeatureIndex = 0;
  featureEach(points, (pt, featureIndex) => {
    const distanceToPoint = distance(targetPoint, pt, options);
    if (distanceToPoint < minDist) {
      bestFeatureIndex = featureIndex;
      minDist = distanceToPoint;
    }
  });
  const nearestPoint2 = clone(points.features[bestFeatureIndex]);
  return __spreadProps(__spreadValues({}, nearestPoint2), {
    properties: __spreadProps(__spreadValues({}, nearestPoint2.properties), {
      featureIndex: bestFeatureIndex,
      distanceToPoint: minDist
    })
  });
}
var index_default = nearestPoint;
export {
  index_default as default,
  nearestPoint
};
//# sourceMappingURL=index.js.map