import { GeometryObject, FeatureCollection } from 'geojson';

/**
 * Takes a {@link FeatureCollection} and returns a FeatureCollection with given number of {@link Feature|features} at random.
 *
 * @function
 * @param {FeatureCollection} featurecollection set of input features
 * @param {number} num number of features to select
 * @returns {FeatureCollection} a FeatureCollection with `n` features
 * @example
 * var points = turf.randomPoint(100, {bbox: [-80, 30, -60, 60]});
 *
 * var sample = turf.sample(points, 5);
 *
 * //addToMap
 * var addToMap = [points, sample]
 * turf.featureEach(sample, function (currentFeature) {
 *   currentFeature.properties['marker-size'] = 'large';
 *   currentFeature.properties['marker-color'] = '#000';
 * });
 */
declare function sample<T extends GeometryObject>(fc: FeatureCollection<T>, num: number): FeatureCollection<T>;

export { sample as default, sample };
