// index.ts
import { area } from "@turf/area";
import { bbox } from "@turf/bbox";
import { bboxPolygon } from "@turf/bbox-polygon";
import { centroid } from "@turf/centroid";
import { distance } from "@turf/distance";
import { nearestPoint } from "@turf/nearest-point";
import { featureEach } from "@turf/meta";
import {
  convertArea,
  featureCollection
} from "@turf/helpers";
function nearestNeighborAnalysis(dataset, options) {
  options = options || {};
  const studyArea = options.studyArea || bboxPolygon(bbox(dataset));
  const properties = options.properties || {};
  const units = options.units || "kilometers";
  const features = [];
  featureEach(dataset, (feature) => {
    features.push(centroid(feature));
  });
  const n = features.length;
  const observedMeanDistance = features.map((feature, index) => {
    const otherFeatures = featureCollection(
      features.filter((f, i) => {
        return i !== index;
      })
    );
    return distance(
      feature,
      nearestPoint(feature, otherFeatures).geometry.coordinates,
      { units }
    );
  }).reduce((sum, value) => {
    return sum + value;
  }, 0) / n;
  const populationDensity = n / convertArea(area(studyArea), "meters", units);
  const expectedMeanDistance = 1 / (2 * Math.sqrt(populationDensity));
  const variance = 0.26136 / Math.sqrt(n * populationDensity);
  properties.nearestNeighborAnalysis = {
    units,
    arealUnits: units + "\xB2",
    observedMeanDistance,
    expectedMeanDistance,
    nearestNeighborIndex: observedMeanDistance / expectedMeanDistance,
    numberOfPoints: n,
    zScore: (observedMeanDistance - expectedMeanDistance) / variance
  };
  studyArea.properties = properties;
  return studyArea;
}
var turf_nearest_neighbor_analysis_default = nearestNeighborAnalysis;
export {
  turf_nearest_neighbor_analysis_default as default,
  nearestNeighborAnalysis
};
//# sourceMappingURL=index.js.map