import instance from './ajax';

/**
 * 登录
 * @param {} username 
 * @param {*} password 
 * @param {*} param2 
 */
export const login = (username, password, checkcode, { onSucess, onError }) => {
  instance.post(contextPath + '/designtime/login', { username: username, password: password,checkcode:checkcode})
    .then(function (response) {
      if (onSucess) onSucess(response);
    }).catch(function (error) {
        if (onError) onError(error);
      }
    );
}

/**
 * 退出系统
 * 请求地址：/logout
 */
export const logOut = () => {
  return instance({
    url: contextPath + '/designtime/logout',
    method: 'post'
  })
}

/**
 * 获取特权用户信息
 */
export const getSuperuser = ({ onSucess, onError }) => {
  instance.get(contextPath + '/designtime/applications/getSuperuser')
    .then(function (response) {
      if (onSucess) onSucess(response);
    }).catch(function (error) {
        if (onError) onError(error);
      }
    );
}

/**
 * 修改特权用户信息
 */
export const saveSuperuser = (user, { onSucess, onError }) => {
  let data = {
    "name": user.name,
    "email": user.email,
    "loginno": user.loginno,
    "loginpwd": user.loginpwd
  }
  instance({
    url: contextPath + '/designtime/applications/superuser/'+ user.id,
    method: 'PUT',
    data
  }).then(function(response){
    if(onSucess) onSucess(response);
  }).catch(function(error) {
    if(onError) onError(error);
  })
}

/**
 * 获取调试链接
 */
export const getDebugurlByWar = () => {
  return instance({
    url: contextPath + `/macro/runtime/war/debug/url`,
    method: 'get'
  })
}

/**
 * 获取调试链接（不跑war包的时候）
 */
export const getDebugurl = () => {
  return instance({
    url: contextPath + `/macro/runtime/consul/debug/url`,
    method: 'get'
  })
}

/**
 * 获取系统信息
 */
export const reqSystemInfoList = (params, { onSucess, onError }) => {
  instance.get(contextPath + `/designtime/systeminfo?name=${params.name}&type=${params.type}&pageNo=${params.pageNo}&linesPerPage=${params.linesPerPage}`)
    .then(function (response) {
      if (onSucess) onSucess(response);
    }).catch(function (error) {
        if (onError) onError(error);
      }
    );
}

/**
 * 获取软件列表
 */
export const getApplicationsList = (params, { onSucess, onError }) => {
  instance.get(contextPath + '/designtime/applications?searchword='+ params.searchword +'&pageNo='+ params.pageNo +'&linesPerPage='+ params.linesPerPage)
    .then(function (response) {
      if (onSucess) onSucess(response);
    }).catch(function (error) {
        if (onError) onError(error);
      }
    );
}

/**
 * 获取软件列表详情
 */
export const getApplications = (params, { onSucess, onError }) => {
  instance.get(contextPath + '/designtime/applications/'+ params.id)
    .then(function (response) {
      if (onSucess) onSucess(response);
    }).catch(function (error) {
        if (onError) onError(error);
      }
    );
}


/**
 * 新建软件列表
 */
export const newApplication = (data) => {
  return instance({
    url: contextPath + '/designtime/applications',
    method: 'post',
    data
  })
}

/**
 * 更新软件列表
 */
export const updateApplication = (params, { onSucess, onError }) => {
  let data = {
    "name": params.name,
    "description": params.description,
    "type": params.type,
    "activated": params.activated,
    "orderNo": params.orderNo,
    "datasourceId": params.datasourceId?params.datasourceId:"",
    url:params.URL?params.URL:'',
    token:params.Token?params.Token:'',
    encodingAESkey:params.EncodingAESkey?params.EncodingAESkey:'',

  }
  instance({
    url: contextPath + '/designtime/applications/' + params.id,
    method: 'PUT',
    data
  }).then(function(response){
    if(onSucess) onSucess(response);
  }).catch(function(error) {
    if(onError) onError(error);
  })
}

/**
 * 删除软件
 */
export const deleteApplications = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/',
    method: 'delete',
    data
  })
}


/**
 * 生成概览
 */
export const oveorview = (id, { onSucess, onError }) => {
  instance({
    url: contextPath + '/designtime/applications/'+ id +'/overview',
    method: 'GET',
    responseType:'blob',
  }).then(function(response){
    if(onSucess) onSucess(response);
  }).catch(function(error) {
    if(onError) onError(error);
  })
}


/**
 * 通过数据源获取返回结果集的列信息
 */
export const getDataSourcesList = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + `/designtime/applications/${params.appId}/reports/getQueryColumnInfos?type=${params.type}`,
    method: 'POST',
    data: data
  }).then(function(response){
    if(onSucess) onSucess(response);
  }).catch(function(error) {
    if(onError) onError(error);
  })
}


/**
 * 获取模块树
 */
export const getModulesTree = (appId, parentId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/modules?parentId='+ parentId,
    method: 'get'
  })
}

/**
 * **获取树形结构所有模块列表**
 */
export const getAllmodules = (appId, currentModuleId) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/allmodules?currentModuleId=${currentModuleId}`,
    method: 'get'
  })
}

/**
 * 创建模块-基本信息
 */
export const getModulesBasicInfo = (params) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ params.appId +'/modules',
    method: 'post',
    data: params
  })
}

/**
 * 删除节点-基本信息
 */
export const delectModules = (selectedArray) => {
  return instance({
    url: contextPath + '/designtime/applications/modules',
    method: 'delete',
    data: selectedArray
  })
}


/**
 * 获取模块基本信息详情
 */
export const getBasiInfor = (moduleId) => {
  return instance({
    url: contextPath + '/designtime/applications/modules/'+ moduleId,
    method: 'get'
  })
}

/**
 * 更新模块-基本信息
 */
export const updateModules = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ data.appId +'/modules/'+ data.id,
    method: 'put',
    data
  })
}
/**
 * 获取平台模式回调日志
 */
export const getCbLogData = (applicationId, { onSucess, onError }) => {
  instance.get(contextPath + `/designtime/applications/${applicationId}/getCallBackLogs`)
    .then(function (response) {
      if (onSucess) onSucess(response);
    }).catch(function (error) {
        if (onError) onError(error);
      }
    );
}
