class Graphics {
    constructor(ctx){
        this.ctx = ctx;
        this.ctx.translate(0.5, 0.5);
    }

    setColor(color){
        this.ctx.fillStyle = color;
        this.ctx.strokeStyle = color;
    }

    setFont(font){
        this.ctx.font = font;
    }

    textAlign(align){
        this.ctx.textAlign = align; 
    }

    stringWidth(txt){
        return this.ctx.measureText(txt).width;
    }

    strokeRect(x, y, width, height){
        this.ctx.strokeRect(x, y, width, height);
    }
    //xh画一个椭圆边框
    drawOvalBorder(x, y, width, height,p,color="#000"){
        let ctx=this.ctx;
        ctx.beginPath();
		ctx.moveTo(x+p,y);
		ctx.lineTo(x+width-2*p, y);
		ctx.quadraticCurveTo(x+width,y,x+width,y+p);
		ctx.lineTo(x+width,y+height-2*p);
		ctx.quadraticCurveTo(x+width,y+height,x+width-p,y+height);
		ctx.lineTo(x+p,y+height);
		ctx.quadraticCurveTo(x,y+height,x,y+height-p);
		ctx.lineTo(x,y+p);
        ctx.quadraticCurveTo(x,y,x+p,y);
        this.setColor(color);
        ctx.stroke();
        this.setColor("#fff");
		ctx.fill();
    }

    // yx画菱形
    drawDiamondBorder(x,y, width = 150, height = 70){
        let ctx=this.ctx;
        ctx.beginPath();
        ctx.moveTo(x + width/2, y);
        ctx.lineTo(x + width, y + height/2);
        ctx.lineTo(x + width/2, y + height);
        ctx.lineTo(x, y + height/2)
        ctx.closePath();
        // this.setColor("#000");
        // ctx.stroke();
        this.setColor("#ebcafe");
		ctx.fill();
    }

    translate(x, y){
        this.ctx.translate(x, y)
    }

    fillText(text, x, y){
        //console.log(text,x,y);
        this.ctx.fillText(text, x, y);
    }

    // yx 计算长度再显示文字[超出第二行显示省略号]
    /**
     * 
     * @param {文字} t 
     * @param {横坐标} x 
     * @param {文字高度} y 
     * @param {显示的文字宽度} w 
     */
    drawText(t,x,y,w=80, shape="rect"){
        let chr = t.split("");
        let temp = "";				
        let row = [];
        for(let a = 0; a < chr.length; a++){
            if(this.ctx.measureText(temp).width < w ){
                ;
            }
            else{
                row.push(temp);
                temp = "";
            }
            temp += chr[a];
        }
        
        row.push(temp);
        
        // 判断小于2行全部画出来，大于两行显示省略号
        if(row.length < 3){
            for(let b = 0; b < row.length; b++){
                this.ctx.fillText(row[b],x + 10,y+b*16); // 16： 字体大小
            }
        }else{
            row[1] = row[1] + '...'
            this.ctx.fillText(row[0],x + 10,y);
            this.ctx.fillText(row[1],x + 10,y+16);
        }
    }

    fillRect(x, y, width, height){
        this.ctx.fillRect(x, y, width, height);
    }

    fillPolygon(polygon){
        this.ctx.beginPath();
        for(let i = 0; i < polygon.points.length; i++){
            if(i == 0){
                this.ctx.moveTo(polygon.points[i].x,polygon.points[i].y);
            }else{
                this.ctx.lineTo(polygon.points[i].x,polygon.points[i].y);
            }
        }
        this.ctx.fill();
    }

    drawLine (x1, y1, x2, y2){     
        this.ctx.beginPath();
        this.ctx.moveTo(x1, y1);
        this.ctx.lineTo(x2, y2);
        this.ctx.closePath();
        this.ctx.stroke();
    }

    drawImage(image, x, y, width, height){
        this.ctx.drawImage(image, x, y, width, height);
    }

    drawRect(x, y, width, height){
        this.ctx.strokeRect(x, y, width, height);
    }

    drawString(text, x, y){
        this.ctx.fillText(text, x, y);
    }

    // yx画圆
    drawArc(x, y, r, color, borderColor, staAngle = 0, endAngle = Math.PI * 2, antiClockWise = false) {
        this.ctx.beginPath();
        this.ctx.arc(x, y, r, staAngle, endAngle, antiClockWise);
        this.ctx.closePath();
        this.setColor(borderColor);
        this.setLineWidth(1);
        this.ctx.stroke();
        this.setColor(color);
        this.ctx.fill();
    }
    
    setLineWidth(width) {
        this.ctx.lineWidth = width;
    }

    save() {
        this.ctx.save();
    }
    
    restore() {
        this.ctx.restore();
    }
}

export default Graphics;