import AutoNode from '../element/AutoNode';
import CompleteNode from '../element/CompleteNode';
import ManualNode from '../element/ManualNode';
import Relation from '../element/Relation';
import StartNode from '../element/StartNode';
import SubFlow from '../element/SubFlow';
import StringUtil from '../utility/StringUtil';

class XMLOperate {
  constructor(xml, diagram) {
    this.xml = xml;
    this.flowDiagram = diagram;
    this.flowDiagram._elems = [];
  }

  setElementProps(xmlNode, element) {
    const { tagName } = xmlNode;
    // console.log(tagName)
    // let parentTagName = xmlNode.parentElement.tagName;
    const tagValue = xmlNode.childNodes[0] ? xmlNode.childNodes[0].nodeValue : '';

    // switch(parentTagName){
    //     //FlowDiagram
    //     case 'cn.myapps.runtime.workflow.element.FlowDiagram':
    //         if((tagName == 'width' && tagValue > element.width)
    //           || (tagName == 'height' && tagValue > element.height)){
    //             element[tagName] = tagValue
    //         }
    //         break;
    //     default:
    //         element[tagName] = tagValue;
    //         break;
    // }
    const elementObj = element;
    const type = typeof elementObj[tagName];
    const value = StringUtil.dencodeHTML(tagValue);
    if (type === 'number') {
      elementObj[tagName] = parseInt(value, 10);
    } else if (type === 'boolean') {
      elementObj[tagName] = value === 'true';
    } else {
      elementObj[tagName] = value;
    }
  }


  parserXML() {
    const traversalNode = (xmlNode, element) => {
      const { tagName } = xmlNode;
      if (xmlNode.hasChildNodes() && xmlNode.children.length > 0) { // 节点时
        let subElement = null;
        let isFlowDiagramElem = true;
        switch (tagName) {
          // FlowDiagram
          case 'cn.myapps.runtime.workflow.element.FlowDiagram':
            // subElement = new FlowDiagram(canvas);
            subElement = element;
            break;
            // 开始
          case 'cn.myapps.runtime.workflow.element.StartNode':
            subElement = new StartNode(this.flowDiagram);
            break;
            // 手动
          case 'cn.myapps.runtime.workflow.element.ManualNode':
            subElement = new ManualNode(this.flowDiagram);
            break;
            // 完成
          case 'cn.myapps.runtime.workflow.element.CompleteNode':
            subElement = new CompleteNode(this.flowDiagram);
            break;
            // 自动
          case 'cn.myapps.runtime.workflow.element.AutoNode':
            subElement = new AutoNode(this.flowDiagram);
            break;
            // 子流程
          case 'cn.myapps.runtime.workflow.element.SubFlow':
            console.log(this.flowDiagram)
            subElement = new SubFlow(this.flowDiagram);
            break;
            // 线
          case 'cn.myapps.runtime.workflow.element.Relation':
            subElement = new Relation(this.flowDiagram);
            break;

          default:
            isFlowDiagramElem = false;
            break;
        }
        if (isFlowDiagramElem && tagName !== 'cn.myapps.runtime.workflow.element.FlowDiagram') {
          element._elems.push(subElement);
        }

        if (isFlowDiagramElem) {
          for (let i = 0; i < xmlNode.children.length; i += 1) {
            if(xmlNode.nodeName=='cn.myapps.runtime.workflow.element.SubFlow'&& xmlNode.children[i].nodeName=="fieldMappingXML"){
				let text=xmlNode.children[i].innerHTML.replace(/^<!\[CDATA\[/,"").replace(/\]\]>$/,"");
				xmlNode.children[i].innerHTML=text;
				subElement.fieldMappingXML=xmlNode.children[i].innerHTML;
			  
            }else{
              traversalNode(xmlNode.children[i], subElement);
            }

          }
        }
      } else { // 属性时
        this.setElementProps(xmlNode, element);
      }
    };

    traversalNode(this.xml.children[0], this.flowDiagram);

    return this.flowDiagram;
  }
}

export default XMLOperate;
