import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class CheckboxField extends AbstractField{
    constructor(container) {
        super();
        this.scope="checkboxField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">多选框</span>
        </div><div class="baseCon fieldId"  fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="checkbox" readonly class=""></div>`;
        this.propValues.name="多选框"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.texttype = "text";//显示
        this.propValues.readonlyshowvalonly = false; //只读时仅显示值
        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.showfieldtitle = true;//是否显示标题栏
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合
        this.propValues.discript ="";
        // this.propValues.refresh = '0';
        this.propValues.editProp="editCheckboxField";
        this.propValues.editmode = "01"; //值的方式
        this.propValues.valuescript = ""; //脚本值
        this.propValues.processdescription = ""; //值设计脚本的值
        this.propValues.processprevalue = []; //用来存储选中的值设计的字段值
        this.propValues.filtercondition = "";//用来存储设计时的脚本(部分写死)
        this.propValues.isdefaultvalue = false; //仅创建时计算
        this.propValues.validatelibs =[]; //校验方式
        this.propValues.validaterule = ""; //校验脚本
        this.propValues.instantvalidate = false; //即时校验（新增属性）


        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本

        this.propValues.layout="horizontal";//布局

        this.propValues.module="";//选项-设计模块
        this.propValues.dialogview="";//选项-设计视图
        this.propValues.optionsvalue="";//选项-设计显示值
        this.propValues.optionstext="";//选项-设计真实值
        this.propValues.viewsoptions=[{id:"",name:"选择"}];//存储视图的选项，不插入html中
        this.propValues.optionstextoptions=[{id:"",name:"选择"}];//存储真实值的选项，不插入html中

        this.propValues.optionseditmode="01";//选项设计还是脚本模式的参数
        this.propValues.optionsscript="";//选项脚本的值
        this.propValues.fieldtype="VALUE_TYPE_TEXT";
    }
    
    getPropsDesc() {
        return {
            "base":['myselfrows','name','layout','texttype','readonlyshowvalonly','refreshonchanged','refreshmode','refreshfields','calculateonrefresh','mobile', 'showfieldtitle','discript'],
            "value":['editmode','isdefaultvalue','valuescript','processdescription'],
            "options":['optionseditmode','module','optionsscript'],            
            "check":['validatelibs','validaterule','instantvalidate'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']


        }
    }
    
}
export default CheckboxField;