var excelMappingDiagram = window.OBPM.ExcelMappingDiagram;

//console.log(typeof excelMappingDiagram);

var WorkFlowDesign = {};

WorkFlowDesign.Cache = {
    canvas: document.getElementById("workflows-canvas"),
    diagram: null
}

WorkFlowDesign.Utils = {
    encodeHTML: function(t){
        if (t != null) {
            t = t.replace(/#/g, "%23");
            t = t.replace(/&/g, "&amp;");
            t = t.replace(/\"/g, "@quot;");
            t = t.replace(/</g, "@lt;");
            t = t.replace(/>/g, "@gt;");
            t = t.replace(/'/g, "@#146;");
            t = t.replace(/ /g, "@nbsp;");
            t = t.replace(/ /g, "@nbsp;");
            t = t.replace(/\r/g, "&#10;");
            t = t.replace(/\n/g, "&#13;");
        }
        return t;
    },
    
    dencodeHTML: function(t){
        if (t != null) {
            t = t.replace(/&amp;/g, "&");
            t = t.replace(/@amp;/g, "&");
            t = t.replace(/&quot;/g, "\"");
            t = t.replace(/@quot;/g, "\"");
            t = t.replace(/&lt;/g, "<");
            t = t.replace(/@lt;/g, "<");
            t = t.replace(/&gt;/g, ">");
            t = t.replace(/@gt;/g, ">");
            t = t.replace(/&#146;/g, "'");
            t = t.replace(/@#146;/g, "'");
            t = t.replace(/&nbsp;/g, " ");
            t = t.replace(/@nbsp;/g, " ");
            t = t.replace(/&#10;/g, "\r");
            t = t.replace(/&#13;/g, "\n");
            t = t.replace(/&#9;/g, " ");
            t = t.replace(/%23/g, "#");
            t = t.replace(/\n\r/g, "\n");
            t = t.replace(/\r\n/g, "\n");
        }
        return t;
    }
}

WorkFlowDesign.Core = {
    init: function() {
        this.initCanvas();
        this.bindEvent();

        var diagramReady = setInterval(function(){
            var diagram = WorkFlowDesign.Cache.diagram;
            if(diagram){
                clearInterval(diagramReady)
                WorkFlowDesign.Core.renderEditPanel();
                WorkFlowDesign.Core.operateXML();
            }
        },1000)
        
    },
    initCanvas(){
        var canvas = WorkFlowDesign.Cache.canvas;
        //console.log(canvas);
        WorkFlowDesign.Cache.diagram = new excelMappingDiagram(canvas);
        WorkFlowDesign.Cache.diagram.Init();
    },

    operateXML(){
        var diagram = WorkFlowDesign.Cache.diagram;
        var xml = $.trim($("#formItem_content_xml").val());
        if(xml != ""){
            diagram.XMLOperate(xml);
        }  
    },

    bindEvent(){
        var diagram = WorkFlowDesign.Cache.diagram;
        var $activityBar = $("#activitybar .obpm-btn");
        var $saveBtn = $("#save_btn");
        var $xmlContent=$("#formItem_content_xml");
        //var $flowContainer = $("#flow_container");
 
        $("#workflows-canvas").on("click", function(){
            WorkFlowDesign.Core.renderEditPanel();
        });

        // $topBar.find(".activity-save").on("click", function(){
        //     //WorkFlowDesign.Core.savePropWithEditNode();
        //     $flowContainer.val(diagram.toXML());
        //     ev_onsubmit(); 
        // });

        $saveBtn.on("click", function(){
        	var result = diagram.check();

            if(!result) {
                return false;
            }
            $xmlContent.val(diagram.toXML());
            ev_onsubmit()
            
        });

        $activityBar.eq(0).on("click", function(){
            diagram.addMasterSheet();
        });

        $activityBar.eq(1).on("click", function(){
            diagram.addDetailSheet();
        });

        $activityBar.eq(2).on("click", function(){
            diagram.addColumn();
        });

        $activityBar.eq(3).on("click", function(){
            diagram.addRelation();
        });

        $activityBar.eq(4).on("click", function(){
            diagram.removeElement();
        });
    },

    renderEditPanel(){
        var diagram = WorkFlowDesign.Cache.diagram;
        var $setPanel = $(".workflows-setting");
        var $setTitlePanel = $setPanel.find(".edit-title");
        var $setTitle = $setTitlePanel.find(".edit-title-txt");
        var $setContentPanel = $setPanel.find(".edit-content");
        var $html = "";
        var currToEdit = diagram.getCurrToEdit();
		//console.log(currToEdit);
        var $xmlCode=$("#xmlCode");
        var $xmlContent=$("#formItem_content_xml");
        if(currToEdit == null){
            $setTitle.text("excel导入信息");
            var $subject = $("[name='content.name']");
            var $xmlTextConfirm=$("#xmlTextConfirm");
            var flowDiagramData = {
                subject: $subject.val(),
            };
            $html = $(template("editflowdiagram-tmpl", flowDiagramData));
            
            $("#showCode").on("mousedown",function(e){
                $xmlCode.val(diagram.toXML());
                $xmlCode.text(diagram.toXML());
                $xmlContent.val($xmlCode.val());
                $xmlContent.text($xmlCode.val());
                //console.log($xmlContent.val());
            });

            $("#getCode").on("click",function(e){
                $xmlCode.val(diagram.toXML());
                $xmlCode.text(diagram.toXML());
                $xmlContent.val($xmlCode.val());
                $xmlContent.text($xmlCode.val());
                //console.log($xmlContent.val());
            });

            $xmlTextConfirm.on("click",function(){
                var xml=$("#xmlCode").val();
                diagram.XMLOperate(xml);
            });
        }else{
            var currToEditName = currToEdit.getClassName();
            //var splitStartOptions = diagram.getAllSplitNode();
            switch(currToEditName){
                case "cn.myapps.runtime.dynaform.dts.excelimport.MasterSheet":
                    $setTitle.text("主表信息");
                    var masterSheetData = {
                        name: currToEdit.name,
                        formName: currToEdit.formName
                    };
                    $html = $(template("editMasterSheet-tmpl", masterSheetData));
                    break;
                case "cn.myapps.runtime.dynaform.dts.excelimport.DetailSheet":
                    $setTitle.text("子表信息");
                    var detailSheetData = {
                        name: currToEdit.name,
                        formName: currToEdit.formName
                    };
                    $html = $(template("editDetailSheet-tmpl", detailSheetData));
                    break;
                case "cn.myapps.runtime.dynaform.dts.excelimport.Column":
                    $setTitle.text("列信息");
                    var columnData = {
                        name: currToEdit.name,
                        fieldName: currToEdit.fieldName,
                        valueScript:currToEdit.valueScript,
                        validateRule:currToEdit.validateRule
                    };
                    //console.log(currToEdit.primarykey);
                    //console.log(currToEdit.fieldName);
                    $html = $(template("editColumn-tmpl", columnData));
                    currToEdit.primaryKey ? 
                    $html.find("#isPrimaryKey").prop("checked","checked") : 
                    $("#isPrimaryKey").removeProp("checked");
                    break;
                case "cn.myapps.runtime.dynaform.dts.excelimport.Relation":
                    $setTitle.text("关联线信息");
                    var relationData = {
                        name: currToEdit.name
                    }
                    $html = $(template("editrelation-tmpl", relationData));
                    break;
                default:
                    break;
            }
        }
        window.top.textareaSave=$html;
        window.top.textareaSave.find("input,textarea").on("change", function(){
            if($html.attr("id")=="autoNode"){
                var $name=$(".name");
                var $fieldName=$(".statelabel");
                var $isPrimaryKey=$("#isPrimaryKey");
                var $valueScript=$("#valueScript");
                var $validateRule=$("#validateRule");
                //console.log($valueScript);
                currToEdit.name=$name.val();
                currToEdit.fieldName=$fieldName.val();
                currToEdit.valueScript=$.trim($valueScript.val());
                currToEdit.validateRule=$.trim($validateRule.val());
                currToEdit.primaryKey=$isPrimaryKey.prop("checked"); 
                return;
            }
            var $name=$(".name");
            var $formName=$(".statelabel");
                currToEdit.name=$name.val();
                currToEdit.formName=$formName.val();
            //WorkFlowDesign.Core.savePropWithEditNode();
        }).on("input", function(){
			// WorkFlowDesign.Core.savePropWithEditNode();
        });

        $setContentPanel.html($html);
    }

    // editRelation(editNode){
    //     var diagram = WorkFlowDesign.Cache.diagram;
    //     var $setContentPanel = $(".workflows-setting").find(".edit-content");

    //     //基本信息
    //     var id = editNode.id;
    //     var name = $setContentPanel.find("input.name").val();
    //     var condition = $setContentPanel.find("textarea[name='condition']").val();
    //     var note = editNode.note;
    //     var action = $setContentPanel.find("textarea[name='action']").val();
    //     var validateScript = $setContentPanel.find("textarea[name='validateScript']").val();
    //     var filtercondition = $setContentPanel.find("input[name='filtercondition']").val();
    //     var editMode = $setContentPanel.find("input[name='editMode']:checked").val();
    //     var processDescription = $setContentPanel.find("input[name='processDescription']").val();

    //     diagram.editRelation(editNode, id, name, condition, note, action,
	// 		validateScript, filtercondition, editMode, processDescription);
    // },
    // changeEditContentPanel(dom){
    //     var $this = $(dom);
    //     var name = $this.attr("name");
    //     var value = $this.val();

    //     var $panels = $("div[data-componentName='"+name+"']");

    //     $panels.each(function(){
    //         var dataValue = $(this).data("value");
    //         if(typeof dataValue == "boolean"){
    //             dataValue = dataValue ? "true" : "false";
    //         }
    //         if(dataValue == value && $(this).hasClass("d-none")){
    //             $(this).removeClass("d-none");
    //         }else{
    //             $(this).addClass("d-none");
    //         }
    //     })
    // }
}

