import ReportElement from './ReportElement';
import {Sequence, Archor} from '../../utility';

class Ellipse extends ReportElement {
	constructor() {
		super();
		this.belong = '';
		this.isOpenArchor = false;
		this.lineWidth=1;
		// this.lineStyle="Solid";
		// this.lineColor="#000000";
		// this.lineStyleOption={
		// 	"Solid":true,
		// 	"Dashed":false,
		// 	"Dotted":false,
		// 	"Double":false,
		// }
		this.key="椭圆"
	}
	
	getClassName() {
		return 'ellipse';
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
		// `(${parseInt(this.x)}, ${parseInt(this.printedY)})`
		node.icon = 'glyphicon glyphicon-adjust';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
	}

	/**
	 * @param g
	 */
	paint(g) {
		let that=this;
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		var a=g.checkWH(this.width,this.height);
		this.width=a.w;
		this.height=a.h;
		g.save();	
		g.setColor('#000000');
		g.setLineWidth(0.5);
		g.drawRect(this.x, this.y, this.width, this.height);
		
		const circleX = this.x + this.width / 2;
		const circleY = this.y + this.height / 2;
		const radiusX = this.width / 2;
		const radiusY = this.height / 2;
		

		g.setStyle(this.lineWidth,this.lineStyle,this.lineColor);

		if(this.lineStyle=="Double"){
			g.drawEllipseLine(circleX, circleY, radiusX, radiusY );
			g.drawEllipseLine(circleX, circleY, Math.abs(radiusX-this.lineWidth*2), Math.abs(radiusY-this.lineWidth*2 ));
			g.setColor(this.forecolor);
			g.drawEllipse(circleX, circleY, Math.abs(radiusX-this.lineWidth*2), Math.abs(radiusY-this.lineWidth*2), this.mode, {backcolor: this.backcolor, forecolor: this.forecolor});


		}else{
			g.drawEllipseLine(circleX, circleY, radiusX, radiusY );
			g.setColor(this.forecolor);
			g.drawEllipse(circleX, circleY, Math.abs(radiusX-this.lineWidth), Math.abs(radiusY-this.lineWidth), this.mode, {backcolor: this.backcolor, forecolor: this.forecolor});

		}

		g.setLineStyle();
		if(this.error){
			let img=new Image();
			img.src=this.errorImgSrc;
			img.onload=function(){
				g.drawImage(img,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
	}
	
	toXML() {
		let str = '<ellipse>\n';
		str += super.toXML();
		str +='<graphicElement>\n';


		str +=`<pen lineWidth="${this.lineWidth}.0" `

		str +=`lineStyle="${this.lineStyle}" `
		str +=`lineColor="${this.lineColor}"`
		str +=`/>\n`
		str +=`</graphicElement>\n`
		str += '</ellipse>\n';
		
		return str;
	}
	
	parseXML(xmlNode) {
		let props = {};
		let that = this;
		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'reportElement':
					const reportElement = this.handleReportElement(xmlNode);
					Object.assign(props, reportElement);
					break;
				case 'graphicElement':
					const children=xmlNode.children;
					if(children.length>0){
						that.lineWidth = parseInt(children[0].getAttribute('lineWidth'));
						that.lineStyle = children[0].getAttribute('lineStyle');
						that.lineColor = children[0].getAttribute('lineColor');
					}

					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes()) {	
			for(let i = 0;i < xmlNode.children.length;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}

		this.setProps(props);

		return props;
	}
	
	// showTips(g) {
		// let tips = '';
		// tips += this.text;
		// this.drawTips(g, tips);
	// }
}

export default Ellipse;