export function iscriptString(name){
    if(name == "lineChart"){
        return "(function(){\n" +
            " var option =  {\n" +
            "    title : {\n" +
            "        text: '未来一周气温变化',\n" +
            "        subtext: '纯属虚构'\n" +
            "    },\n" +
            "    tooltip : {\n" +
            "        trigger: 'axis'\n" +
            "    },\n" +
            "    legend: {\n" +
            "        data:['最高气温','最低气温']\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            magicType : {show: true, type: ['line', 'bar']},\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : true,\n" +
            "    xAxis : [\n" +
            "        {\n" +
            "            type : 'category',\n" +
            "            boundaryGap : false,\n" +
            "            data : ['周一','周二','周三','周四','周五','周六','周日']\n" +
            "        }\n" +
            "    ],\n" +
            "    yAxis : [\n" +
            "        {\n" +
            "            type : 'value',\n" +
            "            axisLabel : {\n" +
            "                formatter: '{value} °C'\n" +
            "            }\n" +
            "        }\n" +
            "    ],\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'最高气温',\n" +
            "            type:'line',\n" +
            "            data:[11, 11, 15, 13, 12, 13, 10],\n" +
            "            markPoint : {\n" +
            "                data : [\n" +
            "                    {type : 'max', name: '最大值'},\n" +
            "                    {type : 'min', name: '最小值'}\n" +
            "                ]\n" +
            "            },\n" +
            "            markLine : {\n" +
            "                data : [\n" +
            "                    {type : 'average', name: '平均值'}\n" +
            "                ]\n" +
            "            }\n" +
            "        },\n" +
            "        {\n" +
            "            name:'最低气温',\n" +
            "            type:'line',\n" +
            "            data:[1, -2, 2, 5, 3, 2, 0],\n" +
            "            markPoint : {\n" +
            "                data : [\n" +
            "                    {name : '周最低', value : -2, xAxis: 1, yAxis: -1.5}\n" +
            "                ]\n" +
            "            },\n" +
            "            markLine : {\n" +
            "                data : [\n" +
            "                    {type : 'average', name : '平均值'}\n" +
            "                ]\n" +
            "            }\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            " return option;\n" +
            " })()";
    }
    if(name == "barChart"){
        return "(function(){\n" +
            " var option = {\n" +
            "    title : {\n" +
            "        text: '某地区蒸发量和降水量',\n" +
            "        subtext: '纯属虚构'\n" +
            "    },\n" +
            "    tooltip : {\n" +
            "        trigger: 'axis'\n" +
            "    },\n" +
            "    legend: {\n" +
            "        data:['蒸发量','降水量']\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            magicType : {show: true, type: ['line', 'bar']},\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : true,\n" +
            "    xAxis : [\n" +
            "        {\n" +
            "            type : 'category',\n" +
            "            data : ['1月','2月','3月','4月','5月','6月','7月','8月','9月','10月','11月','12月']\n" +
            "        }\n" +
            "    ],\n" +
            "    yAxis : [\n" +
            "        {\n" +
            "            type : 'value'\n" +
            "        }\n" +
            "    ],\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'蒸发量',\n" +
            "            type:'bar',\n" +
            "            data:[2.0, 4.9, 7.0, 23.2, 25.6, 76.7, 135.6, 162.2, 32.6, 20.0, 6.4, 3.3],\n" +
            "            markPoint : {\n" +
            "                data : [\n" +
            "                    {type : 'max', name: '最大值'},\n" +
            "                    {type : 'min', name: '最小值'}\n" +
            "                ]\n" +
            "            },\n" +
            "            markLine : {\n" +
            "                data : [\n" +
            "                    {type : 'average', name: '平均值'}\n" +
            "                ]\n" +
            "            }\n" +
            "        },\n" +
            "        {\n" +
            "            name:'降水量',\n" +
            "            type:'bar',\n" +
            "            data:[2.6, 5.9, 9.0, 26.4, 28.7, 70.7, 175.6, 182.2, 48.7, 18.8, 6.0, 2.3],\n" +
            "            markPoint : {\n" +
            "                data : [\n" +
            "                    {name : '年最高', value : 182.2, xAxis: 7, yAxis: 183, symbolSize:18},\n" +
            "                    {name : '年最低', value : 2.3, xAxis: 11, yAxis: 3}\n" +
            "                ]\n" +
            "            },\n" +
            "            markLine : {\n" +
            "                data : [\n" +
            "                    {type : 'average', name : '平均值'}\n" +
            "                ]\n" +
            "            }\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            " return option;\n" +
            " })()";
    }
    if(name == "pieChart"){
        return "(function(){\n" +
            " var option =  {\n" +
            "    title : {\n" +
            "        text: '某站点用户访问来源',\n" +
            "        subtext: '纯属虚构',\n" +
            "        x:'center'\n" +
            "    },\n" +
            "    tooltip : {\n" +
            "        trigger: 'item',\n" +
            "        formatter: \"{a} <br/>{b} : {c} ({d}%)\"\n" +
            "    },\n" +
            "    legend: {\n" +
            "        orient : 'vertical',\n" +
            "        x : 'left',\n" +
            "        data:['直接访问','邮件营销','联盟广告','视频广告','搜索引擎']\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            magicType : {\n" +
            "                show: true, \n" +
            "                type: ['pie', 'funnel'],\n" +
            "                option: {\n" +
            "                    funnel: {\n" +
            "                        x: '25%',\n" +
            "                        width: '50%',\n" +
            "                        funnelAlign: 'left',\n" +
            "                        max: 1548\n" +
            "                    }\n" +
            "                }\n" +
            "            },\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : true,\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'访问来源',\n" +
            "            type:'pie',\n" +
            "            radius : '55%',\n" +
            "            center: ['50%', '60%'],\n" +
            "            data:[\n" +
            "                {value:335, name:'直接访问'},\n" +
            "                {value:310, name:'邮件营销'},\n" +
            "                {value:234, name:'联盟广告'},\n" +
            "                {value:135, name:'视频广告'},\n" +
            "                {value:1548, name:'搜索引擎'}\n" +
            "            ]\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            " return option;\n" +
            " })()";
    }
    if(name == "funnelChart"){
        return "(function(){\n" +
            "    var option = {\n" +
            "    title: {\n" +
            "        text: '漏斗图',\n" +
            "        subtext: '纯属虚构'\n" +
            "    },\n" +
            "    tooltip: {\n" +
            "        trigger: 'item',\n" +
            "        formatter: \"{a} <br/>{b} : {c}%\"\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        feature: {\n" +
            "            dataView: {readOnly: false},\n" +
            "            restore: {},\n" +
            "            saveAsImage: {}\n" +
            "        }\n" +
            "    },\n" +
            "    legend: {\n" +
            "        data: ['展现','点击','访问','咨询','订单']\n" +
            "    },\n" +
            "    calculable: true,\n" +
            "    series: [\n" +
            "        {\n" +
            "            name:'漏斗图',\n" +
            "            type:'funnel',\n" +
            "            left: '10%',\n" +
            "            top: 60,\n" +
            "            //x2: 80,\n" +
            "            bottom: 60,\n" +
            "            width: '80%',\n" +
            "            // height: {totalHeight} - y - y2,\n" +
            "            min: 0,\n" +
            "            max: 100,\n" +
            "            minSize: '0%',\n" +
            "            maxSize: '100%',\n" +
            "            sort: 'descending',\n" +
            "            gap: 2,\n" +
            "            label: {\n" +
            "                show: true,\n" +
            "                position: 'inside'\n" +
            "            },\n" +
            "            labelLine: {\n" +
            "                length: 10,\n" +
            "                lineStyle: {\n" +
            "                    width: 1,\n" +
            "                    type: 'solid'\n" +
            "                }\n" +
            "            },\n" +
            "            itemStyle: {\n" +
            "                borderColor: '#fff',\n" +
            "                borderWidth: 1\n" +
            "            },\n" +
            "            emphasis: {\n" +
            "                label: {\n" +
            "                    fontSize: 20\n" +
            "                }\n" +
            "            },\n" +
            "            data: [\n" +
            "                {value: 60, name: '访问'},\n" +
            "                {value: 40, name: '咨询'},\n" +
            "                {value: 20, name: '订单'},\n" +
            "                {value: 80, name: '点击'},\n" +
            "                {value: 100, name: '展现'}\n" +
            "            ]\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            "    return option;\n" +
            "})()";
    }
    if(name == "stackedBarChart"){
        return "(function(){\n" +
            "\tvar option = {\n" +
            "    angleAxis: {\n" +
            "    },\n" +
            "    radiusAxis: {\n" +
            "        type: 'category',\n" +
            "        data: ['周一', '周二', '周三', '周四'],\n" +
            "        z: 10\n" +
            "    },\n" +
            "    polar: {\n" +
            "    },\n" +
            "    series: [{\n" +
            "        type: 'bar',\n" +
            "        data: [1, 2, 3, 4],\n" +
            "        coordinateSystem: 'polar',\n" +
            "        name: 'A',\n" +
            "        stack: 'a'\n" +
            "    }, {\n" +
            "        type: 'bar',\n" +
            "        data: [2, 4, 6, 8],\n" +
            "        coordinateSystem: 'polar',\n" +
            "        name: 'B',\n" +
            "        stack: 'a'\n" +
            "    }, {\n" +
            "        type: 'bar',\n" +
            "        data: [1, 2, 3, 4],\n" +
            "        coordinateSystem: 'polar',\n" +
            "        name: 'C',\n" +
            "        stack: 'a'\n" +
            "    }],\n" +
            "    legend: {\n" +
            "        show: true,\n" +
            "        data: ['A', 'B', 'C']\n" +
            "    }\n" +
            "};\n" +
            "return option;\n" +
            "\t\n" +
            "})()";
    }
    if(name == "stepChart"){
        return "(function(){\n" +
            "\tvar option = {\n" +
            "    title: {\n" +
            "        text: '阶梯瀑布图',\n" +
            "        subtext: 'From ExcelHome',\n" +
            "    },\n" +
            "    tooltip : {\n" +
            "        trigger: 'axis',\n" +
            "        axisPointer : {            // 坐标轴指示器，坐标轴触发有效\n" +
            "            type : 'shadow'        // 默认为直线，可选为：'line' | 'shadow'\n" +
            "        },\n" +
            "        formatter: function (params) {\n" +
            "            var tar;\n" +
            "            if (params[1].value != '-') {\n" +
            "                tar = params[1];\n" +
            "            }\n" +
            "            else {\n" +
            "                tar = params[0];\n" +
            "            }\n" +
            "            return tar.name + '<br/>' + tar.seriesName + ' : ' + tar.value;\n" +
            "        }\n" +
            "    },\n" +
            "    legend: {\n" +
            "        data:['支出','收入']\n" +
            "    },\n" +
            "    grid: {\n" +
            "        left: '3%',\n" +
            "        right: '4%',\n" +
            "        bottom: '3%',\n" +
            "        containLabel: true\n" +
            "    },\n" +
            "    xAxis: {\n" +
            "        type : 'category',\n" +
            "        splitLine: {show:false},\n" +
            "        data :  function (){\n" +
            "            var list = [];\n" +
            "            for (var i = 1; i <= 11; i++) {\n" +
            "                list.push('11月' + i + '日');\n" +
            "            }\n" +
            "            return list;\n" +
            "        }()\n" +
            "    },\n" +
            "    yAxis: {\n" +
            "        type : 'value'\n" +
            "    },\n" +
            "    series: [\n" +
            "        {\n" +
            "            name: '辅助',\n" +
            "            type: 'bar',\n" +
            "            stack: '总量',\n" +
            "            itemStyle: {\n" +
            "                normal: {\n" +
            "                    barBorderColor: 'rgba(0,0,0,0)',\n" +
            "                    color: 'rgba(0,0,0,0)'\n" +
            "                },\n" +
            "                emphasis: {\n" +
            "                    barBorderColor: 'rgba(0,0,0,0)',\n" +
            "                    color: 'rgba(0,0,0,0)'\n" +
            "                }\n" +
            "            },\n" +
            "            data: [0, 900, 1245, 1530, 1376, 1376, 1511, 1689, 1856, 1495, 1292]\n" +
            "        },\n" +
            "        {\n" +
            "            name: '收入',\n" +
            "            type: 'bar',\n" +
            "            stack: '总量',\n" +
            "            label: {\n" +
            "                normal: {\n" +
            "                    show: true,\n" +
            "                    position: 'top'\n" +
            "                }\n" +
            "            },\n" +
            "            data: [900, 345, 393, '-', '-', 135, 178, 286, '-', '-', '-']\n" +
            "        },\n" +
            "        {\n" +
            "            name: '支出',\n" +
            "            type: 'bar',\n" +
            "            stack: '总量',\n" +
            "            label: {\n" +
            "                normal: {\n" +
            "                    show: true,\n" +
            "                    position: 'bottom'\n" +
            "                }\n" +
            "            },\n" +
            "            data: ['-', '-', '-', 108, 154, '-', '-', '-', 119, 361, 203]\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            "return option;\t\n" +
            "})()";
    }
    //堆积面积图
    if(name == "stackedAreaChart"){
        return "(function(){\n" +
            "\tvar option = {\n" +
            "    tooltip : {\n" +
            "        trigger: 'axis'\n" +
            "    },\n" +
            "    legend: {\n" +
            "        data:['邮件营销','联盟广告','视频广告','直接访问','搜索引擎']\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            magicType : {show: true, type: ['line', 'bar', 'stack', 'tiled']},\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : true,\n" +
            "    xAxis : [\n" +
            "        {\n" +
            "            type : 'category',\n" +
            "            boundaryGap : false,\n" +
            "            data : ['周一','周二','周三','周四','周五','周六','周日']\n" +
            "        }\n" +
            "    ],\n" +
            "    yAxis : [\n" +
            "        {\n" +
            "            type : 'value'\n" +
            "        }\n" +
            "    ],\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'邮件营销',\n" +
            "            type:'line',\n" +
            "            stack: '总量',\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[120, 132, 101, 134, 90, 230, 210]\n" +
            "        },\n" +
            "        {\n" +
            "            name:'联盟广告',\n" +
            "            type:'line',\n" +
            "            stack: '总量',\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[220, 182, 191, 234, 290, 330, 310]\n" +
            "        },\n" +
            "        {\n" +
            "            name:'视频广告',\n" +
            "            type:'line',\n" +
            "            stack: '总量',\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[150, 232, 201, 154, 190, 330, 410]\n" +
            "        },\n" +
            "        {\n" +
            "            name:'直接访问',\n" +
            "            type:'line',\n" +
            "            stack: '总量',\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[320, 332, 301, 334, 390, 330, 320]\n" +
            "        },\n" +
            "        {\n" +
            "            name:'搜索引擎',\n" +
            "            type:'line',\n" +
            "            stack: '总量',\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[820, 932, 901, 934, 1290, 1330, 1320]\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            "return option;\t\n" +
            "})()";
    }
    //标准面积图
    if(name == "basicAreaChart"){
        return "(function(){\n" +
            "\tvar option = {\n" +
            "    title : {\n" +
            "        text: '某楼盘销售情况',\n" +
            "        subtext: '纯属虚构'\n" +
            "    },\n" +
            "    tooltip : {\n" +
            "        trigger: 'axis'\n" +
            "    },\n" +
            "    legend: {\n" +
            "        data:['意向','预购','成交']\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            magicType : {show: true, type: ['line', 'bar', 'stack', 'tiled']},\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : true,\n" +
            "    xAxis : [\n" +
            "        {\n" +
            "            type : 'category',\n" +
            "            boundaryGap : false,\n" +
            "            data : ['周一','周二','周三','周四','周五','周六','周日']\n" +
            "        }\n" +
            "    ],\n" +
            "    yAxis : [\n" +
            "        {\n" +
            "            type : 'value'\n" +
            "        }\n" +
            "    ],\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'成交',\n" +
            "            type:'line',\n" +
            "            smooth:true,\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[10, 12, 21, 54, 260, 830, 710]\n" +
            "        },\n" +
            "        {\n" +
            "            name:'预购',\n" +
            "            type:'line',\n" +
            "            smooth:true,\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[30, 182, 434, 791, 390, 30, 10]\n" +
            "        },\n" +
            "        {\n" +
            "            name:'意向',\n" +
            "            type:'line',\n" +
            "            smooth:true,\n" +
            "            itemStyle: {normal: {areaStyle: {type: 'default'}}},\n" +
            "            data:[1320, 1132, 601, 234, 120, 90, 20]\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            "return option;\t\n" +
            "})()";
    }
    //环形图
    if(name == "ringChart"){
        return "(function(){\n" +
            "\tvar option = {\n" +
            "    tooltip : {\n" +
            "        trigger: 'item',\n" +
            "        formatter: \"{a} <br/>{b} : {c} ({d}%)\"\n" +
            "    },\n" +
            "    legend: {\n" +
            "        orient : 'vertical',\n" +
            "        x : 'left',\n" +
            "        data:['直接访问','邮件营销','联盟广告','视频广告','搜索引擎']\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            magicType : {\n" +
            "                show: true, \n" +
            "                type: ['pie', 'funnel'],\n" +
            "                option: {\n" +
            "                    funnel: {\n" +
            "                        x: '25%',\n" +
            "                        width: '50%',\n" +
            "                        funnelAlign: 'center',\n" +
            "                        max: 1548\n" +
            "                    }\n" +
            "                }\n" +
            "            },\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : true,\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'访问来源',\n" +
            "            type:'pie',\n" +
            "            radius : ['50%', '70%'],\n" +
            "            itemStyle : {\n" +
            "                normal : {\n" +
            "                    label : {\n" +
            "                        show : false\n" +
            "                    },\n" +
            "                    labelLine : {\n" +
            "                        show : false\n" +
            "                    }\n" +
            "                },\n" +
            "                emphasis : {\n" +
            "                    label : {\n" +
            "                        show : true,\n" +
            "                        position : 'center',\n" +
            "                        textStyle : {\n" +
            "                            fontSize : '30',\n" +
            "                            fontWeight : 'bold'\n" +
            "                        }\n" +
            "                    }\n" +
            "                }\n" +
            "            },\n" +
            "            data:[\n" +
            "                {value:335, name:'直接访问'},\n" +
            "                {value:310, name:'邮件营销'},\n" +
            "                {value:234, name:'联盟广告'},\n" +
            "                {value:135, name:'视频广告'},\n" +
            "                {value:1548, name:'搜索引擎'}\n" +
            "            ]\n" +
            "        }\n" +
            "    ]\n" +
            "};\n" +
            "return option;\t\n" +
            "})()";
    }
    //矩形图
    if(name == "rectangleChart"){
        return "(function(){\n" +
            "\tvar option = {\n" +
            "    title : {\n" +
            "        text: '手机占有率',\n" +
            "        subtext: '虚构数据'\n" +
            "    },\n" +
            "    tooltip : {\n" +
            "        trigger: 'item',\n" +
            "        formatter: \"{b}: {c}\"\n" +
            "    },\n" +
            "    toolbox: {\n" +
            "        show : true,\n" +
            "        feature : {\n" +
            "            mark : {show: true},\n" +
            "            dataView : {show: true, readOnly: false},\n" +
            "            restore : {show: true},\n" +
            "            saveAsImage : {show: true}\n" +
            "        }\n" +
            "    },\n" +
            "    calculable : false,\n" +
            "    series : [\n" +
            "        {\n" +
            "            name:'矩形图',\n" +
            "            type:'treemap',\n" +
            "            itemStyle: {\n" +
            "                normal: {\n" +
            "                    label: {\n" +
            "                        show: true,\n" +
            "                        formatter: \"{b}\"\n" +
            "                    },\n" +
            "                    borderWidth: 1\n" +
            "                },\n" +
            "                emphasis: {\n" +
            "                    label: {\n" +
            "                        show: true\n" +
            "                    }\n" +
            "                }\n" +
            "            },\n" +
            "            data:[\n" +
            "                {\n" +
            "                    name: '三星',\n" +
            "                    value: 6\n" +
            "                },\n" +
            "                {\n" +
            "                    name: '小米',\n" +
            "                    value: 4\n" +
            "                },\n" +
            "                {\n" +
            "                    name: '苹果',\n" +
            "                    value: 4\n" +
            "                },\n" +
            "                {\n" +
            "                    name: '华为',\n" +
            "                    value: 2\n" +
            "                },\n" +
            "                {\n" +
            "                    name: '联想',\n" +
            "                    value: 2\n" +
            "                },\n" +
            "                {\n" +
            "                    name: '魅族',\n" +
            "                    value: 1\n" +
            "                },\n" +
            "                {\n" +
            "                    name: '中兴',\n" +
            "                    value: 1\n" +
            "                }\n" +
            "            ]\n" +
            "        }\n" +
            "    ]\n" +
            "};              \n" +
            "return option;\t\n" +
            "})()";
    }
}