import TextElement from './TextElement';
import {Sequence, Archor} from '../../utility';
import TextField from "./TextField";

class variable extends TextElement {
	constructor() {
		super();
		this.text = variable.DEF_TEXT; //当前元素默认文本
		this.belong = '';
		this.isOpenArchor = false;
		this.field=null;
		this.option=null;
		this.key="";
		//this.name=name;
	}
	
	getClassName() {
		return 'variable';
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
		node.icon = 'glyphicon glyphicon-text-width';
		node.uuid = this.getProp('id');	
		node.instance = this;
		node.field=this.field;
		node.option=this.option;
		return node;
	}

	
	/**
	 * @param g
	 */
	paint(g) {
		let that=this;
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		if(this.paragraph.lineSpacing=="1.5"){
			this.paragraph.lineSpacingSize=1.5;
		}else if(this.paragraph.lineSpacing=="Single"){
			this.paragraph.lineSpacingSize=1;
		}else if(this.paragraph.lineSpacing=="Double"){
			this.paragraph.lineSpacingSize=2;
		}
		g.save();	
		g.setColor(this.backcolor);
		g.setLineWidth(0.5);
		
		if(this.mode == 'Opaque') {
			g.fillRect(this.x, this.y, this.width, this.height);
		} else {
			g.drawRect(this.x, this.y, this.width, this.height);
		}
		
		let tx = 0;
		let ty = 0;
		let font = '';

		if(this.font) {
			let italic = this.font.isItalic ? 'italic ' : '';
			let bold = this.font.isBold ? 'bold ' : '';
			font += italic;
			font += bold;
			font += this.font.size + 'px ';
			font += this.font.fontName + ' ';
		}
		
		g.setColor(this.forecolor);
		g.setFont(font);

		let textLen = g.getTextWidth(this.expression);
		let multiple = Math.ceil(textLen / this.width);//文字真的行数
		let realMultiple = parseInt(this.height / (parseInt(this.font.size)+this.paragraph.lineSpacingSize*parseInt(this.font.size)/2));//此时的高度可以放多少行
		if(multiple<realMultiple){
			realMultiple=multiple;
		}

		let spare=0;	
		if(this.textAlignment == 'Left') {
			g.textAlign('left');
			tx = this.x;
		} else if(this.textAlignment == 'Center') {
			g.textAlign('center');
			tx = (this.x + this.width) / 2 + this.x / 2;
		} else {
			g.textAlign('right');
			tx = this.x + this.width;	
		}
			
		if(this.verticalAlignment == 'Top') {
			g.textBaseLine('top');
			ty = this.y;
		} else if(this.verticalAlignment == 'Bottom') {
			g.textBaseLine('bottom');

			if(textLen > this.width) {
				ty = this.y + this.height - (parseInt(this.font.size)+(this.paragraph.lineSpacingSize*parseInt(this.font.size))/2) * (realMultiple - 1);
			} else {
				ty = this.y + this.height;
			}
		} else {
			g.textBaseLine('middle');

			if(textLen > this.width) {
				
				if(((parseInt(this.font.size)+this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)*multiple)>this.height){
					//如果当前内容的总高度大于组件高度，所以只能显示当前组件高度可以显示的文字，这时还得计算显示完可以显示的内容之后还剩下的高度要均分到顶部和底部
					spare=(this.height-(parseInt(this.font.size)+this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)*realMultiple)/2;
					ty = this.y + (this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)/2 + parseInt(this.font.size)/2 + spare
				}else{
					ty = this.y + (this.paragraph.lineSpacingSize * parseInt(this.font.size)/2)/2 + parseInt(this.font.size)/2 + (this.height - (parseInt(this.font.size) + this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)*multiple)/2

				}
			} else {
				ty = (this.y + this.height) / 2 + this.y / 2;
			}
		}

		g.drawTextWithRow(this.expression, tx, ty, this.width,this.height, parseInt(this.font.size),this.paragraph.lineSpacingSize,this.paragraph.firstLineIndent,this.paragraph.leftIndent,this.paragraph.rightIndent,spare);
		if(this.error){
			let img=new Image();
			img.src=this.errorImgSrc;
			img.onload=function(){
				g.drawImage(img,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
	}
	
	toXML() {
// 		let str=`<textField`
// //		str += `<variable  name="${this.text}" class="java.lang.String" calculation="${this.option}" `;
// //		str += `field="${this.field}" `
// //		str += `option="${this.option}" `
// 		str += `>\n`;
// 		str += super.toXML2();
//
// 		str += `<textFieldExpression><![CDATA[${this.text}]]></textFieldExpression>\n`;
// //		str += `<variableExpression><![CDATA[$F{${this.field}}]]></variableExpression>\n`
// //		str += `</variable>\n`;
// 		str += `</textField>\n`;
//

		let str = '<textField ';
		str += `isBlankWhenNull = "${this.isBlankWhenNull}" `;
		str += `isStretchWithOverflow = "${this.isStretchWithOverflow}" `;
		if(this.pattern) {
			str += `pattern = "${this.pattern}"`;
		}

		if(this.evaluationTime != variable.DEF_EVALUATION_TIME) {
			str += `evaluationTime = "${this.evaluationTime}"`;
		}

		str += '>\n';
		str += super.toXML2();
		str +="<box>\n"
		str +="<pen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\"/>\n"
		str +="<topPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\"/>\n"
		str +="<leftPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\"/>\n"
		str +="<bottomPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\"/>\n"
		str +="<rightPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\"/>\n"
		str +="</box>\n"
		str += super.toXML3();
		str += `<textFieldExpression><![CDATA[${this.text}]]></textFieldExpression>\n`;

		// if(this.patternExpression != '') {
		// 	str+= `<patternExpression><![CDATA[${this.patternExpression}]]></patternExpression>`;
		// }

		str += '</textField>\n';

		return str;
	}
	
	parseXML(xmlNode) {
		//console.log(xmlNode);
		let props = {};
		props.text=xmlNode.getAttribute('name');
		props.option=xmlNode.getAttribute('calculation');
		
		const traversalNode = (xmlNode) => {
			const { tagName } = xmlNode;
			switch (tagName) {
//				case 'reportElement':
//					const reportElement = this.handleReportElement(xmlNode);
//					Object.assign(props, reportElement);
//					break;
//				case 'variableExpression':
//					//console.log(xmlNode.childNodes[0].nodeValue);
//					const text1 = this.replaceText(xmlNode.childNodes[0].nodeValue);
//					text1.replace(/\$F\{/, '').replace(/\}/, '');
//					props.field="$V{"+text1+"}"
//					
//					//console.log(props.text)
//					break;
//				case 'textElement':
//					const textElement = this.handleTextElement(xmlNode);
//					Object.assign(props, textElement);
				case 'text':
					console.log(xmlNode);
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes()) {
			for(let i = 0, len = xmlNode.children.length;i < len;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}
		//console.log(props)
		this.setProps(props);

		return props;
	}
	
	// showTips(g) {
		// let tips = '';
		// tips += this.text;
		// this.drawTips(g, tips);
	// }
}

variable.DEF_TEXT = '$V(variable)';
variable.DEF_EVALUATION_TIME = 'Now';
export default variable;