import instance from './ajax';

/**
 * 获取角色列表
 */
export const getRoles = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/roles?name=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage,
    method: 'get'
  })
};

/**
 * 删除角色
 */
export const deleteRoles = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/roles",
    method: "delete",
    data: params,
  })
};

/**
 * 创建角色
 */
export const createRoles = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/roles",
    method: "post",
    data: params,
  })
};

/**
 * 更新角色
 */
export const updateRoles = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/roles/" + params.id,
    method: "put",
    data: params,
  })
};

/**
 * **获取菜单列表（根据上级）
 * get
 * /designtime/applications/{applicationId}/menus?isMobile={isMobile}&parentId={parentId}
 */
export const getMenuList = (param) => {
  return instance({
    url: contextPath + `/designtime/applications/${param.applicationId}/menus?isMobile=${param.isMobile}&parentId=${param.parentId}`,
    method: 'get'
  })
};

/**
 * *批量更新授权配置**
 * post
 *  /designtime/applications/{appcationId}/permissions
 */
export const updatePermissions = (param) => {
  return instance({
    url:contextPath + `/designtime/applications/${param.applicationId}/permissions`,
    method: 'post',
    data: param.data
  })
};

/**
 * *查询所属模块的表单或视图配置资源列表****
 * get
 * /designtime/applications/{applicationId}/modules/{moduleId}/permissions?roleId={roleId}
 */
export const getModuleResource = (param) => {
  return instance({
    url: contextPath + `/designtime/applications/${param.applicationId}/modules/${param.moduleId}/permissions?roleId=${param.roleId}`,
    method: 'get'
  })
};

/**
 * **查询pc菜单配置资源列表(根据上级)**
 */
export const getPcResource = (param) => {
  return instance({
    url: contextPath + `/designtime/applications/${param.applicationId}/permissions/pc?parentId=${param.parentId}&roleId=${param.roleId}`,
    method: 'get'
  })
};

/**
 * 查询mobile菜单配置资源列表(根据上级)
 */
export const getMobileResource = (param) => {
  return instance({
    url: contextPath + `/designtime/applications/${param.applicationId}/permissions/mobile?parentId=${param.parentId}&roleId=${param.roleId}`,
    method: 'get'
  })
};

/**
 * **新建菜单
 * POST
 * /designtime/applications/{applicationId}/menus
 */
export const newMenu = (applicationId, isMobile, content) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/menus?isMobile=${isMobile}`,
    method: 'post',
    data: content
  })
};

/**
 * **删除菜单
 * DELETE
 * /designtime/applications/menus
 */
export const delMenu = (data) => {
  return instance({
    url: contextPath + `/designtime/applications/menus`,
    method: 'delete',
    data
  })
};

/**
 * **获取所有菜单
 * get
 * /designtime/applications/{applicationId}/menu/getAllMenus?currentMenuId={currentMenuId}&type={type}&showType={showType}
 */
export const getAllMenu = ({ applicationId, currentMenuId = "", type = "", showType }, { onSucess, onError }) => {
  instance
    .get(contextPath + `/designtime/applications/${applicationId}/menu/getAllMenus?currentMenuId=${currentMenuId}&type=${type}&showType=${showType}`)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取表单列表
 */
export const getFormList = ({ moduleId = "", searchword = "", type = 1, pageNo = 1, linesPerPage = 10 }, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/" + moduleId + "/forms?searchword=" + searchword + "&type=" + type + "&pageNo=" + pageNo + "&linesPerPage=" + linesPerPage)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * **获取菜单详情
 * get
 * /designtime/applications/menus/{menuId}
 */
export const getMenuDetail = (menuId, { onSucess, onError }) => {
  instance
    .get(contextPath + `/designtime/applications/menus/${menuId}`)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * **更新菜单
 * PUT
 * /designtime/applications/{applicationId}/menus/{menuId}
 */
export const putMenuDetail = ({ applicationId, menuId, data }) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/menus/${menuId}`,
    method: 'put',
    data
  })
};

/**
 * **复制菜单
 * POST
 * /designtime/applications/{applicationId}/menus/copy
 */
export const copyMenu = ({ applicationId = "", destid, isMobile, data }) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/menus/copy?destid=${destid}&isMobile=${isMobile}`,
    method: 'post',
    data
  })
};

/**
 * **获取图标集合
 * get
 * /designtime/applications/icons
 */
export const getAllIcon = (path, { onSucess, onError }) => {
  instance
    .get(contextPath + `/designtime/applications/icons?path=${path}`)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * **删除自定义图标
 * get
 * /designtime/applications/icon
 */
export const deleteIcon = ({ data }, { onSucess, onError }) => {
  instance
    .delete(contextPath + `/designtime/applications/icon`, { data: data })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * **返回图片路径
 * get
 * /designtime/applications/icons
 */
export const getLogoUrl = (url) => {
  return `${contextPath.replace(/\/api/,"")}` + url;
};

/**
 * **返回图片文件夹路径
 * get
 * /designtime/applications/icons
 */
export const getLogoPrefixUrl = (url) => {
  return `${contextPath.replace(/\/api/,"")}` + '/uploads/lib/icon' + url;
};

/**
 * **获取widget列表
 */
export const getWidgets = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/widgets?name=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage,
    method: 'get'
  })
};

/**
 * 删除widget
 */
export const deleteWidgets = (multipleSelectionId) => {
  return instance({
    url: contextPath + "/designtime/applications/widgets",
    method: "delete",
    data: multipleSelectionId,
  })
};

/**
 * 新建保存widget
 */

export const saveWidgets = (applicationId, data) => {
  return instance({
    url: contextPath + "/designtime/applications/" + applicationId + "/widgets",
    method: "post",
    data: data,
  })
};

/**
 * 更新保存widget
 */

export const updateWidgets = (data) => {
  return instance({
    url: contextPath + `/designtime/applications/widgets`,
    method: "put",
    data: data,
  })
};

/**
 * 获取widget详情
 */

export const getWidgetsData = (widgetId) => {
  return instance({
    url: contextPath + "/designtime/applications/widgets/" + widgetId,
    method: "get",
  })
};

/**
 * **获取任务列表
 */
export const getTasks = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/tasks?searchword=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage,
    method: 'get'
  })
};

/**
 * 删除任务
 */
export const deleteTasks = (multipleSelectionId, params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/tasks",
    method: "delete",
    data: multipleSelectionId,
  })
};

/**
 * 创建任务
 */
export const createTasks = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/tasks?rDate=" + params.rDate + "&rTime=" + params.rTime,
    method: "post",
    data: params,
  })
};

/**
 * 更新任务
 */
export const updateTasks = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/tasks",
    method: "put",
    data: params,
  })
};

/**
 * 开始任务
 */
export const startTask = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/task/start?rDate=" + params.rDate + "&rTime=" + params.rTime + "&id=" + params.id,
    method: "put",
  })
};

/**
 * 停止任务
 */
export const stopTask = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/task/stop?id=" + params.id,
    method: "put",
  })
};

/**
 * **获取状态标签列表
 */
export const getStateLabels = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/statelabels?searchword=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage,
    method: 'get'
  })
};
/**
 * **获取状态标签详情
 */
export const getStateLabelDetail = (stateLabelId) => {
  return instance({
    url: contextPath + `/designtime/applications/statelabels/${stateLabelId}`,
    method: 'get'
  })
};

/**
 * 创建状态标签
 */
export const createStatuslabel = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/statelabels",
    method: "post",
    data: params,
  })
};

/**
 * 更新状态标签
 */
export const updateStatuslabel = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/statelabels",
    method: "put",
    data: params,
  })
};

/**
 * 删除状态标签
 */
export const deleteStatuslabel = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/statelabels",
    method: "delete",
    data: params,
  })
};
/**
 * 获取widget作用视图
 */
export const getViewsModuleList = (moduleId, params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/" + moduleId + "/views?searchword=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};
