/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import com.bcxin.risk.common.dao.DictDao;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.mapper.JsonMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDictUtil {
    @Resource
    private DictDao dictDao;
    private Map<String, Collection<Dict>> CACHE_KEY_DICT = Maps.newHashMap();

    public String getDictLabel(String value, String type, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)value)) {
            Collection<Dict> list = this.dictMap().get(type.toUpperCase());
            for (Dict dict : list) {
                if (!value.equals(dict.getValue())) continue;
                return dict.getLabel();
            }
        }
        return defaultValue;
    }

    public String getDictValue(String label, String type, String defaultLabel) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)label)) {
            Collection<Dict> list = this.dictMap().get(type.toUpperCase());
            for (Dict dict : list) {
                if (!label.equals(dict.getLabel())) continue;
                return dict.getValue();
            }
        }
        return defaultLabel;
    }

    public Collection<Dict> getDictList(String type) {
        return this.dictMap().get(type.toUpperCase());
    }

    private Map<String, Collection<Dict>> dictMap() {
        if (MapUtil.isNotEmpty(this.CACHE_KEY_DICT)) {
            return this.CACHE_KEY_DICT;
        }
        List dictList = this.dictDao.selectDictList();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Dict dict : dictList) {
            map.put((Object)dict.getType().toUpperCase(), (Object)dict);
        }
        this.CACHE_KEY_DICT = map.asMap();
        return this.CACHE_KEY_DICT;
    }

    public String getDictListJson(String type) {
        return JsonMapper.toJsonString(this.getDictList(type.toUpperCase()));
    }
}

