/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JSONUtil {
    public static String objectToJson(Object object) {
        StringBuilder json = new StringBuilder();
        if (object == null) {
            json.append("\"\"");
        } else if (object instanceof String || object instanceof Integer || object instanceof Double) {
            json.append("\"").append(object.toString()).append("\"");
        } else {
            json.append(JSONUtil.beanToJson(object));
        }
        return json.toString();
    }

    public static String beanToJson(Object bean) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                try {
                    String name = JSONUtil.objectToJson(props[i].getName());
                    String value = JSONUtil.objectToJson(props[i].getReadMethod().invoke(bean, new Object[0]));
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String beanToJsonByName(String[] names, String[] values) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        if (values != null && names.length == values.length) {
            for (int i = 0; i < values.length; ++i) {
                try {
                    String name = JSONUtil.objectToJson(names[i]);
                    String value = JSONUtil.objectToJson(values[i]);
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String getBackJson(String resultCode, String message) {
        if (StringUtil.isEmpty((String)resultCode)) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{\"code\":");
        json.append(resultCode);
        json.append(",\"message\":\"");
        json.append(message);
        json.append("\"}");
        return json.toString();
    }

    public static String getBackObjJson(String resultCode, String message) {
        if (StringUtil.isEmpty((String)resultCode)) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{\"code\":");
        json.append(resultCode);
        json.append(",\"object\":");
        json.append(message);
        json.append("}");
        return json.toString();
    }

    public static String getBackObjJson(String[] names, String[] values, List<Integer> atList) {
        if (names == null || names.length != values.length) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{");
        for (int i = 0; i < names.length; ++i) {
            if (i == 0) {
                json.append("\"");
            } else {
                json.append(",\"");
            }
            json.append(names[i]);
            json.append("\":");
            if (atList.contains(i)) {
                json.append(values[i]);
                continue;
            }
            json.append("\"");
            json.append(values[i]);
            json.append("\"");
        }
        json.append("}");
        return json.toString();
    }

    public static String getBackMultiObjJson(String[] names, String[] values) {
        if (names == null || names.length != values.length) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{");
        for (int i = 0; i < names.length; ++i) {
            if (i != 0) {
                json.append(",");
            }
            json.append("\"" + names[i] + "\":");
            if (StringUtil.isEmpty((String)values[i])) {
                json.append("[]");
                continue;
            }
            json.append(values[i]);
        }
        json.append("}");
        return json.toString();
    }

    public static String listToJsonByName(String[] names, List<String[]> list) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list != null && list.size() > 0) {
            for (String[] obj : list) {
                json.append(JSONUtil.beanToJsonByName(names, obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String listToJson(List<?> list) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                json.append(JSONUtil.objectToJson(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (JSONObject json2 : (JSONArray)v) {
                    list.add(JSONUtil.parseJSON2Map(json2.toString()));
                }
                map.put(k.toString(), list);
                continue;
            }
            map.put(k.toString(), v);
        }
        return map;
    }

    public static class User {
        private String name = "";
        private String sex = "";
        private String birthdat;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSex() {
            return this.sex;
        }

        public void setSex(String sex) {
            this.sex = sex;
        }

        public String getBirthdat() {
            return this.birthdat;
        }

        public void setBirthdat(String birthdat) {
            this.birthdat = birthdat;
        }
    }
}

