package com.bcxin.risk.log;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;

import java.io.Serializable;

/**
 * 审计操作日志
 * 需根据系统配置是否记录
 */
@Data
@TableName("log_audit")
public class AuditLog extends Model<AuditLog> {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 流水号
     */
    private String Num_ID;

    /**
     * 用户标识
     */
    private String User_ID;

    /**
     * 单位名称
     */
    private String Organization;

    /**
     * 用户名
     */
    private String User_name;

    /**
     * 终端标识
     */
    private String Terminal_ID;

    /**
     * 操作名称
     */
    private String Operate_Name;

    /**
     * 操作类型
     */
    private int Operate_Type;

    /**
     * 操作时间
     */
    private String Operate_Time;

    /**
     * 操作条件
     */
    private String Operate_Condition;

    /**
     * 操作结果
     */
    private String Operate_Result;

    @Override
    public Serializable pkVal() {
        return this.id;
    }
}
