package com.bcxin.hb.hbzw;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 办结信息表
 * @author wangjianjun
 * @date 2020/8/17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PreTransact extends Model<PreTransact> {
    /**
     * 办件编号
     */
    private String PROJID;

    /**
     * 版本号
     */
    private Integer DATAVERSION;

    /**
     * 办理人员姓名
     */
    private String TRANSACT_USER;

    /**
     * 办结日期
     */
    private Date TRANSACT_TIME;

    /**
     * 办理结果
     */
    private String HANDLESTART;

    /**
     * 办理结果描述
     */
    private String TRANSACT_DESCRIBE;

    /**
     * 办理结论
     */
    private String TRANSACT_RESULT;

    /**
     * 结果证照编号
     */
    private String RESULT_CODE;

    /**
     * 备注
     */
    private String REMARK;

    /**
     * 所属系统
     */
    private String BELONGSYSTEM;

    /**
     * 备用字段
     */
    private String EXTEND;

    /**
     * 数据产生时间
     */
    private Date CREATE_TIME;

    private String SYNC_STATUS;

    /**
     * 办件结果电子文书
     */
    private String ELECTRONIC_RECORDS;

    /**
     * 结果时效
     */
    private String RESULTS_TIME;

    /**
     * 办结人所属部门名称
     */
    private String HANDER_DEPTNAME;

    /**
     * 办结人所属部门编码
     */
    private String HANDER_DEPTID;

    /**
     * 办结人所属部门的所在行政区划编码
     */
    private String AREACODE;

    /**
     * 业务数据交换时间戳
     */
    private Date JH_SJC_DXP;

    /**
     * 业务数据状态
     */
    private String JH_SJZT;

    /**
     * 业务数据上传机构标识
     */
    private String JH_SCJG;

    /**
     * 业务数据上传机构名称
     */
    private String JH_SCJGMC;

    /**
     * 业务数据目标机构标识
     */
    private String JH_MBJG;

    /**
     * 1推送到一窗大厅，0推送到厅局
     */
    private String JH_YCBJ;

    @Override
    public Serializable pkVal() {
        return null;
    }
}