package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.RoleDao;
import com.bcxin.risk.user.domain.Role;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository("roleDao")
@SuppressWarnings("unchecked")
public class RoleDaoImpl extends DaoImpl<Role> implements RoleDao {


    @Override
    public List<Role> findRoleByOrgType(String orgType,String serviceOrgType, String active ,Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if(StringUtil.isNotEmpty(orgType)){
            criterionList.add(Restrictions.eq("orgType",orgType));
        }
        if(StringUtil.isNotEmpty(active)){
            criterionList.add(Restrictions.eq("active",active));
        }
        if(StringUtil.isNotEmpty(serviceOrgType)){
            criterionList.add(Restrictions.eq("serviceOrgType",serviceOrgType));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }else{
           return selectPage(criterionList,page);
        }
    }

    @Override
    public Role findRoleByOid(Long oid){
        return selectById(oid);
    }

    //通过roleCode获取Role对象
    @Override
    public Role findRoleByRoleCode(String roleCode){
        return selectOne(CriterionWrapper.instance().eq("roleCode", roleCode));
    }

    @Override
    public List findRoleList(UserRoleSearchDto dto, DwzPage page) {
         String sql ;
         Long oid = dto.getUser_id();
         // 如果user_id为空是指这个是 角色页面初始化菜单调用的方法
         if(oid==null){
              sql = "SELECT c.oid," +
                            "DATE_FORMAT(c.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                            "c.active," +
                            "c.orgType,"+
                            "c.roleCode," +
                            "c.roleDesc," +
                            "c.roleName " +
                      "FROM base_role c " +
                      "WHERE c.active = '1'" +
                      "and orgType in ('1','3','4') ";
         } else {  //如果user_id不为空是指 人员选择角色弹出窗口调用的方法
                // 此sql是查询出用户可以选择的同机构类型角色
              sql = "SELECT c.oid," +
                            "DATE_FORMAT(c.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                            "c.active," +
                            "c.orgType,"+
                            "c.roleCode," +
                            "c.roleDesc," +
                            "c.roleName, " +
                           "(CASE WHEN (SELECT COUNT(1) " +
                                           "FROM risk_user_role " +
                                          "WHERE role_id = c.oid " +
                                            "AND user_id = "+ oid +")>0 " +
                                  "THEN 1 " +
                                  "ELSE 0 END) AS xzbz " +
                      "FROM base_role c "+
                      "WHERE active = '1' " +
                      "and orgType in ('1','3','4')" +
                        "AND EXISTS (SELECT 1 " +
                                        "FROM risk_se_user a , risk_org b " +
                                        "LEFT JOIN risk_serviceOrg d ON d.oid = b.oid "+
                                       "WHERE a.org_id = b.oid " +
                                         "AND a.active = '1' " +
                                         "AND a.oid = " + oid +
                                        " AND b.orgType = c.orgType " +
                                         "AND IFNULL(d.serviceOrgType,99) = IFNULL(c.serviceOrgType,99) ) "    ;
         }
         SelectWrapper wrapper = SelectWrapper.instance();
         if (StringUtil.isNotEmpty(dto.getOrgType()) ) {
             sql = sql + "AND c.orgType = "+dto.getOrgType()+" ";
         }
         if (StringUtil.isNotEmpty(dto.getRoleCode()) ) {
             sql = sql + "AND c.roleCode = "+dto.getRoleCode()+" ";
         }
         if (StringUtil.isNotEmpty(dto.getRoleName()) ) {
             sql = sql + "AND c.roleName like '%"+dto.getRoleName()+"%' ";
         }

        sql = sql + " ORDER BY c.createOn,c.oid DESC" ;
        if(page!= null ){
            page.setTotalCount(querySqlCounts( sql,  wrapper));
            sql = sql + " limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage();
        }
         return  queryMaps( sql,  wrapper);
    }

    @Override
    public  List<Map<String,Object>> findRoleByName(Role role) {

        String sql = "SELECT oid "+
                       "FROM base_role "+
                     " WHERE roleName = "+role.getRoleName()+
                        " AND active ="+role.getActive();
           if (role.getOid() != null){
               sql = sql + " AND oid <> " + role.getOid(); // 如果oid不为空，校验修改的roleName 表中不能存在
           }
        SelectWrapper wrapper = SelectWrapper.instance();
        return  queryMaps( sql,  wrapper);
    }

      // 修改角色
    public Integer updateRole(Role role){
        String sql = "Update base_role " +
                       " SET roleName = '" +role.getRoleName()+"' , "+
                            "orgType = '"+role.getOrgType()+"' , "+
                            "roleCode = '"+role.getRoleCode()+"' , "+
                            "roleDesc = '"+role.getRoleDesc()+"' , "+
                            "updateOn = SYSDATE() "+
                     " WHERE oid = "+role.getOid()+"" ;
        return executeSqlUpdate(sql);
    }


    // 删除角色  角色置为无效
    public Integer invalidRole(Role role){
        String sql = "Update base_role " +
                       " SET active = '" +role.getActive()+"' , "+
                             "updateOn = SYSDATE() "+
                     " WHERE oid = "+role.getOid()+"" ;
        return executeSqlUpdate(sql);
    }



}
