package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.MenuDao;
import com.bcxin.risk.user.domain.Menu;
import com.bcxin.risk.user.dto.data.MenuDataDto;
import com.bcxin.risk.user.dto.search.MenuSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("menuDao")
@SuppressWarnings("unchecked")
public class MenuDaoImpl extends DaoImpl<Menu> implements MenuDao {

    @Override
    public List<Menu> findMenuByOid(long oid) {
        List<Menu> list = (List) selectList(CriterionWrapper.instance().eq("oid", oid));
        //调用DaoImpl.clalss的selectList方法  hibernateplus包下

        if (list != null && list.size() > 0) {
            return list;
        }
        return null;
    }

    public Menu findMenuByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public List<Menu> findMenuList(MenuSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getParent() != null) {
            criterionList.add(Restrictions.eq("parent_id", searchDto.getParent_id()));
        }
        if (StringUtil.isNotEmpty(searchDto.getMenuName())) {
            criterionList.add(Restrictions.eq("menuName", searchDto.getMenuName()));
        }
        if (StringUtil.isNotEmpty(searchDto.getMenuCode())) {
            criterionList.add(Restrictions.eq("menuCode", searchDto.getMenuCode()));
        }
        if (page == null) {
            return selectList(criterionList);
        }
        return selectPage(criterionList, page);
    }


     // 查找所有功能菜单，并区分角色已选和未选的
    @Override
    public List<MenuDataDto> queryMenu(Long oid) {

        String sql = "SELECT a.oid," +
                             "a.menuDesc," +
                             "a.menuName," +
                             "a.parent_id," +
                             "a.menuType," +
                             "(CASE WHEN (SELECT COUNT(1) " +
                                             "FROM base_role_menu " +
                                            "WHERE menu_id = a.oid " +
                                              "AND role_id = "+ oid +")>0 " +
                                    "THEN 1 " +
                                    "ELSE 0 END) AS xzbz " +
                " FROM base_menu a  " ;
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<MenuDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            MenuDataDto dto = new MenuDataDto(map);
            dtoList.add(dto);
        });
        return dtoList ;
    }

//    @Override
//    public List<MenuSearchDto> queryMenuList(MenuSearchDto dto) {
//
//        String sql = "SELECT oid, menuName,menuType,parent_id FROM risk_menu  ";
//        SelectWrapper wrapper = SelectWrapper.instance();
//        if ( StringUtil.isNotEmpty(dto.getMenuCode()) ){
//            wrapper.eq("menuCode", dto.getMenuCode());
//        }
//        if (StringUtil.isNotEmpty(dto.getMenuName()) ) {
//            wrapper.eq("menuName", dto.getMenuName());
//        }
//        return  selectList( sql, wrapper);
//    }

}
