package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.DateUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.UpdateWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.material.dao.ContractDao;
import com.bcxin.risk.report.material.domain.Contract;
import com.bcxin.risk.report.material.dto.ContratSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 合同上传数据类
 * @author Ethan
 */
@Repository("contractDao")
public class ContractDaoImpl extends DaoImpl<Contract> implements ContractDao {


	public Contract findByKey(Activity activity, String inputKey) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity",activity));
		criterionList.add(Restrictions.eq("inputKey",inputKey));
		return selectOne(criterionList);
	}

	public Contract findContractByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<Contract> findContractList(ContratSearchDto searchDto, Page page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getUser() != null ) {
			criterionList.add(Restrictions.eq("user", searchDto.getUser()));
		}
		if ( searchDto.getActivity() != null ) {
			criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
		}

//		   criterionList.add(Restrictions.eq("active", DictConst.Y));
		if ( page == null ) {
			return selectList(criterionList);
		}
		return selectPage(criterionList,page);
	}
	
	public void updateActive(Activity activity){
		UpdateWrapper wrapper = new UpdateWrapper();
		wrapper.eq("activity_id",activity.getOid());
		wrapper.set("active", DictConst.Y);
		wrapper.set("updateOn","'" + DateUtil.getCurrentDateTime()+"'");
		update(wrapper);
	}
}
