package com.bcxin.risk.report;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.report.material.dao.ReportDao;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class ReportDaoImpl extends DaoImpl<Report> implements ReportDao {

    @Override
    public Report findReportByActivity(Activity activity){
        List<Report> list = selectList(Restrictions.eq("activity", activity));
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Object> findReportDetailBySQL(String start_datetime , String end_datetime){
        String sql_where =" where 1=1 ";
        if(end_datetime.length()>0) {
            sql_where = sql_where + " and endDate >= '" + start_datetime + "' ";
        }
        if(start_datetime.length()>0) {
            sql_where = sql_where + " and startDate <= '" + end_datetime + "' ";
        }
        sql_where = sql_where + " and activityStatus >= '" + DictConst.ACTIVITYSTATUS_CBJB + "' ";

        String sql="select count(*),sum(number) FROM risk_activity  ";

        sql=sql+sql_where+"  ";

        Session session = this.sessionFactory.getCurrentSession();
        // Transaction tx = null;
        List<Object> infolist = null;
        try {
            // tx=session.beginTransaction();
            Query query = session.createSQLQuery(sql);
            infolist = query.list();
            // tx.commit();
        } catch (HibernateException e) {
            throw e;
        }
        return infolist;
    }

    @Override
    public List<Object> findReportDetailBySQL(String end_datetime) {
        String sql_where=" where 1=1 ";

        if(end_datetime.length()>0) {
            sql_where = sql_where + " and endDate >= '" + end_datetime + "' ";
            sql_where = sql_where + " and startDate <= '" + end_datetime + "' ";
            sql_where = sql_where + " and activityStatus = '" + DictConst.ACTIVITYSTATUS_CBJB + "' ";
        }
        String sql="select count(*),sum(number) FROM risk_activity  ";

        sql=sql+sql_where+"  ";

        Session session = this.sessionFactory.getCurrentSession();
        // Transaction tx = null;
        List<Object> infolist = null;
        try {
            // tx=session.beginTransaction();
            Query query = session.createSQLQuery(sql);
            infolist = query.list();
            // tx.commit();
        } catch (HibernateException e) {
            throw e;
        }
        return infolist;
    }

}
