package com.bcxin.risk.log;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.compose.dto.SearchDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Repository("userLoginLogDao")
public class UserLoginLogDaoImpl extends DaoImpl<UserLoginLog> implements UserLoginLogDao{

    @Resource
    private BaseDao baseDao;

    @Override
    public List<UserLoginLog> logLoginList(SearchDto searchDTO, DwzPage page) {
        List<Criterion> criterionList = Lists.newArrayList();
        List<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc("createOn"));
        if ( page == null ) {
            return baseDao.findByCriterion(UserLoginLog.class, criterionList,orderList);
        }
        return baseDao.findByCriterionForPage(UserLoginLog.class, criterionList, page,orderList);
    }


    @Override
    public List logLoginList(DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " DATE_FORMAT(t1.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " t1.ipAddress,t2.userName"+
                " from log_UserLoginLog t1 " +
                " inner join risk_se_user t2 on t1.user_id = t2.oid ";

        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY t1.oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }

}
