package com.bcxin.risk.common.dao;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.common.domain.SyncTask;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Repository
public class SyncTaskDaoImpl extends DaoImpl<SyncTask> implements SyncTaskDao {

    @Override
    public SyncTask findSyncTaskByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SyncTask> findUnCompleteTask(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("success", DictConst.N);
        /* 取5分钟之前的，防止正在同步的任务重复同步 */
        wrapper.lt("createOn", "'"+DateUtil.offsetMinute(new Date(),-5)+"'");
        return selectList(wrapper);
    }

}
