package com.bcxin.risk.common.dao;

import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.base.dao.BaseDaoImpl;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.constant.DictConst;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("scheduleDao")
@SuppressWarnings("unchecked")
public class ScheduleDaoImpl extends BaseDaoImpl implements ScheduleDao {

    
	/**
	 * 
	 * <b>Function 查询需要将活动状态变成结束状态的活动</b> 
	 * 前置条件（活动状态为为结束；活动结束时间早于当前时间；已完成监理报告上传；已进行第三阶段勘查）
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<String> findNeedEndReport(){
		Map<String, Object> paramMap = Maps.newHashMap();

		/***  塞选活动置为结束状态的条件
		 *    1、已过活动时间
		 ***/

        StringBuilder sql = new StringBuilder("SELECT a.oid  " +
				"     FROM risk_activity a " +
				"    WHERE SYSDATE() > a.endDate  " +
				"      AND a.activityStatus != '50' and a.gov = 0");


		List<String> resultList = Lists.newArrayList();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			resultList.add(result.get("oid")==null?"":result.get("oid").toString());
		}

		return resultList;

	}
	

	/**
	 *
	 * <b>Function 查询需要将活动状态变成结束状态的活动(单场活动)</b>
	 * 前置条件（活动状态为为结束；活动结束时间早于当前时间；已完成监理报告上传；已进行第三阶段勘查）
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	public List<String> findNeedEndReport(Long reportId){
		Map<String, Object> paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT a.oid FROM risk_activity a "
				+ " inner join RISK_ActivityRecord r on r.activity_id = a.oid "
				+ " inner join risk_activityrecord rr on rr.activity_id = a.oid "
				+ " where 1=1 and endDate < sysdate() and a.activityStatus != '"+DictConst.ACTIVITYSTATUS_HDJS+"' ");

		if ( reportId == 0 ) {
			return Lists.newArrayList();
		} else {
			sql.append(" and a.oid = :ooid");
			paramMap.put("ooid", reportId);
		}

		sql.append(" and r.activitySubStep = :subStep");
		sql.append(" and rr.activitySubStep = :subStep2");
		paramMap.put("subStep", DictConst.ACTIVITYSUBSTEP_JLBGYWC);
		paramMap.put("subStep2", DictConst.ACTIVITYSUBSTEP_DSJDTKYWC);

		List<String> resultList = Lists.newArrayList();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			resultList.add(result.get("oid")==null?"":result.get("oid").toString());
		}
		return resultList;
	}


}
