package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class MarketRegionDaoImpl extends DaoImpl<MarketRegion> implements MarketRegionDao {

    @Override
    public List<MarketRegion> findRegionByLevel(String level) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if(StringUtil.isNotEmpty(level)){
            wrapper.eq("level",level);
        }
        return selectList(wrapper);
    }

}
