package com.bcxin.risk.activity;

import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * Created by PVer on 2017/4/24.
 */
@Repository
public class ActivityVenueDaoImpl extends DaoImpl<ActivityVenue> implements ActivityVenueDao{


    @Override
    public List<ActivityVenue> findActivityVenuesListByActivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null) {

            criterionList.add(Restrictions.eq("activity", activity));
        }
        return selectList(criterionList);
    }

    @Override
    public void deleteActivityVenue(Activity activity) {
        DeleteWrapper wrapper = DeleteWrapper.instance();
        wrapper.eq("activity_id", activity.getOid());
        delete(wrapper);
    }
}
