package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.ConfigFunction;
import com.bcxin.risk.sys.resources.ConfigResources;

import java.util.HashMap;
import java.util.Map;

public class ConfigUtil {

	private static Map<String, String> data = new HashMap<String, String>();
	private static Map<String, String> regionData = new HashMap<String, String>();
	private static Map<String, ConfigFunction> dataFunction = new HashMap<String, ConfigFunction>();
	
	public static String getValue(String key) {
		String value = data.get(key.toUpperCase());

		if ( "materialupload_path".equalsIgnoreCase(key)
				|| "temp_path".equalsIgnoreCase(key) ) { //如果是获取 材料上传路径和临时路径
			//如果是windows，增加盘符
			String os = System.getProperty("os.name");
			if (os.toLowerCase().startsWith("win")) {
				if (value.startsWith("/")) {
					value = "D:" + value;
				}
			}
		}
		if ( "web_url".equalsIgnoreCase(key) ) { //如果是本地开发环境地址
			String profileEnvi = ConfigResources.PROFILE_ENVI;
			if (java.util.Objects.equals(profileEnvi,"dev")) {
				value = "http://localhost:8080/";
			}
		}

		if ( "main_url".equalsIgnoreCase(key) ) { //如果是本地开发环境地址
			String profileEnvi = ConfigResources.PROFILE_ENVI;
			if (java.util.Objects.equals(profileEnvi,"dev")) {
				value = "http://localhost:9000/";
			}
		}
		if ("limit_minDay".equalsIgnoreCase(key)) {
			ConfigFunction function = dataFunction.get(getValue("envi_code"));
			return function.getActivityLimitMinDay();
		}
		return value;
	}

	/**
	 * 本系统的环境
	 */
	public static String envi(){
		return ConfigUtil.getValue("envi");
	}

	/**
	 * 系统文件上传基础路径
	 */
	public static String material(){
		return ConfigUtil.getValue("materialUpload_path");
	}


	public static void putValue(String key,String value) {
		data.put(key, value);
	}

	public static Map<String, String> getData() {
		return data;
	}

	public static String webSiteUrl(){
		return getValue("web_url");
	}

	public static ConfigFunction getFunction(String province) {
		return dataFunction.get(province);
	}

	public static void putFunction(ConfigFunction config) {
		dataFunction.put(config.getProvince(), config);
	}

	public static String getRegion(String key) {
		return regionData.get(key);
	}

	public static void putRegion(String key,String value) {
		regionData.put(key, value);
	}
	//public static String getValue2(String key){
	//	if (key.equals("1")) {
	//		return "1";
	//	}
	//	if (key.equals("2")) {
	//		return getValue2("1") + "1";
	//	}
	//	return "0";
	//}
	//
	//public static void main(String[] args) {
	//	System.out.println(getValue2("2"));
	//}
}
