package com.bcxin.risk.common.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.util.obs.OBSUtil;
import com.bcxin.risk.constant.Const;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.exception.FileException;
import com.bcxin.risk.sys.SysBasicUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.net.www.protocol.https.Handler;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

public class BcxinFileUtils {

	private static Logger log = LoggerFactory.getLogger(BcxinFileUtils.class);

	/**
	 * 默认文件上传路径
	 */
	private final static String DEFAULT_UPLOAD_DIR = "upload";

	private final static String DEFAULT_TEMP_DIR = "temp";

	/**
	 * 文件加时间戳的连接符
	 */
	private final static String TI = "_t_";


	public static String zipFiles(List<String> filePaths, String zipName) {
		byte[] buffer = new byte[1024];
		String strZipPath = zipName;
		try {
			ZipOutputStream out = new ZipOutputStream(new FileOutputStream(strZipPath));
			List<File> files = Lists.newArrayList();
			for (String filePath : filePaths) {
				if (StringUtil.isNotEmpty(filePath)){
					File policyFile = new File(filePath);
					if(policyFile.exists()) {
						files.add(policyFile);
						System.out.println("需要打包的文件：" + filePath);
					}
				}
			}

			for (File file : files) {
				if (file.isDirectory()) {
					continue;
				}
				FileInputStream fis = new FileInputStream(file);
				out.setEncoding(System.getProperty("sun.jnu.encoding"));
				out.putNextEntry(new ZipEntry(file.getName()));
				// 设置压缩文件内的字符编码，不然会变成乱码
				//out.setEncoding("utf8");
				int len;
				// 读入需要下载的文件的内容，打包到zip文件
				while ((len = fis.read(buffer)) > 0) {
					out.write(buffer, 0, len);
				}
				out.closeEntry();
				fis.close();
			}
			out.close();

			for (File file : files) {
				if (file.isFile() && file.exists()) {
					file.delete();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}


	/**
	 *
	 * <b>Function </b> 本地文件存储
	 * @return 文件全url
	 * <b>
	 */
	public static String saveFile(MultipartFile multipartFile) {
		if ( multipartFile != null ) {
			if (StringUtil.isNotEmpty(multipartFile.getOriginalFilename())) {
				try {
					Date now = new Date();
					String materialFileName = now.getTime() + StringUtil.randomString(5) + Const.DOT; // a.jpg
					String fileType = Files.getFileExtension(multipartFile.getOriginalFilename()); // jpg
					materialFileName = materialFileName + fileType;
					String dirDate = DateUtil.today();
					File dir = new File(ConfigUtil.material() + dirDate);
					if(!dir.exists()) {
						dir.mkdirs();
					}
					String url = ConfigUtil.webSiteUrl() + "/getResource.do?path=" + dirDate + "/" + materialFileName;
					String targetPath = ConfigUtil.material() + dirDate + "/" + materialFileName;
					File targetFile = new File(targetPath);
					log.info("执行本地文件上传..." + targetFile);
					multipartFile.transferTo(targetFile);
					log.info("本地文件上传成功!");
					return url;
				} catch(Exception e) {
					e.printStackTrace();
					log.error(e.getMessage(), e);
					return null;
				}
			}
		}
		return null;
	}

	/**
	 * 
	 * <b>Function </b> 本地文件存储
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2017年1月3日 下午8:34:36
	 * @注意事项 </b>
	 * <b>
	 */
	public static Map<String, String> saveFile(String uploadPath,MultipartFile multipartFile) {
			if( multipartFile != null ) {
			if(StringUtil.isNotEmpty(multipartFile.getOriginalFilename())) {
				try {
					Date now = new Date();
					String materialFileName = now.getTime() + StringUtil.randomString(5) +"."; // a.jpg
					String fileType = Files.getFileExtension(multipartFile.getOriginalFilename()); // jpg
					materialFileName = materialFileName + fileType;
					String dirDate = DateUtil.today();
					File dir = new File(uploadPath + dirDate);
					if(!dir.exists()) {
						dir.mkdirs();
					}
					String url = "/getResource.do?path=" + dirDate + "/" + materialFileName;
					String targetPath = uploadPath + dirDate + "/" + materialFileName;
					File targetFile = new File(targetPath);
					log.info("执行本地文件上传..." + targetFile);
					multipartFile.transferTo(targetFile);
					Map<String,String> map = new HashMap<String, String>();
					map.put("url", url);
					map.put("key", "local_"+now.getTime());
					if(map == null || map.size() < 2) {
						log.info("本地文件上传失败！");
					} else {
						log.info("本地文件上传成功!");
					}
					return map;
				} catch(Exception e) {
					e.printStackTrace();
					log.error(e.getMessage(), e);
					return null;
				}
			}
		}
		return null;
	}


	/**
	 * 上传文件
	 * 
	 * @param file
	 *            文件
	 * @param radomfileName
	 *            保存文件名
	 * @param materialFilePath
	 *            保存路径
	 * @return
	 */
	public static boolean fileUpload(MultipartFile file, String radomfileName,
			String materialFilePath) {
		boolean flag = true;
		File baseFile = new File(materialFilePath);
		File trainFile = new File(baseFile, radomfileName);
		if (!baseFile.exists()) {
			baseFile.mkdirs();
		}
		try {
			file.transferTo(trainFile);
		} catch (IllegalStateException e) {
			flag = false;
		} catch (IOException e) {
			flag = false;
		}// 保存文件
		return flag;
	}



	/**
	 * 华为OBS文件上传存储（同步）
	 * @return
	 */
	public static String huaweiOBSFileUpload(MultipartFile xFile,String envi){
		/* 获得文件后缀名 jpg*/
		String fileType = Files.getFileExtension(xFile.getOriginalFilename());
		/* 生成随机文件名 12345*/
		String randomNumber = DateUtil.current(false) + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
		String fileName = randomNumber + Const.DOT + fileType;
		/* 生成目录 */
		String directoryName = ConfigResources.PROFILE_ENVI + "/" + DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/";
		String ossKey = ConfigResources.PROFILE_ENVI + "/" + DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/" + fileName;
		OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try ( InputStream inputStream =  xFile.getInputStream() )  {
			return obsUtil.put( directoryName,ossKey, inputStream);
		} catch(Exception e) {
			e.printStackTrace();
			log.error(e.getMessage(), e);
		}
		return "";
	}


	/**
	 * 华为OBS文件上传存储（本地文件上传到华为公共云）
	 * @return
	 */
	public static String huaweiLocalFileUpload(File file,String date,String envi){
		/* 生成目录 */
		String directoryName = DEFAULT_UPLOAD_DIR + "/" +date + "/";
		String ossKey = DEFAULT_UPLOAD_DIR + "/" + date + "/" + file.getName();
		OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
		try ( InputStream inputStream = FileUtil.getInputStream(file))  {
			return obsUtil.put( directoryName,ossKey, inputStream);
		} catch(Exception e) {
			e.printStackTrace();
			log.error(e.getMessage(), e);
		}
		return "";
	}
	

	public static void deleteFolder(File file) {
		if(file.exists()) {
			if(file.isDirectory()) {
				for(File f : file.listFiles()) {
					deleteFolder(f);
				}
				file.delete();
			} else {
				file.delete();
			}
		}
	}


	/**
	 * 根据系统的地址，下载文件到新的路径
	 * @param urlStr
	 * @param fileName
	 * @param savePath
	 * @return
	 * @throws IOException
	 */
	public static List<String> downLoadFromUrl(String urlStr, String fileName, String savePath){
		try {
			if (StringUtil.isEmpty(urlStr)) {
				return Lists.newArrayList();
			}
			if (StringUtil.isNotEmpty(fileName)) {
				fileName = fileName.replace("/", "");
			}
			List<String> pathList = Lists.newArrayList();
			String[] imageValues = urlStr.split("&&");
			int count = 1;
			for (String imageValue : imageValues) {
				String disposeFileName = fileName;
				String[] splitStr = StringUtil.split(imageValue, "||");  //再从一张图片url里面切分到url
				String imagePath = "";
				if (splitStr.length >= 3) {
					imagePath = splitStr[1];
				} else {
					imagePath = urlStr;
				}
				if (count > 1) {
					if (disposeFileName.contains(".")) {
						disposeFileName = disposeFileName.substring(0, disposeFileName.lastIndexOf(".")) + count;
					} else {
						disposeFileName = disposeFileName + count;
					}
				}
				if (imagePath.startsWith("http")) {
					String filePath = "";
					disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
					filePath = download(imagePath, disposeFileName, savePath);
					pathList.add(filePath);
				} else if (imagePath.indexOf("path=") > 0) {
					String intranet = SysBasicUtil.getConfig("switch_intranet");
					String web_url = "";
					if (DictConst.Y.equals(intranet)) {
						web_url = SysBasicUtil.getConfig("intranet_url");
					} else {
						web_url = SysBasicUtil.getConfig("web_url");
					}
					//如果是开发环境，则获取本地的地址
					String PROFILE_ENVI = ConfigResources.PROFILE_ENVI;
					if (Objects.equals(PROFILE_ENVI, "dev")) {
						web_url = ConfigResources.DEV_URL;
					}
					if (StringUtil.isNotEmpty(web_url)) {
						if (web_url.endsWith("/") && imagePath.endsWith("/")) {
							web_url = web_url.substring(0, web_url.length() - 1);
						}
					}
					imagePath = web_url + imagePath;
					disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
					//本地获取
					String filePath = download(imagePath, disposeFileName, savePath);
					pathList.add(filePath);
				}
				count++;
			}
			return pathList;
		} catch (Exception e) {
			e.printStackTrace();
			log.error("文件下载异常："+e.getMessage());
			return Lists.newArrayList();
		}
	}



	/**
	 * 根据系统的地址，下载文件到新的路径，文件名用当前文件的文件名
	 * @param urlStr
	 * @param savePath
	 * @return
	 * @throws IOException
	 */
	public static List<String> downLoadFromUrl(String urlStr, String savePath){
		try {
			if (StringUtil.isEmpty(urlStr)) {
				return Lists.newArrayList();
			}
			List<String> pathList = Lists.newArrayList();
			String[] imageValues = urlStr.split("&&");
			for (String imageValue : imageValues) {
				String disposeFileName = "";
				String[] splitStr = StringUtil.split(imageValue, "||");  //再从一张图片url里面切分到url
				String imagePath = "";
				if (splitStr.length >= 3) {
					imagePath = splitStr[1];
					disposeFileName = Files.getNameWithoutExtension(splitStr[2]);
				} else {
					disposeFileName = Files.getNameWithoutExtension(imagePath);
					imagePath = urlStr;
				}
				if (imagePath.startsWith("http")) {
					disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
					String filePath = download(imagePath, disposeFileName, savePath);
					pathList.add(filePath);
				} else if (imagePath.indexOf("path=") > 0) {
					String intranet = SysBasicUtil.getConfig("switch_intranet");
					String web_url = "";
					if (DictConst.Y.equals(intranet)) {
						web_url = SysBasicUtil.getConfig("intranet_url");
					} else {
						web_url = SysBasicUtil.getConfig("web_url");
					}
					//如果是开发环境，则获取本地的地址
					String PROFILE_ENVI = ConfigResources.PROFILE_ENVI;
					if (Objects.equals(PROFILE_ENVI, "dev")) {
						web_url = ConfigResources.DEV_URL;
					}
					if (StringUtil.isNotEmpty(web_url)) {
						if (web_url.endsWith("/") && imagePath.endsWith("/")) {
							web_url = web_url.substring(0, web_url.length() - 1);
						}
					}
					imagePath = web_url + imagePath;
					disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
					//本地获取
					String filePath = download(imagePath, disposeFileName, savePath);
					pathList.add(filePath);
				}
			}
			return pathList;
		} catch (Exception e){
			e.printStackTrace();
			log.error("文件下载异常："+e.getMessage());
			return Lists.newArrayList();
		}
	}

	/**
	 * 根据 url 下载
	 * @param urlStr
	 * @param fileName
	 * @param savePath
	 * @return
	 * @throws FileException
	 */
	public static String download(String urlStr, String fileName, String savePath) throws FileException {
		FileOutputStream fos = null;
		InputStream inputStream = null;
		try {
			URL url = null;
			if(urlStr.startsWith("https://")){
				trustAllHosts();
				url = new URL(null,urlStr,new Handler());
				HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
				//设置超时间为10秒
				conn.setConnectTimeout(10 * 1000);
				//防止屏蔽程序抓取而返回403错误
				conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
				//得到输入流
				inputStream = conn.getInputStream();
			}else{
				url = new URL(urlStr);
				HttpURLConnection conn = (HttpURLConnection) url.openConnection();
				//设置超时间为10秒
				conn.setConnectTimeout(10 * 1000);
				//防止屏蔽程序抓取而返回403错误
				conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
				//得到输入流
				inputStream = conn.getInputStream();
			}
			//获取自己数组
			byte[] getData = readInputStream(inputStream);
			//文件保存位置
			File saveDir = new File(savePath);
			if (!saveDir.exists()) {
				saveDir.mkdirs();
			}
			File file = new File(saveDir + File.separator + fileName);
			fos = new FileOutputStream(file);
			fos.write(getData);

			String filePath = saveDir + "/" + fileName;
			log.info("文件下载，url路径[{}]，文件路径[{}]", url,filePath);
			return filePath;
		} catch (IOException e){
			throw new FileException(e.getMessage());
		} finally {
			try {
				if (fos != null) {
					fos.close();
				}
				if (inputStream != null) {
					inputStream.close();
				}
			} catch (IOException e){
				e.printStackTrace();
			}
		}
	}


	private static void trustAllHosts() {
		TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
			@Override
			public java.security.cert.X509Certificate[] getAcceptedIssuers() {
				return new java.security.cert.X509Certificate[] {};
			}

			@Override
			public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) {
			}

			@Override
			public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) {
			}
		} };

		// Install the all-trusting trust manager
		try {
			SSLContext sc = SSLContext.getInstance("SSL", "SunJSSE");
			sc.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
			HttpsURLConnection.setDefaultHostnameVerifier(NoopHostnameVerifier.INSTANCE);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 根据系统默认存储路径的方式，获取其中的文件路径
	 * example : 参数 local_1497333054610||/getResource.do?path=2017-06-13/1497333054610.jpg||4.jpg&&local_1497333054610||/getResource.do?path=2017-06-13/1497333054611.jpg||4.jpg
	 * result ： 2017-06-13/1497333054610.jpg  2017-06-13/1497333054611.jpg
	 * @param localFilePath
	 * @return
	 */
	public static List<String> filterMultiFilePath(String localFilePath){
		List<String> list = Lists.newArrayList();
		if (StringUtil.isEmpty(localFilePath)) {
			return list;
		}
		String[] filePaths = StringUtils.split(localFilePath, "&&");
		for(String filePath : filePaths){
			if (filePath.indexOf("||")>-1) {
				String[] explain = StringUtils.split(filePath, "||");
				if (explain.length < 3) {
					continue;
				}
				String localUrl = explain[1];
				if (localUrl.indexOf("path=") == -1) {
					continue;
				}
				localUrl = localUrl.substring(localUrl.indexOf("path=")+5,localUrl.length());
				list.add(localUrl);
			}
		}
		return list;
	}


	/**
	 * 根据系统默认存储路径的方式，获取其中的文件路径
	 * example : 参数 local_1497333054610||/getResource.do?path=2017-06-13/1497333054610.jpg||4.jpg&&local_1497333054610||/getResource.do?path=2017-06-13/1497333054611.jpg||4.jpg
	 * result ： /getResource.do?path=2017-06-13/1497333054610.jpg  /getResource.do?path=2017-06-13/1497333054611.jpg
	 * @param localFilePath
	 * @return
	 */
	public static List<String> filterMultiFileUrl(String localFilePath){
		List<String> list = Lists.newArrayList();
		if (StringUtil.isEmpty(localFilePath)) {
			return list;
		}
		String[] filePaths = StringUtils.split(localFilePath, "&&");
		for(String filePath : filePaths){
			if (filePath.indexOf("||")>-1) {
				String[] explain = StringUtils.split(filePath, "||");
				if (explain.length < 3) {
					continue;
				}
				String localUrl = explain[1];
				list.add(localUrl);
			}
		}
		return list;
	}


	/**
	 * 根据系统默认存储路径的方式，获取其中的文件路径
	 * example : 参数 local_1497333054610||/getResource.do?path=2017-06-13/1497333054610.jpg||4.jpg
	 * result ： /getResource.do?path=2017-06-13/1497333054610.jpg
	 * @param localFilePath
	 * @return
	 */
	public static String filterSingleLocalFilePath(String localFilePath){
		if (StringUtil.isEmpty(localFilePath)) {
			return localFilePath;
		}
		if (localFilePath.indexOf("||")>-1) {
			String[] explain = StringUtils.split(localFilePath, "||");
			if (explain.length < 3) {
				return localFilePath;
			}
			return explain[1];
		}
		return localFilePath;
	}


	/**
	 * 根据系统默认存储路径的方式，获取其中的文件路径
	 * example : 参数 /getResource.do?path=2017-06-13/1497333054610.jpg
	 * result ： 2017-06-13/1497333054610.jpg
	 * @param localFilePath
	 * @return
	 */
	public static String filterSingleFilePath(String localFilePath){
		if (StringUtil.isEmpty(localFilePath)) {
			return Const.BLANK_CHAR;
		}
		if ( localFilePath.contains("path=")) {
			return localFilePath.substring(localFilePath.indexOf("path=")+5,localFilePath.length());
		}
		return localFilePath;
	}

	/**
	 * 根据文件存储全路径，获取其中的文件文件夹路径
	 * example : 参数 /data/pss/material/2017-06-13/1497333054610.jpg
	 * result ： /data/pss/material/2017-06-13/
	 * @param filePath
	 * @return
	 */
	public static String filterFileDir(String filePath){
		if (StringUtil.isEmpty(filePath)) {
			return Const.BLANK_CHAR;
		}
		String fileName = Files.getNameWithoutExtension(filePath);
		String type = Files.getFileExtension(filePath);
		return filePath.replaceAll(fileName+"\\."+type,"");
	}


	/**
	 * 根据文件存储URL路径，获取其中的文件文件夹路径
	 * example : 参数 /getResource.do?path=2017-06-13/1497333054610.jpg
	 * result ： 2017-06-13
	 * @param filePath
	 * @return
	 */
	public static String filterUrlFileDir(String filePath){
		if (StringUtil.isEmpty(filePath)) {
			return Const.BLANK_CHAR;
		}
		String localFilePath = filterSingleFilePath(filePath);
		String fileName = Files.getNameWithoutExtension(localFilePath);
		String type = Files.getFileExtension(localFilePath);
		return localFilePath.replaceAll(fileName+"\\."+type,"");
	}

	/**
	 * 根据系统默认存储路径的方式，获取其中的文件名称
	 * example : 参数 /getResource.do?path=2017-06-13/1497333054610.jpg
	 * result ： 1497333054610.jpg
	 * @param localFilePath
	 * @return
	 */
	public static String filterSingleFileName(String localFilePath){
		if (StringUtil.isEmpty(localFilePath)) {
			return Const.BLANK_CHAR;
		}
		if (localFilePath.indexOf("path=") == -1) {
			return Const.BLANK_CHAR;
		}
		String filePath = localFilePath.substring(localFilePath.indexOf("path=")+5,localFilePath.length());
		if (filePath.contains("/")) {
			filePath = filePath.substring(filePath.lastIndexOf("/")+1,filePath.length());
		}
		return filePath;
	}

	private static byte[] readInputStream(InputStream inputStream) throws IOException {
		byte[] buffer = new byte[1024];
		int len = 0;
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		while((len = inputStream.read(buffer)) != -1) {
			bos.write(buffer, 0, len);
		}
		bos.close();
		return bos.toByteArray();
	}


	/**
	 * 为文件名增加时间戳
	 * @return
	 */
	public synchronized static String packTimestamp(String fileName){
		if (StringUtil.isEmpty(fileName)) {
			return Const.BLANK_CHAR;
		}
		if (fileName.contains(Const.DOT)) {
			return Files.getNameWithoutExtension(fileName) + TI + DateUtil.format(new Date(), DatePattern.PURE_DATETIME_MS_PATTERN) + Files.getFileExtension(fileName);
		} else {
			return fileName + TI + DateUtil.format(new Date(), DatePattern.PURE_DATETIME_MS_PATTERN) ;
		}
	}


	/**
	 * 处理文件夹路径，并根据文件夹路径创建文件夹
	 * @param paths
	 * @return
	 */
	public static String appendFolderPath(String[] paths){
        StringBuilder sb = new StringBuilder();
		for (String path:paths) {
			if (sb.length()==0) {
				sb.append(path);
			} else {
				if (sb.toString().endsWith(File.separator)) {
					sb.append(path).append(File.separator);
				} else {
					sb.append(File.separator).append(path).append(File.separator);
				}
			}
		}
		mkDir(sb.toString());//创建文件夹
		return sb.toString();
	}


	/**
	 * 创建文件夹
	 * @param dir
	 */
	public static void mkDir(String dir){
		File fileDir = new File(dir);
		if(!fileDir.exists()) {
			fileDir.mkdirs();
		}
	}

	/**
	 * 根据系统默认存储路径的方式，获取其中的文件路径
	 * example : 参数 local_1497333054610||/getResource.do?path=2017-06-13/1497333054610.jpg||4.jpg&&local_1497333054610||/getResource.do?path=2017-06-13/1497333054610.jpg
	 * result ： http://www.bcxin.com.cn/getResource.do?path=2017-06-13/1497333054610.jpg&&http://www.bcxin.com.cn/getResource.do?path=2017-06-13/1497333054610.jpg
	 * @param localFilePath
	 * @return
	 */
	public static String filterMultiLocalFilePath(String channel,String localFilePath){
		if (StringUtil.isEmpty(localFilePath)) {
			return localFilePath;
		}
		List<String> files = Lists.newArrayList();
		String[] stringList = localFilePath.split("&&");
		for (String path:stringList) {
			files.add(channel + filterSingleLocalFilePath(path));
		}
		return Joiner.on("&&").join(files);
	}


	public static void main(String[] args) {
		//System.out.println("");
		//System.out.println(DateUtil.current(true));
		//System.out.println(DateUtil.current(false));
		//System.out.println(DateUtil.now());

		//System.out.println(Files.getFileExtension("http://bcxin-risk-extranet-test.oss-cn-shanghai.aliyuncs.com/correction/589827/201705311654149062.jpg"));
		//System.out.println(Files.getNameWithoutExtension("http://bcxin-risk-extranet-test.oss-cn-shanghai.aliyuncs.com/correction/589827/201705311654149062.jpg"));

		//File file = new File("");
		//System.out.print(file instanceof File);
//		List<String> files = Lists.newArrayList();
//		files.add("D:\\data\\1.png");
//		files.add("D:\\data\\副本.png");
//		files.addAll(BcxinFileUtils.downLoadFromUrl("https://dxhd.gat.zj.gov.cn/resources/bcxin/images/slide3.jpg", "D:\\data"));

		//System.out.println(filterFileDir("/data/pss/material/2017-06-13/1497333054610.jpg"));

//		zipFiles(files,"D:/我是压缩包.zip");
		String url = "https://nx.dh.pss360.cn:9002/getResource.do?path=2021-06-23/162443036329383773.docx";
//		String url = "http://www.pss360.cn/getResource.do?path=2021-06-23/162441652084012213.docx";
		download(url,"_acaf_34_t_20210623190000673.docx","D:\\data\\pss\\material\\ningxia\\2021-06-24\\hd");
	}
}
