import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";

const store = require("store");

const { TabPane } = Tabs;

export default class CoursewareLibraryManagement extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // currentURL: "http://localhost:8888/refund/record?systype=saas&sessionId=A76BAF9AA8E44882C74D194AD12747451A6F12F74D3FA8375CC43DB1DFE155AAEA51A8E7797BAB6E7DD15C3EA68B63A6528600E326FC0D28CF29A80E0D1BA8C627A82F9B0D635788C55A496B04BE78F33F444F306A4D084D638D6F367F9A9EDA3E30BE89495C7ED2D5A43AF258C6C73B&areaCode=450000",
    };
  }

  componentDidMount = () => {

  }
  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab="退款记录" key="1" />
        </Tabs>
        {store.get("refundRecordURL") !== undefined ? (
          <div style={{ height: "inherit" }}>
            <iframe
              title="退款记录"
              src={store.get("refundRecordURL")}
              // src={this.state.currentURL}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) : ''
        }

        {/*
            {store.get("coursewareLibraryManagementURL") !== undefined ? (
              <iframe title="课程库管理" src={currentURL + '?sessionId=' + store.get("saas")["sessionId"]} width="100%" height="100%" frameBorder="0">
                您的浏览器不支持iframe，请升级
              </iframe>
            ) : ''
            }
            */}
        {/*
            课件库管理
            <div id="CoursewareLibraryManagement" />
            <iframe title="ds" src="http://www.alloyteam.com/nav/" width="100%" height="100%" frameBorder="0">
              您的浏览器不支持iframe，请升级
            </iframe>
            <div style={{ width: '100%', height: '800px' }}>
              <iframe title="ds" src="http://120.76.218.179:9149/pxxtfront/train-office/#/product" width="100%" height="100%" frameBorder="0">
                您的浏览器不支持iframe，请升级
              </iframe>
          </div>
          */}
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
