import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";

const store = require("store");
const { TabPane } = Tabs;

export default class OrderManagement extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      currentURL: store.get("orderManagementURL")["orderManagementURL"],
      // currentURL: "http://localhost:8888/center?switchArea=order&systype=saas&sessionId=4B9B34CD9602CF7E26B867BB14AD038CF0FAFAFF00222F4AA3E93D5B2E599803359127536B6B02455485C6AA66539AF041D7755773F0BE4D9B9C1D980F7F3A63&areaCode=110100",
    };
  }
  componentDidMount = () => {
    //sessionId
  }
  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab="订单管理" key="1" />
        </Tabs>
        {store.get("orderManagementURL") !== undefined ? (
          <div style={{ height: "inherit" }}>
            <iframe
              title="订单管理"
              src={this.state.currentURL}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
              </iframe>
          </div>
        ) : ''
        }
        {/*{store.get("saas") !== undefined ? (
              <iframe title="订单管理" src={this.state.currentURL + '&sessionId=' + store.get("saas")["sessionId"] + '&username=' + store.get("user")["username"] + '&password=' + store.get("user")["password"]} width="100%" height="100%" frameBorder="0">
                您的浏览器不支持iframe，请升级
              </iframe>
            ) : ''
            }
            {/* {store.get("saas") !== undefined ? (
              <iframe title="订单管理" src='"+"http://localhost:3000/center?switchArea=order&sessionId="+store.get("saas")["sessionId"]+"' width="100%" height="100%" frameBorder="0">
                您的浏览器不支持iframe，请升级
              </iframe>
            ) : ''
            } */}
      </Container >
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
