import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Button,
  Table,
  Select,
  Alert,
  DatePicker,
  notification,
  Modal,
  Popover
} from 'antd';
import store from 'store';
import { qualify_getcurrentorgan } from '../../../../../services/bkt/apis';

import tablePage from '../../../../../utils/hoc/tablePage';
import columnFun from './columns';
import SubDrawer from './SubDrawer';
import SXSubDrawer from './SXSubDrawer';
import moment from 'moment';

const { RangePicker } = DatePicker;
const { Option } = Select;
const dateFormat = 'YYYY-MM-DD';
@connect(state => ({
  global: state.global
}))
@tablePage({ type: 'bkt' })
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //抽屉
      drawerVisble: false,
      personApplyId: '',  //当前选中的id
      thirdParty: false,//是否为第三方机构
      isNanNiCode:false,//是否是南宁地区码
    };
  }

  componentDidMount() {
    this.qualify_getcurrentorgan()
  }

  //判断是否为第三方培训机构
  qualify_getcurrentorgan(){
    qualify_getcurrentorgan().then(res=>{
      console.log(res)
      if(res.data){
        this.setState({
          thirdParty:res.data.thirdParty
        })
      }
    })
  }
  
  checkAreaCode() {
    return this.state.dataListAreaCode && this.state.dataListAreaCode.indexOf('6106') == 0
  }
  // 判断是否是北京地区(北京地区隐藏劳动合同、户籍类型、户籍所在地三个字段)
  checkBeijinCode(){
    return this.state.dataListAreaCode && String(this.state.dataListAreaCode).indexOf('110') == 0
  }
  // 判断是否为商洛地区
  checkSRAreaCode = ()=> {
    return this.state.dataListAreaCode && this.state.dataListAreaCode.indexOf('611000') == 0
  }
  // 表格渲染
  renderOrderList = () => {
    const { thirdParty } = this.state
    const columns = columnFun.call(this,thirdParty);
    if (this.checkAreaCode()) {
      columns.splice(
        11, 0,
        {
          title: '缴费金额（元）',
          dataIndex: 'payAmount',
          key: 'payAmount',
          render: value => value || '-'
        },
      )
    }
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="qualify_applyTrainPage"
        scroll={{ x: '2000px' }}
        dateChange={(data) => {
          this.setState({
            dataListAreaCode: data.userData ? data.userData.areaCode : '',
            isNanNiCode: data.userData? data.userData.areaCode.indexOf('4501') == 0 : false,
          })
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ padding: '0 24px' }}>
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>1、是否自然人：‘是’指通过培训学校报名的学员；“否“指服务公司报名的学员。</span>
            <br />
            <span>2、该页面展示的是所有已缴费的学员名单。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        {/* <SearchForm
          onSearch={this._search}
        /> */}
        <SearchForm
          arrange={values => {
            // values
            const { date, examDate, approveDate,confirmDate } = values;
            // 报名时间
            if (date.length == 2) {
              values.payStartDate = moment(date[0]).format(dateFormat);
              values.payEndDate = moment(date[1]).format(dateFormat);
            } else {
              values.payStartDate = '';
              values.payEndDate = '';
            }
            // 考试时间
            if (examDate.length == 2) {
              values.examStartDate = moment(examDate[0]).format(dateFormat);
              values.examEndDate = moment(examDate[1]).format(dateFormat);
            } else {
              values.examStartDate = '';
              values.examEndDate = '';
            }
            // 核对时间
            if (approveDate.length == 2) {
              values.approveStartDate = moment(approveDate[0]).format(dateFormat);
              values.approveEndDate = moment(approveDate[1]).format(dateFormat);
            } else {
              values.approveStartDate = '';
              values.approveEndDate = '';
            }
            // 确认成绩时间
            if (confirmDate.length == 2) {
              values.confirmStartDate = moment(confirmDate[0]).format(dateFormat);
              values.confirmEndDate = moment(confirmDate[1]).format(dateFormat);
            } else {
              values.confirmStartDate = '';
              values.confirmEndDate = '';
            }
            Reflect.deleteProperty(values, 'date');
            Reflect.deleteProperty(values, 'approveDate');
            Reflect.deleteProperty(values, 'confirmDate');
            return values;
          }}
        >
          <>
            <Form.Item label="关键词">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/手机号码/身份证" />
              )}
            </Form.Item>
            <Form.Item label="材料核对状态">
              {getFieldDecorator('materialApproveStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未核对</Option>
                  <Option value="1">核对通过</Option>
                  <Option value="2">核对不通过</Option>
                  {/* <Option value="4">-</Option> */}
                </Select>
              )}
            </Form.Item>
            <Form.Item label="服务公司名称">
              {getFieldDecorator('learnName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入服务公司名称" />
              )}
            </Form.Item>
            {/* <Form.Item label="背景筛查状态">
              {getFieldDecorator('backgroundStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">审核中</Option>
                  <Option value="1">正常</Option>
                  <Option value="2">关注</Option>
                  <Option value="3">申诉通过</Option>
                  <Option value="4">申诉不通过</Option>
                  <Option value="5">申诉中</Option>
                </Select>
              )}
            </Form.Item> */}

            {/* <Form.Item label="缴费状态">
              {getFieldDecorator('orderStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未缴费</Option>
                  <Option value="1">已缴费</Option>
                </Select>
              )}
            </Form.Item> */}


            <Form.Item label="缴费时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
            <Form.Item label="理论学习进度">
              {getFieldDecorator('trackLearnStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未完成</Option>
                  <Option value="1">已完成</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="是否自然人">
              {getFieldDecorator('isNaturalApply', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">否</Option>
                  <Option value="1">是</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="考试安排">
              {getFieldDecorator('examArrange', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未安排</Option>
                  <Option value="1">已安排</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="考试时间">
              {getFieldDecorator('examDate', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
            <Form.Item label="考试合格状态">
              {getFieldDecorator('testState', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">不合格</Option>
                  <Option value="1">合格</Option>
                  <Option value="2">未考试</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="核对人">
              {getFieldDecorator('approvePerKeyWord', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/身份证" />
              )}
            </Form.Item>
            <Form.Item label="核对时间">
              {getFieldDecorator('approveDate', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
            <Form.Item label="申报状态">
              {getFieldDecorator('applyStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">申报中</Option>
                  <Option value="1">申报通过</Option>
                  <Option value="2">申报不通过</Option>
                  <Option value="3">申报撤销</Option>
                </Select>
              )}
            </Form.Item>
            {
              this.checkAreaCode() && <>
                <Form.Item label="缴费金额">
                  {getFieldDecorator('payAmount', {
                    initialValue: ''
                  })(
                    <Select style={{ minWidth: 150 }} >
                      <Option value="">全部</Option>
                      <Option value="80">80元</Option>
                      <Option value="280">280元</Option>
                      <Option value="480">480元</Option>
                      <Option value="680">680元</Option>
                    </Select>
                  )}
                </Form.Item>
              </>
            }
            <Form.Item label="协会审查结果">
              {getFieldDecorator('checkStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未审核</Option>
                  <Option value="1">合格</Option>
                  <Option value="2">不合格</Option>
                  <Option value="3">已更新</Option>
                  <Option value="4">已审核</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="课程名称">
              {getFieldDecorator('trackName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入课程名称" />
              )}
            </Form.Item>
            <Form.Item label="确认成绩时间">
              {getFieldDecorator('confirmDate', {
                initialValue: []
              })(
                <RangePicker
                  format={dateFormat}
                />
              )}
            </Form.Item>
          </>
        </SearchForm>
        <Btns>
          {/* <Popover content={<div style={{padding: 10}}>搜索后可导出结果</div>}> */}
          <Button
            // disabled={!this.props.clicked}
            type="primary"
            onClick={() => {
              const { searchData } = this.props;
              let queryStr = '';
              Object.keys(searchData).forEach(key => {
                queryStr += `${key}=${searchData[key]}&`;
              });
              queryStr = '?' + queryStr.slice(0, -1);
              window.open('/bkt_api/train/qualify/apply/export/train/apply' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
            }}
          >
            导出数据
            </Button>
          {/* </Popover> */}
        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

        {
          !this.checkAreaCode() ? <SubDrawer
            personApplyId={this.state.personApplyId}
            updateTable={this.props.updateTable}
            checkBeijinCodeValue={this.checkBeijinCode()}
            setParentState={this.setState.bind(this)}
            isNanNiCode={this.state.isNanNiCode}
            checkSRAreaCode = {this.checkSRAreaCode}
            onClose={() => {
              this.setState({
                personApplyId: ''
              });
            }}
          /> : <SXSubDrawer
              personApplyId={this.state.personApplyId}
              updateTable={this.props.updateTable}
              checkAreaCodeValue={this.checkAreaCode()}
              setParentState={this.setState.bind(this)}
              onClose={() => {
                this.setState({
                  personApplyId: ''
                });
              }}
            />
        }
        {/* 修改弹窗 */}

        {/* 陕西的修改弹窗 */}

      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;