
// import { Input } from 'antd';
import { Modal} from 'antd';
import { qualify_setStudyComplete } from '../../../../../services/bkt/apis';
import $pModal from '../../../../../utils/modal/pModal';
import $nModal from '../../../../../utils/modal/nModal';
import $modal from '../../../../../utils/modal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
const { confirm } = Modal;
export default function (thirdParty) {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 60,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 100,
      fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      // render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '是否自然人',
      dataIndex: 'isNaturalApply',
      key: 'isNaturalApply',
      render: value => value == '0' ? '否' : '是'
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '申报状态',
      dataIndex: 'applyStatus',
      key: 'applyStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '申报中';
            color = warnColor;
            break;
          case value == 1:
            text = '申报通过';
            color = okColor;
            break;
          case value == 2:
            text = '申报不通过';
            color = errColor;
            break;
          case value == 3:
            text = '已撤销';
            color = errColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    // {
    //   title: '背景筛查状态',
    //   dataIndex: 'backgroundStatus',
    //   key: 'backgroundStatus',
    //   render: (value) => {
    //     let text = '-';
    //     let color = '';
    //     switch (true) {
    //       case value == 0:
    //         text = '审核中';
    //         color = warnColor;
    //         break;
    //       case value == 1:
    //         text = '正常';
    //         color = okColor;
    //         break;
    //       case value == 2:
    //         color = errColor;
    //         text = '关注';
    //         break;
    //       case value == 3:
    //         color = okColor;
    //         text = '申诉通过';
    //         break;
    //       case value == 4:
    //         color = errColor;
    //         text = '申诉不通过';
    //         break;
    //       case value == 5:
    //         color = warnColor;
    //         text = '申诉中';
    //     }
    //     return (
    //       <span style={{ color }}>{text}</span>
    //     );
    //   }
    // },
    // {
    //   title: '缴费状态',
    //   dataIndex: 'orderStatus',
    //   key: 'orderStatus',
    //   render: (value) => {
    //     let text = '未缴费';
    //     let color = '';
    //     switch (true) {
    //       case value == '0':
    //         color = errColor;
    //         text = '未缴费';
    //         break;
    //       case value == '1':
    //         color = okColor;
    //         text = '已缴费';
    //     }
    //     return (
    //       <span style={{ color }}>{text}</span>
    //     );
    //   }
    // },
    {
      title: '材料核对状态',
      dataIndex: 'materialApproveStatus',
      key: 'materialApproveStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == '0':
            text = '未核对';
            color = warnColor;
            break;
          case value == '1':
            text = '核对通过';
            color = okColor;
            break;
          case value == '2':
            text = '核对不通过';
            color = errColor;
            break;
          // case value == '4':
          //   text = '-';
          // color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '核对人',
      dataIndex: 'materialApprovePerName',
      key: 'materialApprovePerName',
      render: (value, record) => {
        let name = '-'
        if(record.materialApprovePerName){
          name = record.materialApprovePerName
          if(record.materialApprovePerIdCardNo){
            name+='('+record.materialApprovePerIdCardNo+')'
          }
        }
        return <span>{name}</span>
      }
    },
    {
      title: '核对时间',
      dataIndex: 'materialApproveDate',
      key: 'materialApproveDate',
      render: value => value || '-'
    },
    {
      title: '报名公司',
      dataIndex: 'learnName',
      key: 'learnName',
      render: value => value || '-'
    },
    {
      title: '缴费时间',
      dataIndex: 'payDate',
      key: 'payDate',
      render: value => value || '-'
    },
    {
      title: '理论学习进度',
      dataIndex: 'progress',
      key: 'progress',
      render: value => value ? `${value}%` : '-'
    },
    {
      title: '协会审查结果',
      dataIndex: 'checkStatus',
      key: 'checkStatus',
      render: (value) => {
        let text = '-';
        switch (true) {
          case value == '0':
            text = '未审核';
            break;
          case value == '1':
            text = '合格';
            break;
          case value == '2':
            text = '不合格';
            break;
          case value == '3':
            text = '已更新';
            break;
          case value == '4':
            text = '已审核';
            break;
        }
        return (
          <span>{text}</span>
        );
      }
    },
    {
      title: '考试安排',
      dataIndex: 'examArrange',
      key: 'examArrange',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == '0':
            color = warnColor;
            text = '未安排';
            break;
          case value == '1':
            color = okColor;
            text = '已安排';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '考试名称',
      dataIndex: 'examName',
      key: 'examName',
      render: value => value || '-'
    },
    {
      title: '考试时间',
      dataIndex: 'examDate',
      key: 'examDate',
      render: value => value || '-'
    },
    {
      title: '考试合格状态',
      dataIndex: 'testState',
      key: 'testState',
      render: (value) => {
        let text = '未考试';
        let color = '';
        switch (true) {
          case value == '0':
            color = warnColor;
            text = '不合格';
            break;
          case value == '1':
            color = okColor;
            text = '合格';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '理论分数',
      dataIndex: 'writtenScore',
      key: 'writtenScore',
      render: value => value || '-'
    },
    {
      title: '实操分数',
      dataIndex: 'operateScore',
      key: 'operateScore',
      render: value => value || '-'
    },
    {
      title: '课程名称',
      dataIndex: 'trackName',
      key: 'trackName',
      render: value => value || '-'
    },
    {
      title: '确认成绩时间',
      dataIndex: 'confirmDate',
      key: 'confirmDate',
      render: value => value || '-'
    },
    // {
    //   title: '考试地址',
    //   dataIndex: 'examAddress',
    //   key: 'examAddress',
    //   render: value => value || '-'
    // },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 130,
      fixed: 'right',
      render: (text, record) => {
        const { personApplyId, materialApproveStatus,fullName,progress,gid } = record;
        return (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.setState({
                  personApplyId,
                });
              }}
            >
              {materialApproveStatus == '0' ? '核对处理' : '查看'}
              {/* 查看 */}
            </span>
            {
              thirdParty && progress!=100&&(materialApproveStatus=='1' || materialApproveStatus=='4')&& gid &&<div
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                // marginRight: '20px'
              }}
              onClick={()=>{
                const _this = this
                confirm({
                  title: `是否确定修改学员：`+fullName+`的学习进度为已完成（100%）?`,
                  content: '',
                  cancelText: '取消',
                  okText: '确认',
                  onOk: () => {
                    qualify_setStudyComplete({
                      data:{
                        gid
                      }
                    }).then(res=>{
                      console.log(res)
                      _this.props.updateTable();
                    })
                  },
                  onCancel() {}
                });
              }}>
              编辑学习进度
            </div>
            }
            
          </div>
        );

      }
    }
  ];
}