
// import style from "styled-components";
import { Popover, Icon } from 'antd';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function() {
  return [
    {
      title: '实习日期',
      dataIndex: 'internDate',
      key: 'internDate',
      fixed: 'left',
      width: 120,
      render: (text) => {
        return text.split(' ')[0]
      }
    },
    {
      title: '实习单位',
      dataIndex: 'learnName',
      key: 'learnName',
    },
    {
      title: '上班打卡',
      dataIndex: 'signInDate',
      key: 'signInDate',
    },
    {
      title: '下班打卡',
      dataIndex: 'signOutDate',
      key: 'signOutDate',
    },
    {
      title: '实习时长',
      dataIndex: 'internMinute',
      key: 'internMinute',
      render: value => {
        const hours = (value / 60).toFixed(2);
        return hours;
      }
      
    },
    
    {
      title: '审核人姓名',
      dataIndex: 'approveFullName',
      key: 'approveFullName',
    },
    {
      title: '审核人身份证',
      dataIndex: 'approveIdentityNumber',
      key: 'approveIdentityNumber',
    },
    {
      title: '保安公司审核状态',
      dataIndex: 'approveStatus',
      key: 'approveStatus',
      render: (approveStatus, record) => {
        let text = '未审核';
        let color = warnColor;
        switch(true) {
          case approveStatus == '0':
            text = '未审核';
            color = warnColor;
            break;
          case approveStatus == '1':
            text = '审核通过';
            color = okColor;
            break;
          case approveStatus == '2':
            text = '审核不通过';
            color = errColor;
        }
        if(approveStatus != '2') {
          return <span style={{color}}>{text}</span>;
        }else {
          return (
            <Popover 
              // content={content}
              title={record.comments}
            >
              <span style={{color}}>{text}</span>
              <Icon type="exclamation-circle" style={{color: errColor, marginLeft: 5 }} />
            </Popover>
          );
        }
      }
    },
    {
      title: '培训机构审核状态',
      dataIndex: 'trainApproveStatus',
      key: 'trainApproveStatus',
      render: (approveStatus, record) => {
        let text = '未审核';
        let color = warnColor;
        switch(true) {
          case approveStatus == '0':
            text = '未审核';
            color = warnColor;
            break;
          case approveStatus == '1':
            text = '审核通过';
            color = okColor;
            break;
          case approveStatus == '2':
            text = '审核不通过';
            color = errColor;
            break;
        }
        if(approveStatus != '2') {
          return <span style={{color}}>{text}</span>;
        }else {
          return (
            <Popover 
              // content={content}
              title={record.comments}
            >
              <span style={{color}}>{text}</span>
              <Icon type="exclamation-circle" style={{color: errColor, marginLeft: 5 }} />
            </Popover>
          );
        }
      }
    },
    {
      title: '实习记录状态',
      dataIndex: 'lineStatus',
      key: 'lineStatus',
      render: (value) => {
        let text = '';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '审核中';
            break;
          case value == 1:
            color = okColor;
            text = '有效';
            break;
          case value == 2:
            color = errColor;
            text = '无效';
            break;
          case value == 3:
            color = errColor;
            text = '作废';
        }
        if(text) {
          return (
            <span style={{ color }}>{text}</span>
          );
        }else {
          return '-';
        }
      }
    },
    {
      title: '实习内容',
      dataIndex: 'internContent',
      key: 'internContent',
      render: text => {
        return (
          <Popover 
            title={text}
          >
            <div style={{maxWidth: '200px', overflow: 'hidden',
            textOverflow:'ellipsis',
            whiteSpace: 'nowrap'}}>{text}</div>
          </Popover>
        );
      }
    },
    {
      title: '穿戴保安服照',
      dataIndex: 'wearUrl',
      key: 'wearUrl',
      fixed: 'right',
      width: 120,
      render: value => <a href={value} target="_blank">查看</a>
    },
    {
      title: '实习地点照片',
      dataIndex: 'internAddressUrl',
      key: 'internAddressUrl',
      fixed: 'right',
      width: 120,
      render: value => <a href={value} target="_blank">查看</a>
    },
    {
      title: '实习过程照片',
      dataIndex: 'internProcessUrl',
      key: 'internProcessUrl',
      fixed: 'right',
      width: 120,
      render: value => <a href={value} target="_blank">查看</a>
    },
    {
      title: '实习过程视频',
      dataIndex: 'internProcessVideo',
      key: 'internProcessVideo',
      fixed: 'right',
      width: 120,
      render: value => <a href={value} target="_blank">查看</a>
    }
  ];
}

