import React, { Component } from 'react';
import style from "styled-components";
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import store from 'store';
import {
  Tabs,
  Alert,
  Breadcrumb,
} from 'antd';
import { Link } from 'dva/router';
import tablePage from '../../../../../utils/hoc/tablePage';
const { TabPane } = Tabs;
import { bktUrlConfig } from '../../../../../utils/config';

@connect(state => ({
  global: state.global
}))
@tablePage({ type: 'bkt' })
@withRouter
export default class PayTab extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      url: ''
    };
  }

  componentWillMount() {
    const parameter = this.props.location &&
      this.props.location.state
    if (parameter && bktUrlConfig.url && store.get('saas')['sessionId']) {
      this.setState({
        url: bktUrlConfig.url + `order?systype=saas&trackid=${parameter.trackId}&organID=${parameter.organId}&sessionId=${store.get('saas')['sessionId']}&noNeedBackTab=${true}&isNatureApply=${true}`
      })
    }
  }
  componentDidMount() {

  }


  render() {
    return (
      <Container>
        <Breadcrumb>
          <Breadcrumb.Item>
            <Link to="/Printing/SignUp">学员列表</Link>
          </Breadcrumb.Item>
          <Breadcrumb.Item>
            资格证学员报名缴费
          </Breadcrumb.Item>
        </Breadcrumb>
        <Alert
          message={<div style={{ color: '#333' }}>
            订单完成后，请回到培训管理下的订单管理页面查看具体的报名信息。
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: 15, marginTop: 10 }}
        />
        {this.state.url ? (
          <div style={{ height: "inherit", paddingBottom: 15 }}>
            <iframe
              title="资格证学员报名缴费"
              name="coursesList"
              src={this.state.url}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) : ''
        }
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;

