// 家庭成员跟工作经历的表单
import {
  Table,
  Button,
  Input,
  Form,
  Popconfirm,
  DatePicker,
  Modal
} from 'antd';
import moment from 'moment';
const dateFormat = 'YYYY-MM-DD';
import PSelect from '../../../../../components/Pro/PSelect';

export default function (type) {
  //验证手机号码
  let checkPhone = (rule, value, callback) => {
    if (value && !/^1[0-9]{10}$/.test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };
  const { getFieldDecorator } = this.props.form;
  const familyColumns = [
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name',
      width: '15%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              $handleFieldChange.call(this,
                'bayFamilyMemberDtoList',
                e.target.value,
                'name',
                record.familyMemberId,
                'familyMemberId'
              )
            }
            placeholder="请输入姓名"
            maxLength={10}
          />
        );
      }
    },
    {
      title: '成员关系',
      dataIndex: 'relation',
      key: 'relation',
      width: '15%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            // autoFocus
            onChange={e =>
              $handleFieldChange.call(this,
                'bayFamilyMemberDtoList',
                e.target.value,
                'relation',
                record.familyMemberId,
                'familyMemberId'
              )
            }
            placeholder="请输入成员关系"
            maxLength={10}
          />
        );
      }
    },
    {
      title: '证件类型',
      dataIndex: 'idCardType',
      key: 'idCardType',
      width: '15%',
      render: (text, record) => {
        return (
          <PSelect
            type="idCardType_bak"
            value={text}
            onChange={e =>
              $handleFieldChange.call(this,
                'bayFamilyMemberDtoList',
                e,
                'idCardType',
                record.familyMemberId,
                'familyMemberId'
              )
            }
          />
        );
      }
    },
    {
      title: '证件号码',
      dataIndex: 'idCardNo',
      key: 'idCardNo',
      width: '25%',
      render: (text, record) => {
        console.log(record);
        return (
          <Form.Item style={{ marginBottom: 0 }}>
            {getFieldDecorator(record.familyMemberId + 'idCardNo', {
              initialValue: text,
              rules: [
                {
                  required: false
                },
                {
                  pattern:
                    record.idCardType === '1'
                      ? /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/
                      : null,
                  message: '证件格式错误'
                }
              ]
            })(
              <Input
                value={text}
                // autoFocus
                onChange={e =>
                  $handleFieldChange.call(this,
                    'bayFamilyMemberDtoList',
                    e.target.value,
                    'idCardNo',
                    record.familyMemberId,
                    'familyMemberId'
                  )
                }
                placeholder="请输入证件号码"
                maxLength={20}
              />
            )}
          </Form.Item>
        );
      }
    },
    {
      title: '联系电话',
      dataIndex: 'contactPhone',
      key: 'contactPhone',
      width: '20%',
      render: (text, record) => {
        return (
          // <Input
          //   value={text}
          //   onChange={e => this.$handleFieldChange("bayFamilyMemberDtoList", e.target.value, 'contactPhone', record.familyMemberId, 'familyMemberId')}
          //   placeholder="请输入联系电话"
          //   maxLength={11}
          // />
          <Form.Item style={{ marginBottom: 0 }}>
            {getFieldDecorator(record.familyMemberId + 'contactPhone', {
              initialValue: text,
              rules: [
                {
                  required: false
                },
                {
                  validator: checkPhone
                }
              ]
            })(
              <Input
                // value={text}
                onChange={e =>
                  $handleFieldChange.call(this,
                    'bayFamilyMemberDtoList',
                    e.target.value,
                    'contactPhone',
                    record.familyMemberId,
                    'familyMemberId'
                  )
                }
                placeholder="请输入联系电话"
                maxLength={11}
              />
            )}
          </Form.Item>
        );
      }
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      width: '20%',
      render: (text, record) => (
        <div>
          <span
            style={{
              color: '#D9001B',
              cursor: 'pointer',
              marginRight: '20px'
            }}
          >
            <Popconfirm
              title="是否要删除此行？"
              onConfirm={e =>
                $remove.call(this,
                  'bayFamilyMemberDtoList',
                  record.familyMemberId,
                  'familyMemberId'
                )
              }
            >
              <a>删除</a>
            </Popconfirm>
          </span>
        </div>
      )
    }
  ];
  const workColumns = [
    {
      title: '公司名称',
      dataIndex: 'comName',
      key: 'comName',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              $handleFieldChange.call(this,
                'bayWorkExperienceDtoList',
                e.target.value,
                'comName',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            // onKeyPress={e => this.handleKeyPress(e, record.key)}
            placeholder="请输入公司名称"
            maxLength={40}
          />
        );
      }
    },
    {
      title: '职务',
      dataIndex: 'position',
      key: 'position',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              $handleFieldChange.call(this,
                'bayWorkExperienceDtoList',
                e.target.value,
                'position',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            placeholder="请输入职务"
            maxLength={30}
          />
        );
      }
    },
    {
      title: '工作内容',
      dataIndex: 'workContent',
      key: 'workContent',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              $handleFieldChange.call(this,
                'bayWorkExperienceDtoList',
                e.target.value,
                'workContent',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            placeholder="请输入工作内容"
            maxLength={50}
          />
        );
      }
    },
    {
      title: '入职时间',
      dataIndex: 'entryDate',
      key: 'entryDate',
      width: '17%',
      render: (text, record) => {
        return (
          <DatePicker
            disabledDate={current => {
              return current && current > moment(parseInt(sessionStorage.getItem('requestDate'))).endOf('day');
            }}
            format={dateFormat}
            defaultValue={text ? moment(text, dateFormat) : null}
            onChange={(e, date) =>
              $handleFieldChange.call(this,
                'bayWorkExperienceDtoList',
                date,
                'entryDate',
                record.workExperienceId,
                'workExperienceId'
              )
            }
          />
        );
      }
    },
    {
      title: '离职时间',
      dataIndex: 'leaveDate',
      key: 'leaveDate',
      width: '17%',
      render: (text, record) => {
        return (
          <DatePicker
            format={dateFormat}
            defaultValue={text ? moment(text, dateFormat) : null}
            onChange={(e, date) =>
              $handleFieldChange.call(this,
                'bayWorkExperienceDtoList',
                date,
                'leaveDate',
                record.workExperienceId,
                'workExperienceId',
                record.entryDate
              )
            }
          />
        );
      }
    },
    {
      title: '离职原因',
      dataIndex: 'leaveReason',
      key: 'leaveReason',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              $handleFieldChange.call(this,
                'bayWorkExperienceDtoList',
                e.target.value,
                'leaveReason',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            placeholder="请输入离职原因"
            maxLength={50}
          />
        );
      }
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      render: (text, record) => (
        <div>
          <span
            style={{
              color: '#D9001B',
              cursor: 'pointer',
              marginRight: '20px'
            }}
          >
            <Popconfirm
              title="是否要删除此行？"
              onConfirm={e =>
                $remove.call(this,
                  'bayWorkExperienceDtoList',
                  record.workExperienceId,
                  'workExperienceId'
                )
              }
            >
              <a>删除</a>
            </Popconfirm>
          </span>
        </div>
      )
    }
  ];
  return (
    <div>
      {
        type == 'family' ?
          <>
            <Table
              dataSource={this.state.bayFamilyMemberDtoList}
              columns={familyColumns}
              pagination={false}
            />
            <Button
              type="primary"
              onClick={() => {
                $add.call(this,
                  'bayFamilyMemberDtoList',
                  'familyMemberId'
                );
              }}
            >
              + 添加一条记录
            </Button>
          </> :
          <>
            <div>
              <Table
                dataSource={this.state.bayWorkExperienceDtoList}
                columns={workColumns}
                pagination={false}
              />
              <Button
                type="primary"
                onClick={() => {
                  $add.call(this,
                    'bayWorkExperienceDtoList',
                    'workExperienceId'
                  );
                }}
              >
                + 添加一条记录
            </Button>
            </div>
          </>
      }
    </div>
  )
}
function $add(param, idName) {
  const newData =
    this.state[param] && this.state[param].map(item => ({ ...item }));
  newData.push({
    [idName]: `NEW_TEMP_ID_${this[param]}`,
    name: '',
    relation: '',
    idCardType: '',
    idCardNo: null,
    contactPhone: null
  });
  this[param] += 1;
  console.log(newData)
  this.setState({ [param]: newData });
}
//删除
function $remove(param, id, idName) {
  const newData = this.state[param].filter(item => item[idName] !== id);
  this.setState({ [param]: newData });
}
function $handleFieldChange(param, e, fieldName, id, idName, entryDate) {
  if (fieldName === 'leaveDate' && entryDate) {
    if (new Date(entryDate).getTime() > new Date(e).getTime()) {
      Modal.warn({
        title: '离职时间不能大于入职时间'
      });
      return;
    }
  }
  const newData = this.state[param].map(item => ({ ...item }));
  const target = $getRowByKey.call(this, param, id, newData, idName);
  if (target) {
    target[fieldName] = e;
    this.setState({ [param]: newData });
  }
}
function $getRowByKey(param, id, newData, idName) {
  return (newData || this.state[param]).filter(
    item => item[idName] === id
  )[0];
}
