/* 
*visible 显示
*gradeClassId 当前所在id
 */
import React, { Component } from "react";
import SearchForm from './SearchForm';
import st from 'styled-components';
import store from 'store';
import {
  Modal,
  Button,
  Form,
  Input,
  Upload,
  message,
  Alert,
  Icon
} from "antd";
import BTable from '../../../../../components/Pro/BTable';
import columnFun from './columns';
import $modal from '../../../../../utils/modal';
// import $nModal from '../../../../../utils/modal/nModal';
import $loading from '../../../../../utils/loading';
import { trainGradeClassPersonBatchDelete, trainGradeClassPersonNotifyGraduate, trainGradeClassPersonNotifyIdentify, trainGradeClassPersonConfirmScore, trainGradeClassPersonUpdateScore, trainGradeClassPersonNotifyOpen, trainGradeClassInfo, trainGradeClassUploadPracticeMaterial, trainExportClassAddTemplate, trainGradeCreateClass } from '../../../../../services/bkt/apis';
import { publicCommonFileUploadFile } from '../../../../../services/api';
import SelectStudents from '../SelectStudents';
import moment from "moment";
import { connect } from 'dva';
import { withRouter } from 'dva/router';
const formItemLayout = {
  labelCol: {
    span: 6
  },
  wrapperCol: {
    span: 14
  },
  labelAlign: 'right'
};
@connect(state => ({
  global: state.global
}))
@Form.create()
@withRouter
export default class Turnover extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      preVisible: false,  //之前的显示状态
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: '10',
        pageNumber: '1',
      },
      confirmScore: false,  //确认成绩是否提交成功  状态会改成结束，按钮要禁用
      btnDisable: true, //通过审核状态判断按钮是否禁用
      searchDataReady: false, //筛选参数是否准备就绪
      gradeClassIdReady: false, //id是否准备就绪
      selectedRowKeys: [], //选中项
      selectedRowRows: [],
      achiVisible: false,  //成绩导入模态框的显示

      selectStudentsShow: false, //选择人员弹窗
      currentPernson: null, //当前编辑的人(null不展示编辑模态框)
      failData: '', //上传文件失败返回的数据(链接)

      practiceUrlModal: false,
      practiceSignUrlList: [], //实操培训签到表
      policeCheckUrlList: [], //公安检查表
    };
  }
  componentDidMount() {

  }
  componentWillReceiveProps(nextProps) {
    const { gradeClassId, visible } = nextProps;
    const { preVisible } = this.state;
    if (!!gradeClassId) {
      this.setState({
        pageParm: {
          ...this.state.pageParm,
          gradeClassId
        },
        gradeClassIdReady: true
      }, () => {
        if (!this.state.gradeClassIdReady) {
          this._getClassInfo();
        }
      });
    } else {
      this.setState({
        gradeClassIdReady: false
      });
    }
    /**重新打开弹窗时候刷新列表start */
    this.setState({
      preVisible: visible
    });
    if (visible && !preVisible) {
      this._updateTable();
    }
    /**重新打开弹窗时候刷新列表end */

  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      searchDataReady: true
    });
  }
  _updateTable = (refreshParent = false) => {
    this.setState({
      forceUpdate: true,
      confirmScore: false
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
    // refreshParent && this.props.setParentState && this.props.setParentState({ forceUpdate: true }, () => {
    //   this.props.setParentState({
    //     forceUpdate: false
    //   });
    // });
  }
  _getClassInfo = () => {
    const { gradeClassId } = this.props;
    trainGradeClassInfo({ data: { gradeClassId } }).then(res => {
      const {
        practiceSignUrl, //实操签到表链接
        policeCheckUrl  //公安检查表
      } = res.data;
      const practiceSignUrlList = practiceSignUrl ? [{
        uid: moment().valueOf(),
        name: '实操培训签到表' + practiceSignUrl.replace(/(.*)(\..*$)/, '$2'),
        status: 'done',
        url: practiceSignUrl,
      }] : [];
      const policeCheckUrlList = policeCheckUrl ? [{
        uid: moment().valueOf(),
        name: '公安检查表' + policeCheckUrl.replace(/(.*)(\..*$)/, '$2'),
        status: 'done',
        url: policeCheckUrl,
      }] : [];
      this.setState({ practiceSignUrlList, policeCheckUrlList });
    });
  }

  // 上传实操培训材料内容
  _renderPracticeUrlContent = () => {
    const { practiceSignUrlList, policeCheckUrlList } = this.state;
    return (
      <Material>
        <div>
        <Alert
          message={<div style={{ color: '#333'}}>
            温馨提示：如果有多个图片，请将图片放在word中再上传。
          </div>}
          type="warning"
          showIcon
          style={{marginTop:'-10px',marginBottom:'15px'}}
        />
          <span>实操培训签到表：</span>
          <Upload
            showUploadList={true}
            fileList={practiceSignUrlList}
            onChange={info => {
              const file = info.file;
              if (!(file.name + '').toLocaleLowerCase().match(/(\.doc)|(\.docx)|(\.pdf)|(\.jpg)|(\.jpeg)|(\.png)/)) {
                message.error('请上传拓展名为.doc\.docx\.pdf\.jpg\.jpeg\.png文件!');
                return;
              }
              $loading.open('正在导入数据，请稍后...');
              const formData = new FormData();
              formData.append('xfile', file.originFileObj);
              publicCommonFileUploadFile(formData, false).then(res => {
                $loading.close();
                file.url = res.data;
                file.status = 'done';
                this.setState({ practiceSignUrlList: [file] });
              }).catch(ex => {
                console.log(ex);
                $loading.close();
              });
            }}
            onRemove={() => {
              this.setState({ practiceSignUrlList: [] });
            }}
          >
            <Button style={{ marginLeft: 10 }} ><Icon type="upload" />上传文件</Button><span style={{ marginLeft: 10 }}>支持拓展名：.doc\.docx\.pdf\.jpg\.jpeg\.png</span>
          </Upload>
        </div>
        <div>
          <span>公安督导检查表：</span>
          <Upload
            showUploadList={true}
            fileList={policeCheckUrlList}
            onChange={info => {
              const file = info.file;
              if (!(file.name + '').toLocaleLowerCase().match(/(\.doc)|(\.docx)|(\.pdf)|(\.jpg)|(\.jpeg)|(\.png)/)) {
                message.error('请上传拓展名为.doc\.docx\.pdf\.jpg\.jpeg\.png文件!');
                return;
              }
              $loading.open('正在导入数据，请稍后...');
              const formData = new FormData();
              formData.append('xfile', file.originFileObj);
              publicCommonFileUploadFile(formData, false).then(res => {
                $loading.close();
                file.url = res.data;
                file.status = 'done';
                this.setState({ policeCheckUrlList: [file] });
              }).catch(ex => {
                console.log(ex);
                $loading.close();
              });
            }}
            onRemove={() => {
              this.setState({ policeCheckUrlList: [] });
            }}
          >
            <Button style={{ marginLeft: 10 }} ><Icon type="upload" />上传文件</Button><span style={{ marginLeft: 10 }}>支持拓展名：.doc\.docx\.pdf\.jpg\.jpeg\.png</span>
          </Upload>
        </div>
      </Material>
    );
  }
  _renderEditModal = () => {
    const { currentPernson } = this.state;
    if (!currentPernson) {
      return '';
    }
    const { getFieldDecorator } = this.props.form;
    const inputValidator = (rule, value, callback) => {
      if (!/(^[0-9]$)|(^[1-9][0-9]$)|(^100$)/.test(value) && value !== '') {
        return callback('请输入0~100整数或者置空');
      }
      callback();
    }

    const { graduateComputerScore, graduatePracticeScore, identifyComputerScore, identifyPracticeScore, gradeClassId, gradeClassPersonId } = currentPernson;
    return (
      <Modal
        title={currentPernson.fullName + '-编辑'}
        width={520}
        visible={!!currentPernson}
        onCancel={() => {
          this.setState({
            currentPernson: null
          });
        }}
        onOk={() => {
          this.props.form.validateFields((err, values) => {
            trainGradeClassPersonUpdateScore({ data: { ...values, gradeClassId, gradeClassPersonId } }).then(() => {
              this._updateTable(true);
              $modal('操作成功！', '', null, 'success');
              this.setState({
                currentPernson: null
              });
            });
          });
        }}
        okText={'确定'}
        cancelText={'取消'}
      >
        <span style={{ color: '#F59A23', marginBottom: 15, display: 'block' }}>温馨提示：若留空，则为未考试；若要记0分，请输入“0”。</span>
        <Form layout="horizontal">
          <Form.Item {...formItemLayout} label="结业-理论成绩">
            {getFieldDecorator('graduateComputerScore', {
              initialValue: graduateComputerScore,
              rules: [{ validator: inputValidator }],
            })(<Input placeholder="请输入结业-理论成绩" />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="结业-实操成绩">
            {getFieldDecorator('graduatePracticeScore', {
              initialValue: graduatePracticeScore,
              rules: [{ validator: inputValidator }],
            })(<Input placeholder="请输入结业-实操成绩" />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="鉴定-理论成绩">
            {getFieldDecorator('identifyComputerScore', {
              initialValue: identifyComputerScore,
              rules: [{ validator: inputValidator }],
            })(<Input disabled={
              identifyComputerScore != 0 && !identifyComputerScore
            } placeholder="请输入鉴定-理论成绩" />)}
          </Form.Item>
          <Form.Item {...formItemLayout} label="鉴定-实操成绩">
            {getFieldDecorator('identifyPracticeScore', {
              initialValue: identifyPracticeScore,
              rules: [{ validator: inputValidator }],
            })(<Input disabled={
              identifyPracticeScore != 0 && !identifyPracticeScore
            } placeholder="请输入鉴定-实操成绩" />)}
          </Form.Item>
        </Form>
      </Modal>
    );
  }

  render() {
    const columns = columnFun.call(this);
    const disabled = this.props.classStatus == 0 || this.props.scoreState == '1' || this.state.confirmScore;
    return (
      <Modal
        title="班级成员"
        width={1250}
        visible={this.props.visible}
        onCancel={() => {
          this.setState({
            selectedRowKeys: [],
            selectedRowRows: [],
          });
          this.props.setParentState && this.props.setParentState({ forceUpdate: true,classPersonsShow: false }, () => {
            this.props.setParentState({
              forceUpdate: false
            });
          });
          // this.props.setParentState && this.props.setParentState({ classPersonsShow: false });
        }}
        footer={null}
      >
        <Alert
          message={<div style={{ color: '#333' }}>
            {
              this.props.fromType == 'new' || this.props.classStatus == '4'? <>
                操作流程：新建班级→完善班级信息→添加人员或批量导入人员→提交班级申请<br />
              注意：您可以通过添加人员或批量导入人员功能将班级成员添加进来，如果多选或选错人员，可选择人员后点击【批量移除人员】将人员移除。
              </> : <>
                  操作流程：确定班级成员→发布培训结业考试通知→发布鉴定考试通知→录入成绩→确认成绩。<br />
              结业考试：App考试时，成绩自动录入；线下纸质考试，则需要自行录入；<br />
              鉴定考试：请从鉴定所系统到处成绩后，再导入到系统，
              </>
            }
          </div>}
          type="warning"
          showIcon
        />
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        />
        <Btns>
          {
            // 审核不通过、已取消、已结束
            // 不让移除不让新增
            this.props.classStatus!=='2' && this.props.classStatus!=='3' && this.props.classStatus!=='9'&&
            <>
              <Button
              disabled={disabled}
              onClick={() => {
                this.setState({
                  selectStudentsShow: true
                });
                // this.props.setParentState && this.props.setParentState({
                //   preModal: 'classPersonsShow',
                //   selectStudentsShow: true,  //显示选择人员弹窗
                //   classPersonsShow: false  //关闭当前弹窗
                // });
              }}
              type="primary">
              添加人员
            </Button>
              <Button
                disabled={disabled || this.state.selectedRowKeys.length == 0}
                type="danger"
                onClick={() => {

                  $modal('即将移除班级人员，是否继续？', <span style={{ color: 'D9001B' }}>人员删除后，可被安排到其他班级；报名单位可撤销报名；系统将向其发送取消安排通知。</span>, [
                    {
                      text: '继续',
                      type: 'primary',
                      onPress: () => {
                        const { gradeClassId } = this.props;
                        const { selectedRowRows } = this.state;
                        const ids = selectedRowRows.reduce((a, b) => `${a}${b.gradeClassPersonId},`, '').slice(0, -1);
                        trainGradeClassPersonBatchDelete({ data: { ids, gradeClassId } }).then(res => {
                          this._updateTable(true);
                          $modal('人员移除成功！', '', null, 'success');
                          this.setState({
                            selectedRowKeys: [],
                            selectedRowRows: []
                          });
                        });
                      }
                    },
                    {
                      text: '取消'
                    }
                  ]);
                }}>
                批量移除人员
              </Button>
            </>
          }
          
          {/* 新建班级里的班级成员的流程 */}
          {
            this.props.fromType != 'new' &&this.props.classStatus!='4'&&
            <>
              <Button type="primary"
                disabled={disabled}
                onClick={() => {
                  $modal(
                    '即将向未通知实操培训的人员发送通知，是否继续？',
                    '',
                    [
                      {
                        text: '继续',
                        type: 'primary',
                        onPress: () => {
                          const { gradeClassId } = this.props;
                          trainGradeClassPersonNotifyOpen({ data: { gradeClassId } }).then(() => {
                            this._updateTable();
                            $modal('实操培训通知发送成功！', '', null, 'success');
                          });
                        }
                      },
                      {
                        text: '取消'
                      }
                    ]);
                }}
              >
                发布实操培训通知
              </Button>
              <Button type="primary"
                disabled={disabled}
                onClick={() => {
                  $modal(
                    '即将向未通知结业考试的人员发送通知，是否继续？',
                    '',
                    [
                      {
                        text: '继续',
                        type: 'primary',
                        onPress: () => {
                          const { gradeClassId } = this.props;
                          trainGradeClassPersonNotifyGraduate({ data: { gradeClassId } }).then(() => {
                            this._updateTable();
                            $modal('结业考试通知发送成功！', '', null, 'success');
                          });
                        }
                      },
                      {
                        text: '取消'
                      }
                    ]);
                }}
              >
                发布结业考试通知
              </Button>
              <Button type="primary"
                disabled={disabled}
                onClick={() => {
                  $modal('即将向未通知鉴定考试的人员发送通知，是否继续？', '',
                    [
                      {
                        text: '继续',
                        type: 'primary',
                        onPress: () => {
                          const { gradeClassId } = this.props;
                          trainGradeClassPersonNotifyIdentify({ data: { gradeClassId } }).then(() => {
                            this._updateTable();
                            $modal('鉴定考试通知发送成功！', '', null, 'success');
                          });
                        }
                      },
                      {
                        text: '取消'
                      }
                    ]);
                }}
              >
                发布鉴定考试通知
              </Button>
              <Button
                disabled={disabled}
                onClick={() => {
                  this.setState({
                    achiVisible: true
                  });
                }}
                type="primary">
                录入成绩
              </Button>
              <Button
                disabled={disabled}
                onClick={() => {
                  $modal('即将确认成绩，是否继续？', <span style={{ color: 'D9001B' }}>成绩确认后将同步成绩给到公安系统，无法撤销。</span>, [
                    {
                      text: '继续',
                      type: 'primary',
                      onPress: () => {
                        const { gradeClassId } = this.props;
                        trainGradeClassPersonConfirmScore({ data: { gradeClassId } }).then(() => {
                          this._updateTable(true);
                          this.setState({
                            confirmScore: true
                          });
                          $modal('操作成功', '', null, 'success');
                        });
                      }
                    },
                    {
                      text: '取消'
                    }
                  ]);
                }}
                type="primary">
                确认成绩
              </Button>
              <Button
                disabled={disabled}
                onClick={() => {
                  this.setState({ practiceUrlModal: true });
                }}
                type="primary">
                上传实操培训材料
              </Button>
              <Button
                disabled={disabled}
                onClick={() => {
                  const { gradeClassId } = this.props;
                  window.open(`/bkt_api/train/grade/class/person/export/avatar?gradeClassId=${gradeClassId}`, '_blank');
                }}
                type="primary">
                导出学员照片
              </Button>
              <Button
                disabled={disabled}
                onClick={() => {
                  const { gradeClassId } = this.props;
                  window.open(`/bkt_api/train/grade/class/person/export/identityNumber?gradeClassId=${gradeClassId}`, '_blank');
                }}
                type="primary">
                导出学员身份证
              </Button>
            </>
          }
          {/* 查看班级成员的流程 */}
          {
            this.props.fromType=='new'||this.props.classStatus=='4'?
            <>
              <Button
                onClick={() => {
                  this.setState({
                    batchImpPersonnelStatus: true
                  })
                }}
                type="primary">
                批量导入人员
              </Button>
              <Button
                onClick={() => {
                  $modal(
                    '即将提交开班信息给到公安系统审核，是否继续？',
                    <span style={{ color: 'D9001B' }}>开班申请审核通过后，才可进行考试安排，预计48小时内完成审核，请注意考试时间安排。</span>,
                    [
                      {
                        text: '继续',
                        type: 'primary',
                        onPress: () => {
                          if (this.state.tableDataList && this.state.tableDataList.length > 0) {
                            trainGradeCreateClass({
                              data: {
                                createClassType: '0',
                                personApplyIdList: this.state.tableDataList,
                                gradeClassId: this.props.gradeClassId
                              }
                            }).then(res => {
                              if (res.retType == '0') {
                                //关闭班级成员弹窗
                                this.setState({
                                  selectedRowKeys: [],
                                  selectedRowRows: [],
                                });
                                this.props._updateTable()
                                this.props.setParentState && this.props.setParentState({ classPersonsShow: false });
                              }
                            })
                          } else {
                            return message.warning("请先选择班级成员")
                          }
                        }
                      },
                      {
                        text: '取消'
                      }
                    ]
                  );
                }}
                type="primary">
                提交班级申请
              </Button>
            </>:''
          }
        </Btns>

        {
          this.state.searchDataReady && this.state.gradeClassIdReady &&
          <BTable
            style={{ marginTop: 20 }}
            columns={columns}
            dataSetKey='gradeClassPersonId'
            url="trainGradeClassPersonPage"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{
              showTotal: total => `总共 ${total} 条`,
              pageSizeOptions: ["10", "20", "40", "100", "500"],
            }}
            scroll={{ x: '200%' }}
            rowSelection={{
              selectedRowKeys: this.state.selectedRowKeys,
              onChange: (selectedRowKeys) => {
                // console.log(selectedRowRows)
                this.setState({
                  selectedRowKeys
                  // , selectedRowRows
                });
              },
              onSelect: (record, selected, selectedRows) => {
                const selectId = JSON.parse(JSON.stringify(this.state.selectedRowKeys));
                const selectedRowRows = JSON.parse(JSON.stringify(this.state.selectedRowRows));
                if (selected === true) {
                  selectId.push(record.gradeClassPersonId);
                  selectedRowRows.push(record);
                } else {
                  for (let i = 0; i < selectId.length; i++) {
                    if (selectId[i] === record.gradeClassPersonId) {
                      selectId.splice(i, 1);
                      selectedRowRows.splice(i, 1);
                      break;
                    }
                  }
                }
                this.setState({
                  selectedRowKeys: selectId,
                  selectedRowRows
                });
              },
              onSelectAll: (selected, selectedRows) => {
                // console.log(selected)
                // let selectId = [];
                let selectId = JSON.parse(JSON.stringify(this.state.selectedRowKeys));
                let selectedRowRows = JSON.parse(JSON.stringify(this.state.selectedRowRows));
                if (selected === true) {
                  for (let i = 0; i < selectedRows.length; i++) {
                    //不存在的话就添加
                    if (selectId.indexOf(selectedRows[i].gradeClassPersonId) < 0) {
                      selectId.push(selectedRows[i].gradeClassPersonId);
                      selectedRowRows.push(selectedRows[i]);
                    }
                  }
                } else {
                  // for (let i = 0; i < selectedRows.length; i++) {
                  //   //如果存在就删除
                  //   const indexOfValue =selectId.indexOf(selectedRows[i].gradeClassPersonId);
                  //   if(indexOfValue>-1){
                  //     selectId.splice(indexOfValue, 1);
                  //     selectedRowRows.splice(indexOfValue, 1);
                  //   }
                  // }
                  selectId = [];
                  selectedRowRows = []
                }
                this.setState({
                  selectedRowKeys: selectId,
                  selectedRowRows
                });
              }
            }}
            dateChange={(dataList) => {
              let tableDataList = dataList.data.map(value => {
                return value.personApplyId
              })
              this.setState({
                tableDataList,
                organId:dataList.userData.organId
              })
            }}
          />
        }

        {
          // 编辑模态框
          this._renderEditModal()
        }


        {/* 选择人员 */}
        <SelectStudents
          gradeClassId={this.props.gradeClassId}
          visible={this.state.selectStudentsShow}
          setParentState={this.setState.bind(this)}
          onOk={() => {
            this._updateTable(true);
          }}
        />

        <Modal
          title="成绩导入"
          width={520}
          visible={this.state.achiVisible}
          onCancel={() => {
            this.setState({
              achiVisible: false
            });
          }}
          onOk={() => {
            this.setState({
              achiVisible: false
            });
          }}
          cancelButtonProps={{ display: 'none' }}
          okText={'关闭'}
        >
          <div>
            1、下载人员信息
              <Button
              style={{ marginLeft: 10 }}
              type="primary"
              onClick={() => {
                const { gradeClassId } = this.props;
                window.open(`/bkt_api/train/grade/class/person/export/template?gradeClassId=${gradeClassId}`, "_blank");
              }}
            >下载</Button>
          </div>
          <p>根据模板要求下载人员列表，并上传</p>
          <div>
            2、上传文件
            <Upload
              name="xfile"
              action={`/bkt_api/train/grade/class/person/import/template`}
              headers={
                {
                  authorization: 'Basic c2Fhc3dlYjp3ZWI=',
                  access_token: store.get('saas')['access_token'],
        Accesstoken: store.get('saas')['access_token']|| sessionStorage.userV5Token,

                  sessionId: store.get('saas')['sessionId']
                }
              }
              showUploadList={false}
              data={{
                data: JSON.stringify({ gradeClassId: this.props.gradeClassId })
              }}
              onChange={info => {
                // $loading.open('正在导入数据，请稍后...');
                if (info.file.status === 'uploading') {
                  return;
                }
                if (info.file.status === 'done') {
                  $loading.close();
                  const { data, msg, retType } = info.file.response;
                  //"retType":"-1"为错误，data会有相应的路径值
                  //"retType":"0"为正确，data为空
                  if (retType === '-1') {
                    message.error(msg);
                    this.setState({
                      failData: data
                    });
                  } else if (retType === '0') {
                    this._updateTable(true);
                    message.success(msg);
                    this.setState({
                      failData: data
                    });
                  } else {
                    message.error(msg);
                  }
                } else if (info.file.status === 'error') {
                  $loading.close();
                }
              }}
              beforeUpload={file => {
                $loading.open('正在导入数据，请稍后...');
                let ifError = true;
                if (file.name.indexOf('xls') === -1 && file.name.indexOf('xlsx') === -1) {
                  $loading.close();
                  message.error('请上传xls或xlsx文件!');
                  ifError = false;
                }
                return ifError;
              }}
            >
              <Button style={{ marginLeft: 10 }} type="primary">选择上传文件</Button>
            </Upload>
            <div style={{ display: !this.state.failData ? 'none' : 'block' }}>
              导入失败信息表：
              <a
                type="primary"
                href={this.state.failData}
                style={{ color: 'red', textDecoration: 'underline' }}
              // onClick={() => {

              // }}
              >
                点击下载
              </a>
            </div>
          </div>
        </Modal>

        {/* // 上传实操培训材料 */}
        <Modal
          visible={this.state.practiceUrlModal}
          title="上传实操培训材料"
          width={610}
          okText="确定"
          cancelText="取消"
          destroyOnClose={true}
          onOk={() => {
            const { gradeClassId } = this.props;
            let practiceSignUrl = this.state.practiceSignUrlList[0] ? this.state.practiceSignUrlList[0].url : '';
            let policeCheckUrl = this.state.policeCheckUrlList[0] ? this.state.policeCheckUrlList[0].url : '';
            trainGradeClassUploadPracticeMaterial({ data: { gradeClassId, practiceSignUrl, policeCheckUrl } }).then(res => {
              $modal(res.msg, '', null, 'success');
              this.setState({ practiceUrlModal: false });
            });
          }}
          onCancel={() => this.setState({ practiceUrlModal: false })}
        >
          {this._renderPracticeUrlContent()}
        </Modal>

        {/* 批量导入人员 */}
        <Modal
          title="批量导入人员"
          width={520}
          visible={this.state.batchImpPersonnelStatus}
          onCancel={() => {
            this.setState({
              batchImpPersonnelStatus: false
            });
          }}
          onOk={() => {
            this.setState({
              batchImpPersonnelStatus: false
            });
          }}
          cancelButtonProps={{ display: 'none' }}
          footer={[
            <Button
              key="submit"
              type="primary"
              onClick={() => {
                this.setState({
                  batchImpPersonnelStatus: false
                });
              }}
            >
              知道了
            </Button>
          ]}
        >
          <div>
            1、下载模板：
              <Button
              style={{ marginLeft: 10 }}
              type="primary"
              onClick={() => {
                // const { gradeClassId } = this.props;
                if (this.state.exportTemplateUrl) {
                  window.open(this.state.exportTemplateUrl, "_blank");
                } else {
                  trainExportClassAddTemplate().then(res => {
                    if (res.retType == '0') {
                      window.open(res.data, "_blank");
                      this.setState({
                        exportTemplateUrl: res.data
                      })
                    }
                  })
                }
              }}
            >点击下载导入人员模板</Button>
          </div>
          <div>
            2、上传文件
            <Upload
              name="file"
              action={`/bkt_api/train/grade/class/person/batchAdd`}
              headers={
                {
                  authorization: 'Basic c2Fhc3dlYjp3ZWI=',
                  access_token: store.get('saas')['access_token'],
                  sessionId: store.get('saas')['sessionId']
                }
              }
              showUploadList={false}
              data={{
                data: JSON.stringify({ gradeClassId: this.props.gradeClassId,organId:this.state.organId })
              }}
              onChange={info => {
                // $loading.open('正在导入数据，请稍后...');
                if (info.file.status === 'uploading') {
                  return;
                }
                if (info.file.status === 'done') {
                  $loading.close();
                  const { data, msg, retType } = info.file.response;
                  //"retType":"-1"为错误，data会有相应的路径值
                  //"retType":"0"为正确，data为空
                  if (retType === '-1') {
                    message.error(msg);
                  } else if (retType === '0') {
                    this._updateTable(true);
                    message.success(msg);
                    this.setState({
                      failData: data
                    });
                  } else {
                    message.error(msg);
                  }
                } else if (info.file.status === 'error') {
                  $loading.close();
                }
              }}
              beforeUpload={file => {
                $loading.open('正在导入数据，请稍后...');
                let ifError = true;
                if (file.name.indexOf('xls') === -1 && file.name.indexOf('xlsx') === -1) {
                  $loading.close();
                  message.error('请上传xls或xlsx文件!');
                  ifError = false;
                }
                return ifError;
              }}
            >
              <Button style={{ marginLeft: 10 }} type="primary">选择上传文件</Button>
              {
                this.state.failData && <>已导入{this.state.failData.successNum}人</>
              }
            </Upload>
            {
              this.state.failData&&<div>
                导入{this.state.failData.successNum + this.state.failData.errorNum}人，{this.state.failData.successNum}人导入成功，{this.state.failData.errorNum}人导入失败。
                {
                  this.state.failData.errorNum > 0 && <>
                    <span>请下载失败文件，调整人员后可重新按模板导入。</span>
                    <a
                      type="primary"
                      href={this.state.failData.downLoadPath}
                      style={{ color: 'red', textDecoration: 'underline' }}
                    >
                      下载导入失败文件
                </a>
                  </>
                }
              </div>
            }
          </div>
        </Modal>
      </Modal>
    );
  }
}

const Btns = st.div`
  >button{
    margin-right: 15px;
    margin-top: 15px;
  }
`;
const Material = st.div`
  >div{
    margin-top: 20px;
    &:first-child{
      margin-top: 0;
    }
  }
`;
