import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select,
  DatePicker
} from "antd";
const { Option } = Select;
const { RangePicker } = DatePicker;
const dateFomate = 'YYYY-MM-DD';
@Form.create()
export default class Messages extends Component {
  constructor(props) {
    super(props);
    this.state = {
    }
  }
  componentDidMount() {
    this._search();
  }

  _search = (e) => {
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        if(values.applyDate.length == 0) {
          values.applyStartDate = '';
          values.applyEndDate = '';
        }else {
          values.applyStartDate = values.applyDate[0].format(dateFomate);
          values.applyEndDate = values.applyDate[1].format(dateFomate);
        }
        Reflect.deleteProperty(values, 'applyDate');
        values.pageNumber = 1;
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this._search();
    // const data = this.props.form.getFieldsValue();
    // this.props.onSearch(data);
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}> 
        <Form.Item style={{marginTop: 10}} label="关键词">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input placeholder="请输入学员名称/身份证/手机号码" />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="报名保安公司">
          {getFieldDecorator('learnName', {
            initialValue: ''
          })(
            <Input placeholder="请输入报名保安公司" />
          )}
        </Form.Item>
        
        <Form.Item style={{marginTop: 10}} label="缴费时间">
          {getFieldDecorator('applyDate', {
            initialValue: []
          })(
            <RangePicker
              disabledDate={current => {
                // return current > moment().endOf('day')
                // return current && current > moment().endOf('day')
              }}
              // disabledTime={}
              format="YYYY-MM-DD"
            />
          )}
        </Form.Item>
        {/* btns */}
        <Form.Item style={{marginTop: 10}} label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}
