import React, { Component } from "react";
import SearchForm from './SearchForm';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Alert,
  Tabs,
  Button
} from "antd";
import BTable from '../../../../components/Pro/BTable';
import columnFun from './columns';
import ClassInfo from './ClassInfo';
import Turnover from './Turnover';
// import SelectStudents from './SelectStudents';
const { TabPane } = Tabs;
@connect(state => ({
  global: state.global
}))
@withRouter
export default class NotInput extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: '10',
        pageNumber: '1',
      },
      searchDataReady: false, //筛选参数是否准备就绪
      gradeClassId: '',  //当前选中的班级id
      classInfoShow: false,  //是否展示班级详情或者新建班级弹窗
      selectStudentsShow: false,  //是否展示选择人员弹窗弹窗
      classPersonsShow: false,  //是否显示班级成员弹窗
      preModal: '', //上次关闭的模态框字段
      classStatus: '',   //查看班级成员的时候当前班级的审核状态
    };
  }
  componentDidMount() {

  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      }
    }, () => {
      this.setState({
        searchDataReady: true
      })
    });
  }
  _showClassInfo = (gradeClassId, classStatus) => {
    this.setState({
      gradeClassId,
      classStatus
    }, () => {
      this.setState({
        classInfoShow: true
      });
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  _setParentState = (obj = {}, cb) => {
    this.setState(obj);
    setTimeout(() => {
      cb && cb();
    });
  }
  render() {
    const columns = columnFun.call(this);
    return (
      <div style={{ padding: 15 }}>
        <Tabs>
          <TabPane tab="等级证开班管理" key="1" />
        </Tabs>
        <Alert
          message={<div>班级申请：创建班级并选择人员之后，需经公安系统审核，才可进行下一步操作；班级审核通过，可重新更新班级信息及班级成员管理。</div>}
          type="warning"
          showIcon
        />
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        />
        <Button
          type="primary"
          style={{ marginTop: 15 }}
          onClick={() => {
            this._showClassInfo('', '');
            // this.props.history.push('/TrainingInstitutionsCertificationManage/open-classes/add');
          }}
        >
          新建班级
        </Button>
        {
          this.state.searchDataReady &&
          <BTable
            style={{ marginTop: 20 }}
            columns={columns}
            url="trainGradeClassTrainPage"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{
              showTotal: total => `总共 ${total} 条`
            }}
            scroll={{ x: '3000px' }}
            dateChange={() => { }}
          />
        }

        {/* 班级信息(新增|查看) */}
        <ClassInfo
          classStatus={this.state.classStatus}
          visible={this.state.classInfoShow}
          gradeClassId={this.state.gradeClassId}
          setParentState={this._setParentState}
          _updateTable={this._updateTable}
        />

        {/* 选择学员 */}
        {/* <SelectStudents
          gradeClassId={this.state.gradeClassId}
          visible={this.state.selectStudentsShow}
          setParentState={this._setParentState}
          preModal={this.state.preModal}  //在ClassInfo和Turnover组件中都有选择人员的选项，两个组件中都有设置preModal，来确定是返回哪个弹窗
        /> */}

        {/* 班级成员 */}
        <Turnover
          classStatus={this.state.classStatus}
          scoreState={this.state.scoreState}
          gradeClassId={this.state.gradeClassId}
          visible={this.state.classPersonsShow}
          setParentState={this._setParentState}
          _updateTable={this._updateTable}
        />


      </div>
    );
  }
}
