/* 
*visible
*onClose
*classId
 */

import React, { Component } from "react";
import st from "styled-components";
import { trainGradeCreateClass, trainQuestionTestpaperList } from '../../../../../services/bkt/apis';
import {
  // Drawer,
  Input,
  Row,
  Col,
  Button,
  Form,
  DatePicker,
  // Modal,
  Breadcrumb,
  Select
} from "antd";
const { RangePicker } = DatePicker;
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props) {
    super(props);
    this.state = {
      outFormData: {
        graduateComputerScoreLimit: '',
        graduatePracticeScoreLimit: '',
        identityComputerScoreLimit: '',
        identityPracticeScoreLimit: '',
      },
      licked: false, //用户是否点击过下一步，如果有，开始校验字段
      pegers: [], //试卷（下拉列表）
    }
  }
  componentDidMount() {
    this.__getExamsPapers();
  }
  __getExamsPapers = () => {
    trainQuestionTestpaperList({data: {}}).then(res => {
      this.setState({
        pegers: res.data
      });
    })
  }
  _submitData = () => {
    this.setState({
      licked: true
    });
    this.props.form.validateFields((err, values) => {
      const { outFormData } = this.state;
      const outFormDataHasEmpty = Object.keys(outFormData).some(key => outFormData[key] == '');
      // 存在空值
      if(outFormDataHasEmpty) {
        return;
      }
      if (!err) {
        // 结业理论考试时间
        values.graduateComputerStartDate = values.graduateComputerDate[0];
        values.graduateComputerEndDate = values.graduateComputerDate[1];
        Reflect.deleteProperty(values, 'graduateComputerDate');
        // 结业实操考试时间
        values.graduatePracticeStartDate = values.graduatePracticeDate[0];
        values.graduatePracticeEndDate = values.graduatePracticeDate[1];
        Reflect.deleteProperty(values, 'graduatePracticeDate');
        // 鉴定理论考试时间
        values.identifyComputerStartDate = values.identifyComputerDate[0];
        values.identifyComputerEndDate = values.identifyComputerDate[1];
        Reflect.deleteProperty(values, 'identifyComputerDate');
        // 鉴定实操考试时间
        values.identifyPracticeStartDate = values.identifyPracticeDate[0];
        values.identifyPracticeEndDate = values.identifyPracticeDate[1];
        Reflect.deleteProperty(values, 'identifyPracticeDate');

        values = {
          ...values,
          ...outFormData
        }
        trainGradeCreateClass({data: values}).then(res => {
          this.props.onClose && this.props.onClose();
        });
      }
    });
  }
  _setOutField = (key, value) => {
    this.setState({
      outFormData: {
        ...this.state.outFormData,
        [key]: value
      }
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const {
      visible,
      onClose,
      classId,
    } = this.props;
    const { outFormData } = this.state;
    const formItemLayout = {
      labelCol: {
        span: 10
      },
      wrapperCol: {
        span: 14
      },
      labelAlign: 'right'
    };
    const formItemLayout1 = {
      labelCol: {
        span: 5
      },
      wrapperCol: {
        span: 19
      },
      labelAlign: 'right'
    };


    return (
      <div style={{width: '80%', textAlign: 'center', padding: 15}}>
        <Breadcrumb style={{textAlign: 'left'}}>
          <Breadcrumb.Item>
            <a onClick={() => {
              this.props.history.goBack();
            }}>开班管理</a>
          </Breadcrumb.Item>
          <Breadcrumb.Item>新建班级</Breadcrumb.Item>
        </Breadcrumb>
        <Form layout="horizontal" style={{marginTop: 10}}>
          <Row gutter={16}>
            <Col span={5}>
              <Title>基础信息</Title>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="班级名称">
                {getFieldDecorator('fullName', {
                  rules: [{ required: true, message: '' }],
                })(<Input placeholder="请输入班级名称" />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="实操培训时间">
                {getFieldDecorator('date', {
                  rules: [{ required: true, message: '请选择实操培训时间' }],
                })(<RangePicker
                  disabledDate={current => {
                  }}
                  format="YYYY-MM-DD"
                />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="考场联系人">
                {getFieldDecorator('contactName', {
                  rules: [{ required: true, message: '请输入考场联系人' }],
                })(<Input placeholder="请输入考场联系人" />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="联系电话">
                {getFieldDecorator('contactPhone', {
                  rules: [{ required: true, message: '请输入联系电话' }],
                })(<Input placeholder="请输入联系电话" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="其他联系方式">
                {getFieldDecorator('otherContactPhone', {
                  rules: [{ required: false }],
                })(<Input placeholder="其他联系方式" />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="联系人邮箱">
                {getFieldDecorator('contactEmail', {
                  rules: [{ required: false }],
                })(<Input placeholder="联系人邮箱" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout1} label="实操培训地点">
                {getFieldDecorator('address', {
                  rules: [
                    {
                      required: true,
                      message: '请输入实操培训地点',
                    },
                  ],
                })(<Input.TextArea rows={4} placeholder="请输入实操培训地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={24}>
              <Form.Item {...formItemLayout1} label="注意事项">
                {getFieldDecorator('attention', {
                  rules: [
                    {
                      required: true,
                      message: '注意事项',
                    },
                  ],
                })(<Input.TextArea rows={4} placeholder="注意事项" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={5}>
              <Title>结业考试</Title>
            </Col>
            <Col span={19}>
            <em style={{ color: '#F59A23', marginLeft: 15, fontSize: 14, display: 'block', textAlign: 'left'}}>注：班级信息提交后，需经公安人员审核，预计1~2个工作日完成审核，请提前安排好开班、考试时间，以免影响考试正常安排。</em>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="理论考试时间">
                {getFieldDecorator('graduateComputerDate', {
                  initialValue: [],
                  rules: [{ required: true, message: '请选择理论考试时间' }],
                })(<RangePicker
                  disabledDate={current => {
                    // return current > moment().endOf('day')
                    // return current && current > moment().endOf('day')
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD"
                />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="理论考试地点">
                {getFieldDecorator('graduateComputerAddress', {
                  rules: [{ required: true, message: '请输入理论考试地点' }],
                })(<Input placeholder="理论考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="考试方式">
                {getFieldDecorator('graduateComputerMode', {
                  initialValue: "3",
                  rules: [{ required: true, message: '请选择考试方式' }],
                })(
                  <Select>
                    <Option disabled value="1">线下</Option>
                    <Option disabled value="2">web</Option>
                    <Option value="3">app</Option>
                  </Select>
                )}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="考试试卷">
                {getFieldDecorator('paperId', {
                  rules: [{ required: true, message: '考试试卷' }],
                })(<Input placeholder="考试试卷" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="实操考试时间">
                {getFieldDecorator('graduatePracticeDate', {
                  initialValue: [],
                  rules: [{ required: true, message: '请选择实操考试时间' }],
                })(<RangePicker
                  disabledDate={current => {
                    // return current > moment().endOf('day')
                    // return current && current > moment().endOf('day')
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD"
                />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="实操考试地点">
                {getFieldDecorator('graduatePracticeAddress', {
                  rules: [{ required: true, message: '请输入实操考试地点' }],
                })(<Input placeholder="请输入实操考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={5} style={{ textAlign: 'right', marginTop: 5 }}>
              <em>
                <span style={{ color: '#f5222d' }}>*</span>
                合格条件:
              </em>
            </Col>
            <Col span={19} style={{textAlign: 'left'}}>
              <label>
                理论成绩>=
                <Input
                  defaultValue={outFormData.graduateComputerScoreLimit}
                  onChange={(e) => {
                    this._setOutField('graduateComputerScoreLimit', e.target.value);
                  }}
                  style={{ width: 60, border: (this.state.licked && !outFormData.graduateComputerScoreLimit) ?'1px solid #f5222d': '1px solid #d9d9d9' }} placeholder="" />
              </label>
              <label>
                分且实操成绩>=
                <Input
                  defaultValue={outFormData.graduatePracticeScoreLimit}
                  onChange={(e) => {
                    this._setOutField('graduatePracticeScoreLimit', e.target.value);
                  }}
                  style={{ width: 60, border: (this.state.licked && !outFormData.graduatePracticeScoreLimit) ?'1px solid #f5222d': '1px solid #d9d9d9' }} placeholder="" 
                />
              </label>
              分，则为合格。
            </Col>
          </Row>

          <br />
          <Row gutter={16}>
            <Col span={5}>
              <Title>鉴定考试</Title>
            </Col>
            <Col span={19}>
            <em style={{ color: '#F59A23', marginLeft: 15, fontSize: 14, display: 'block', textAlign: 'left'}}>注：鉴定-理论考试默认采用线下纸质考试，届时考试成绩产出后，可导入到系统中。</em>
            </Col>
          </Row>      
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="理论考试时间">
                {getFieldDecorator('identifyComputerDate', {
                  initialValue: [],
                  rules: [{ required: true, message: '请选择理论考试时间' }],
                })(<RangePicker
                  disabledDate={current => {
                    // return current > moment().endOf('day')
                    // return current && current > moment().endOf('day')
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD"
                />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="理论考试地点">
                {getFieldDecorator('identifyComputerAddress', {
                  rules: [{ required: true, message: '请输入理论考试地点' }],
                })(<Input placeholder="请输入理论考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16}>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="实操考试时间">
                {getFieldDecorator('identifyPracticeDate', {
                  initialValue: [],
                  rules: [{ required: true, message: '请输入实操考试时间' }],
                })(<RangePicker
                  disabledDate={current => {
                    // return current > moment().endOf('day')
                    // return current && current > moment().endOf('day')
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD"
                />)}
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item {...formItemLayout} label="实操考试地点">
                {getFieldDecorator('identifyPracticeAddress', {
                  rules: [{ required: true, message: '请输入实操考试地点' }],
                })(<Input placeholder="请输入实操考试地点" />)}
              </Form.Item>
            </Col>
          </Row>
          <Row gutter={16} style={{textAlign: 'left'}}>
            <Col span={5} style={{ textAlign: 'right', marginTop: 5 }}>
              <em>
                <span style={{ color: '#f5222d' }}>*</span>
                合格条件:
              </em>
            </Col>
            <Col span={19}>
              <label>
                理论成绩>=
                <Input
                  defaultValue={outFormData.identityComputerScoreLimit}
                  onChange={(e) => {
                    this._setOutField('identityComputerScoreLimit', e.target.value);
                  }}
                  style={{ width: 60, border: (this.state.licked && !outFormData.identityComputerScoreLimit) ?'1px solid #f5222d': '1px solid #d9d9d9' }}  placeholder="" />
              </label>
              <label>
                分且实操成绩>=
                <Input
                  defaultValue={outFormData.identityPracticeScoreLimit}
                  onChange={(e) => {
                    this._setOutField('identityPracticeScoreLimit', e.target.value);
                  }}
                  style={{ width: 60, border: (this.state.licked && !outFormData.identityPracticeScoreLimit) ?'1px solid #f5222d': '1px solid #d9d9d9'}} placeholder="" />
              </label>
              分，则为合格。
            </Col>
            <Col span={3}><span></span></Col>
          </Row>
          
        </Form>
        <section style={{marginTop: 30}}>
          <Button onClick={() => {
            this.props.history.goBack();
          }}>返回上一页</Button>
          <Button onClick={() => {
            this._submitData();
          }} type="primary" style={{marginLeft: 15}}>下一步</Button>
        </section>
      </div> 
    );
  }
}

const Title = st.div`
  font-size: 16px;
  text-align: right;
  font-weight: bold;
`;