import React, { Component } from "react";
import { connect } from "dva";

import { Tabs } from "antd";
import Uninsured from "./Uninsured";
import Insured from "./Insured";
import NotInput from "./NotInput";
import { gup } from '../../../../utils/utils';
const { TabPane } = Tabs;

@connect(state => ({
  insurance: state.insurance,
  global: state.global
}))
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      uninsureTotal: 0,
      insureTotal: 0,
      activeKey: '1',

      updateUninsured: 0,  //数字变化的时候更新列表（未投保）
      updateInsured: 0,  //已投保
      notInputTotal: 0,
    };
  }
  componentWillMount() {
    const activeKey = gup('tab');
    if (activeKey) {
      this.setState({
        activeKey
      });
    }
    // 从redux中获取是否是第一次进入的值
    const { isShowQuitModal } = this.props.insurance;
    // 第一次进入的时候需要弹窗   && 是服务公司或者自行招用保安单位才要弹窗
    if (
      isShowQuitModal &&
      (this.props.global.companyInfo.institutionType == '0102' ||
        this.props.global.companyInfo.institutionType == '0104')
    ) {
      this.props.dispatch({
        type: 'insurance/showQuitModal',
        payload: {
          title: '保险减员提示',
          warningText: '*保险产品的新增、减员等操作可通过【人员投保管理】-【未投保】【已投保】选择相应人员进行保全增减操作！',
          contentText: '存在在保的离职人员共count位,请及时对离职人员办理保险保全的减员操作，以降低保险成本！',
          okCallBack: () => {
            this.setState({
              activeKey: '1', //自动切换到未投保tab
            });
          }
        }
      });
    }
  }


  render() {
    return (
      <div style={{ paddingTop: '10px' }}>
        <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          activeKey={this.state.activeKey}
          onChange={(activeKey) => {
            this.setState({
              activeKey
            });
          }}
        >
          <TabPane tab={`未投保（${this.state.uninsureTotal}）`} key="1">
            <Uninsured
              total={this.state.uninsureTotal}
              changeTabIndex={() => {
                // 从未投保到已投保的时候自动跳转到已投保页面
                this.setState({
                  activeKey: '2'
                });
              }}
              updateNum={this.state.updateUninsured}
              getTotal={total => {
                if (total == this.state.uninsureTotal) return;
                let { updateInsured } = this.state;
                this.setState({
                  uninsureTotal: total,
                  updateInsured: ++updateInsured
                });
              }}
            />
          </TabPane>
          <TabPane forceRender
            tab={`已投保（${this.state.insureTotal}）`}
            key="2"
          >
            <Insured
              ref="insured"
              total={this.state.insureTotal}
              updateNum={this.state.updateInsured}
              getTotal={(total) => {
                if (total == this.state.insureTotal) return;
                let { updateUninsured } = this.state;
                this.setState({
                  insureTotal: total,
                  updateUninsured: ++updateUninsured
                });
              }}
            />
          </TabPane>
          <TabPane forceRender
            tab={`已投保未录入(${this.state.notInputTotal})`}
            key="3"
          >
            <NotInput getTotal={(total) => {
              this.setState({
                notInputTotal: total
              });
            }} />
          </TabPane>
          {/* <TabPane tab="已过滤（21）" key="3">
            <SendRecord />
          </TabPane> */}
        </Tabs>
      </div>
    );
  }
}
