import React, { PureComponent } from 'react';
import style from "styled-components";
import { Card ,List, Avatar,Table,Button } from 'antd';
import "./InsuranceMangerment.less";
import TitleBlue from '../../../assets/images/title_blue.png';
import TitleYellow from '../../../assets/images/title_yellow.png';
import {
  getOnlineInsBlbLink,//在线购买保险
  enterpriseInsComInsGetBootSchemePdfLink,//方案书pdf下载
} from "../../../services/api";
import store from "store";
export default class GxPolicepingan3 extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      onlineUrl: "",//购买在线保险的url  
      province:"", 
      downbookUrl:"",//方案书下载
    };
  }
  componentDidMount() {
    //初始化参数，修复页面切换参数不会初始化的bug！！
    this.messageOnline();
  }
    //在线购买保险的链接生成
    messageOnline = () => {
      getOnlineInsBlbLink({
        // comId: this.props.global.companyInfo.comId
      }).then(data => {
        this.setState({
          onlineUrl: data.data
        });
      });
    };
        ////方案书pdf下载
        getpdfbook = () => {
          enterpriseInsComInsGetBootSchemePdfLink({
            proCode:store.get("bookpdf")["proCode"],
            province:store.get("bookpdfs")["regProvince"],
          }).then(data => {  
            this.setState({
              downbookUrl: data.data
            });
            console.log("方案书pdf下载",data.data);
          });
        };   
        downBookClick = () => {
          window.open(this.state.downbookUrl);
        }
    handleonline = () => {
      window.open(this.state.onlineUrl);
    }
    handleotherbook = () => {
      this.props.history.push(
        // 跳转到1-4-4
        // "/Organization/departmentmanagement?otherbook=init"
        "/PersonnelRecruitment/departmentmanagement?otherbook=init"
      );

    }  
  render() {
    const contentdata = [
      {
        title:  <span>预计投保人数：{store.get("bookNum")["comPerNum"]}人</span>,
        description:<div className="totalcost">
                      <img src={TitleYellow} className="totalcostimg"/>
                      <span className="totalcostcount">预估保费：</span>
                      <span>{(store.get("bookNum")["comPerNum"]) * 330}元</span>
                      <span className="totalcostremark">&nbsp;（企业人数*该方案保费/人）</span>
                    </div>,
      },
      {
        title: '产品优势',
        description:'中高保障版，对保安人员全年工作、生活、交通出行的意外风险提供全方位保障，附加烈士褒扬金，保安人员的护身盾牌。',
      },
    ];
    const servicedata = [
        {
          title: '2项后续服务',
          description:<div>
                        <p>1、人员增减服务</p>
                        <p>1.支持在线完成人员增、减、替换，方便快捷。</p>
                        <p>2.账单式管理，人员批改明细一目了然。</p>
                        <p>3.专业客服7x24小时在线为您服务。</p>
                        <p>2、理赔咨询</p>
                        <p>1.在线自助报案，1对1理赔专员全程协助处理。</p>
                        <p>2.在线上传理赔资料，专业评估师为您争取更多利益。</p>
                        <p>3.最快当天内赔付，理赔实时进度尽在掌握。</p>
                      </div>,
        },
        {
          title: <span>3项<span style={{color:"#FF420F"}}>免费</span>增值服务</span>,
          description:<div>
                        <p>1、在线培训服务</p>
                        <p>精心打造可供保安员随时随地学习的在线高品质保安培训课程，并提供在线职业化考试及颁证。</p>
                        <p>2、人员管理服务</p>
                        <p>对保安员从进入保安服务公司到离职全过程进行电子化管理，包括个人信息、薪资变动、职位变动、奖惩情况、培训情况、考核数据、考勤数据等管理。</p>
                        <p>3、任务管理服务</p>
                        <p>依托LBS（基于位置的服务）应用，首创“任务派发、接收、轨迹跟踪地图可视化”全程动态管理模式。</p>
                      </div>,
        },
      ];
    const columns = [{
      title: '保险责任',
      dataIndex: 'name',
      render: text => <a >{text}</a>,
    }, {
      title: '保额',
      className: 'column-money',
      dataIndex: 'money',
    }];
    const liabilitydata = [{
      key: '1',
      name: '意外身故',
      money: '40万元',
    }, {
      key: '2',
      name: '意外伤残',
      money: '40万元',
    }, {
      key: '3',
      name: '意外医疗',
      money: '4万元 ',
    }, {
      key: '4',
      name: '意外住院津贴',
      money: '120元/天 ',
    }, {
      key: '5',
      name: '烈士褒扬金',
      money: '30 万元',
    },{
        key: '6',
        name: '营运汽车意外身故/伤残',
        money: '10万元',
      }, {
        key: '7',
        name: '轨道列车意外身故/伤残',
        money: '20万元',
      }, {
        key: '8',
        name: '飞机意外身故/伤残',
        money: '40万元 ',
      }, {
        key: '9',
        name: '轮船意外身故/伤残',
        money: '20万元 ',
      }, {
        key: '10',
        name: '保费',
        money: '330元/人',
      }];
    return (
      <Container className="insurancescheme">
      <h3 className="insurancetitle">平安是福保安团意险计划三</h3>
        <p className="policytext">
            <span>政策要求：</span><br />
            <span>根据《保安服务管理条例》第四章第二十条规定，推进落实保安从业单位根据保安服务岗位的风险程度为保安员投保意外伤害保险，
                保险保障额度应当<i>不低于广西省人身损害赔偿标准（约38万）</i>，并通过保安服务监管信息系统将投保情况实时向公安机关报备。</span>
        </p>
        <p className="insurancetext">
          <span>尊敬的XXXX保安公司：</span>
          <br />
          <span>感谢您对平安是福保安团意险计划三的亲睐！ ！ ！</span>
          <br />
          <span>产品方案请细看</span>
        </p>
        <Card title="平安是福保安团意险计划三">
          <Table
            columns={columns}
            dataSource={liabilitydata}
            bordered
            pagination={false}
          />
          <List
          itemLayout="horizontal"
          dataSource={contentdata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<span>{item.title}</span>}
                description={item.description}
              />
            </List.Item>
          )}
          />
        </Card>
        <Card title="投保后您可享有“2+3”服务">
          <List
          itemLayout="horizontal"
          dataSource={servicedata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
        />
        </Card>
        <div className="customerservice">
          <div className="customerservicetotle">
            <span className="customerservicetext">如有疑问，欢迎拨打百保盾客服电话：</span>
            <span className="customerservicephone">400-662-9696</span>
          </div>
          <div className="customerservicebtn">
            <Button onClick={this.downBookClick}>下载PDF</Button>
            <Button
            onClick={() => {
              window.print();
            }}
            >在线打印</Button>
            <Button onClick={this.handleotherbook}>获取其他方案</Button>
            <Button type="primary" onClick={this.handleonline}>立即购买</Button>
          </div>
        </div>
        {this.getpdfbook}
      </Container>
    );
  }
}

const Container = style.div`
  padding:24px;
  .insurancetitle{
    padding-bottom:13px;
    border-bottom: 1px solid #e8e8e8;
    font-size: 20px;
    color: #333333;
    font-weight:bold;
    font-family: PingFangSC-Medium;
  }
  .insurancetext{
    font-family: PingFangSC-Medium;
    font-size: 14px;
    color: #666666;
  }
  .policytext{
      span{
          i{
            font-style:normal;
            color: #FF420F;
          }
      }
  }
  .ant-card{
    margin-top:15px;
  }
  .ant-card-body{
    padding:5px 12px;
  }
  .ant-card-head{
    background-color:#F5F9FF;
    padding:0;
  }
  .ant-card-head-title{
    margin-left:24px;
    color:#666666;
    font-weight:bold;
  }
  .ant-list-item-meta-avatar{
    width: 6px;
    height:6px;
    position:relative;
    top:7px;
    left:10px;
  }
  .ant-avatar{
    width: 6px;
    height:6px;
  }
  .ant-list-item-meta-title>a{
    color:#0F71FF;
  }
  .ant-list-item-meta-description{
    font-size:12px;
    color:#666666;
  }
  .ant-list-item-meta-description div p{
    margin-bottom: 0px;
    fontSize: 12px;
  }
  .totalcost{
    font-size:14px;
    color:#FF420F;
    margin-left:-12px;
  }
  .totalcostimg{
    margin-top:-3px;
  }
  .totalcostcount{
    margin-left:6px;
  }
  .totalcostremark{
    color:#2A2A2A;
  }
  .ant-table-thead tr th{
    color:#333333 ;
    font-size:12px;
    font-weight:bold;
   
  }
  .ant-table-row td{
    color:#666666 ;
    font-size:12px;
  }
  .ant-table-row td a{
    color:#666666 ;
    font-size:12px;
  }
  th.column-money,
  td.column-money {
    text-aligh:center;
  }
  .ant-table-wrapper{
    padding:10px 10px 0 10px;
  }
  .ant-table-tbody tr:nth-of-type(5) td:nth-of-type(1) a{
    color:#FF420F;
  }
  .ant-table-tbody tr:nth-of-type(5) td:nth-of-type(2){
    color:#FF420F;
  }
  .ant-table-tbody tr:nth-of-type(10) td:nth-of-type(2){
    color:#FF420F;
  }
  .customerservicetext{
    font-family: PingFangSC-Regular;
    font-size: 14px;
    color: #333333;
  }
  .customerservicephone{
    font-family: PingFangSC-Regular;
    font-size: 20px;
    color: #0F71FF;
  }
  .customerservice{
    padding:15px 0;
  }
  .customerservicetotle{
    float:left;
  }
  .customerservicebtn{
    float:right;
  }
  .customerservicebtn button{
    margin-left:5px;
  }
`;
