import React, { Component } from 'react';
// import st from 'styled-components';
import { getPerOpenJointlyInfo } from '../../../services/apiSmartCard';
import Opened from './Opened';
import NotOpen from './NotOpen';
// import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Tabs
} from 'antd';


const { TabPane } = Tabs;

// @connect(state => ({
//   global: state.global
// }))
@withRouter
export default class SmartCard extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      noOpenJointlyPerCount: 0,
      openJointlyPerCount: 0
    };
  }

  componentDidMount() {

  }
  componentWillMount() {
    this._getJointlyInfo();
  }
  // 获取数量
  _getJointlyInfo = () => {
    getPerOpenJointlyInfo().then(res => {
      const { noOpenJointlyPerCount, openJointlyPerCount } = res.data;
      this.setState({
        noOpenJointlyPerCount,
        openJointlyPerCount
      })
    });
  }


  render() {
    const { noOpenJointlyPerCount, openJointlyPerCount } = this.state;
    return (
      <div style={{ padding: '0 24px' }}>
        <Tabs defaultActiveKey="1" onChange={() => { }}>
          <TabPane tab={`未开通(${noOpenJointlyPerCount})`} key="1" forceRender>
            <NotOpen updateCount={this._getJointlyInfo} />
          </TabPane>
          <TabPane updateCount={this._getJointlyInfo} tab={`已开通(${openJointlyPerCount})`} key="2" forceRender>
            <Opened />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}