/* *
* @props perId
* @props visibale
* @props onSelect
* @props onClose
 */
import React, { Component } from 'react';
import moment from 'moment';
import {
  Modal,
  Form,
  Input,
  Button
} from 'antd';
import PSelect from '../../Pro/PSelect';
import PTable from '../../Pro/PTable';
import contranctCol from './contranctCol';
// @withRouter
@Form.create()
export default class ContranctModal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      pageParm: {
        perId: this.props.perId, 
        searchComId: this.props.saasComId,
        pageNumber: 1, 
        pageSize: 10,
        keyWord: '',
        contractType: ''
      },
      forceUpdate: false,
      selectedRowKeys: [],
      selectedRows: [],
    };
  }

  componentWillReceiveProps(nextProps) {
    if(!!nextProps.perId) {
      const pageParm = {
        ...this.state.pageParm,
        perId: nextProps.perId
      };
      if(nextProps.onlySearchPerId) {
        pageParm.onlySearchPerId = nextProps.onlySearchPerId;
      }
      this.setState({
        pageParm
      });
    }
    if(!nextProps.visibale) {
      this.setState({
        selectedRowKeys: [],
        selectedRows: []
      });
    }
  }

  render() {
    const { getFieldDecorator, resetFields, getFieldsValue } = this.props.form;
    const columns = contranctCol.call(this);
    // columns.unshift({

    // });
    return (
      <Modal
          width="80%"
          title="选择合同"
          visible={this.props.visibale}
          destroyOnClose={true}
          onOk={() => {
            // selectedRows
            if(this.state.selectedRows.length == 0) {
              Modal.error({
                title: '请选择合同',
                okText: '确定'
              });
            }else {
              const { effectStartDate, effectEndDate } = this.state.selectedRows[0];
              const oneYearNum = 365 * 24 * 60 * 60 * 1000;
              const startDateNum = moment(effectStartDate).valueOf();
              const dndDateNum = moment(effectEndDate).valueOf()+24*60*60*1000;//多宽限一天，比如2020-03-03~2021-03-02这个日期也可以接受
              if(this.props.type && this.props.type=='zigezheng'){
                //这里是资格证报名的新增，不需要加有效期的校验
              }else{
                if(oneYearNum > dndDateNum - startDateNum) {
                  return Modal.error({
                    title: '该合同有效期不足1年',
                    content: '需关联合同有效期1年以上的合同。',
                    okText: '确定'
                  });
                }
              }
              this.props.onSelect && this.props.onSelect(this.state.selectedRows);
              this.props.onClose && this.props.onClose();
            }
          }}
          onCancel={() => {
            this.props.onClose && this.props.onClose();
          }}
        >
          {/* {this.props.children} */}
          <Form layout="inline">
            <Form.Item label="关键词">
              {getFieldDecorator('keyWord', {
                initialValue: ''
              })(
                <Input placeholder="请输入关键词" />
              )}
            </Form.Item>
            <Form.Item label="合同类型">
              {getFieldDecorator('contractType', {
                initialValue: ''
              })(
                <PSelect
                    style={{ width: 214, marginBottom: '16px' }}
                    type="contractType"
                    addOption
                    cache={false}
                  />
              )}
            </Form.Item>
            <Form.Item label=" " colon={false}>
              <Button type="primary" onClick={e => {
                e && e.preventDefault();
                this.props.form.validateFields((err, values) => {
                  this.setState({
                    pageParm: {
                      ...this.state.pageParm,
                      ...values
                    }
                  });
                });
              }}>搜索</Button>
            </Form.Item>
            <Form.Item label=" " colon={false}>
              <Button onClick={() => {
                resetFields();
                const values = getFieldsValue();
                setTimeout(() => {
                  this.setState({
                    pageParm: {
                      ...this.state.pageParm,
                      ...values
                    }
                  });
                });
              }}>重置</Button>
            </Form.Item>
          </Form>
          {
            !!this.state.pageParm.perId &&
            <PTable
              style={{ marginTop: 20 }}
              columns={columns}
              url="getComContractListByPerId"
              pageParm={this.state.pageParm}
              forceUpdate={this.state.forceUpdate}
              // filterData={data => {
              //   // 只显示有效的合同
              //   return data.filter(item => {
              //     return item.contractEffect == '有效';
              //   });
              // }}
              rowSelection={{
                onChange: (selectedRowKeys, selectedRows) => {
                  this.setState({
                    selectedRows,
                    selectedRowKeys
                  });
                },
                type: 'radio',
                selectedRowKeys: this.state.selectedRowKeys
              }}
            />

          }
        </Modal>
    );
  }
}

export const colFn = contranctCol;
