
import { Badge } from 'antd';
export default function() {
  
  return [
    {
      title: '合同名称',
      dataIndex: 'contractName',
      key: 'contractName',
    },
    {
      title: '合同类型',
      dataIndex: 'contractType',
      key: 'contractType',
    },
    {
      title: '企业档案编号',
      dataIndex: 'comFileNo',
      key: 'comFileNo',
    },
    {
      title: '乙方名称',
      dataIndex: 'secondPartyName',
      key: 'secondPartyName',
    },
    {
      title: '合同有效期',
      dataIndex: 'effectEndDate',
      render: (text, record) => {
        return `${record.effectStartDate}~${record.effectEndDate}`;
      }
    },
    {
      title: '合同状态',
      dataIndex: 'contractEffect',
      key: 'contractEffect',
      // width: 100,
      render: (text, record) => {
        let status = '';
        switch (true) {
          case text == '未生效':
            status = 'warning';
            break;
          case text == '有效':
            status = 'success';
            break;
          case text == '终止':
            status = 'error';
        }

        return (
          <div>
            <Badge status={status} />
            <span>{text}</span>
          </div>
        );
      }
    },
    // {
    //   title: '操作',
    //   dataIndex: 'op',
    //   key: 'op',
    //   render: () => {
    //     return (
    //       <a>移除关联</a>
    //     )
    //   }
    // },
  ];
}