import requestHuawei from "@/api/requestHuawei";

let user_id = JSON.parse(localStorage.getItem("huaweiInfo"))?.userId;

// 获取设备列表
export function getDeviceList(user_id) {
  return requestHuawei({
    url: `/v1/${user_id}/devices`,
    method: "GET",
    params: {},
  });
}

// 获取设备通道列表
export function getDeviceChannelList(device_id) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${device_id}/channels`,
    method: "GET",
    params: {},
  });
}

// 查询通道列表
export function getChannelList(channel_name, protocol="GB28181", state="ONLINE") {
  return requestHuawei({
    url: `/v1/${user_id}/channels?access_protocol=${protocol}&channel_state=${state}&channel_name=${channel_name}`,
    method: "GET",
    params: {},
  });
}

// 获取设备信息
export function getDeviceInfo(device_id) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${device_id}`,
    method: "GET",
    params: {},
  });
}

// 获取设备在线状态
export function getDeviceStatus(device_id) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${device_id}/status`,
    method: "GET",
    params,
  });
}

// 获取云台控制权
export function getPtzControlPower(data) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/control-token`,
    method: "GET",
    params: {},
  });
}

// 云台控制
export function ptzControl(data) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/ptz/angle-spin`,
    method: "POST",
    data: data.direction,
  });
}

// 停止云台控制
export function stopPtzControl(data) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/ptz/stop`,
    method: "POST",
    data: data.direction,
  });
}

// 获取预置位列表
export function getPresetList(params) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${params.device_id}/channels/${params.channel_id}/presets`,
    method: "GET",
    params: {},
  });
}

// 设置预置位
export function setPreset(data) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/presets`,
    method: "POST",
    data,
  });
}

// 调用预置位
export function callPreset(data) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/presets/${data.preset_index}/goto`,
    method: "POST",
    data,
  });
}

// 删除预置位
export function deletePreset(data) {
  return requestHuawei({
    url: `/v1/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/presets/${data.preset_index}`,
    method: "DELETE",
    data,
  });
}


// 获取直播流地址
export function getLiveStream(data) {
  return requestHuawei({
    url: `/v2/${user_id}/devices/channels/media/live-connections`,
    method: "POST",
    data: {
      ...data,
      expire_time: 86400,
      use_times: 1
    },
  });
}

// 根据设备组名称查询设备组织树
export function getOrgId(device_org_name) {
  return requestHuawei({
    url: `/v1/${user_id}/device-orgs/tree?device_org_name=${device_org_name}`,
    method: "GET",
    params: {},
  });
}

// 查询企业下组织的设备列表
export function getDeviceListByOrgId(device_org_id) {
  return requestHuawei({
    url: `/v1/${user_id}/device-orgs/${device_org_id}/devices`,
    method: "GET",
    params: {},
  });
}

// 获取录像回放地址
export function getPlaybackRecord(data) {
  return requestHuawei({
    url: `/v2/${user_id}/devices/${data.device_id}/channels/${data.channel_id}/media/playback-connections`,
    method: "GET",
    params: {
      ...data.params,
      record_position: "CLOUD",
      expire_time: 86400,
      use_times: 1,
      // stream_type: "PRIMARY_STREAM",
      // record_type: "ALL_RECORD"
    }
  });
}

// 回放控制
export function playbackControl(data) {
  return requestHuawei({
    url: `/v2/${user_id}/media/control/recordctl`,
    method: "POST",
    data,
  });
}