import request from "@/api/request";

//获取驻勤点类型
export function getAllStationTypes(params) {
  return request({
    url: "/security-stations/station-types",
    method: "POST",
    data: params,
  });
}

//获取活动临保人员类型
export function getAllActEmployeeTypes(data) {
  return request({
    url: "/security-stations/station-types",
    method: "POST",
    data,
  });
}

//获取驻勤点信息
export function getStations(data) {
  return request({
    url: "/security-stations/search",
    method: "POST",
    data,
  });
}

//获取驻勤点详细信息
export function getStationDetail(stationId) {
  return request({
    url: "/security-stations/" + stationId,
    method: "GET",
  });
}

//点名管理-驻勤点统计信息
export function getStationStatistics(data) {
  return request({
    url: "/security-stations/statistics-search",
    method: "POST",
    data,
  });
}

//获取驻勤点基本信息
export function getBasicStations(data) {
  return request({
    url: "/security-stations/basic-search",
    method: "POST",
    data,
  });
}

//搜索考场/驻勤点/岗点的设备信息
export function getStationOrExamDevices(data) {
  return request({
    url: "/station-devices/search",
    method: "POST",
    data,
  });
}
